/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGDSVariablesIF;
import ucar.grib.GribIndexName;
import ucar.grib.GribIndexReader;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1GDSVariables;
import ucar.grib.grib2.Grib2Data;
import ucar.grib.grib2.Grib2GDSVariables;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Pds;
import ucar.grib.grib2.Grib2Product;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grid.GridIndex;
import ucar.unidata.io.RandomAccessFile;

public class Grib2WriteIndex {
    private static boolean debugTiming = false;
    private static boolean verbose = false;
    private static boolean checkPDS = true;
    private static pdsLogType logPDS = pdsLogType.logger;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static int indexRafBufferSize = 300;
    private static boolean maintainIndexType = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex writeGribIndex(File grib, String gribName, String gbxName, boolean makeIndex) throws IOException {
        RandomAccessFile raf = null;
        logPDS = pdsLogType.systemout;
        try {
            raf = new RandomAccessFile(gribName, "r");
            raf.order(0);
            GridIndex gridIndex = this.writeGribIndex(grib, gbxName, raf, makeIndex);
            return gridIndex;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex writeGribIndex(File grib, String gbxName, RandomAccessFile raf, boolean makeIndex) throws IOException {
        boolean success;
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(gbxName, false)));
            success = this.writeGribIndex(raf, grib.lastModified(), out);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        if (success && makeIndex) {
            try {
                Thread.sleep(2000L);
                return new GribIndexReader().open(gbxName);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeGribIndex(RandomAccessFile inputRaf, long rafLastModified, DataOutputStream out) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = Calendar.getInstance().getTime();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib2WriteIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(indexRafBufferSize);
        try {
            inputRaf.seek(0L);
            Grib2Input g2i = new Grib2Input(inputRaf);
            g2i.scan(true, false);
            out.writeLong(rafLastModified);
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 8.0");
            sb.append(" grid_edition 2");
            sb.append(" location " + inputRaf.getLocation().replaceAll(" ", "%20"));
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            Date baseTime = null;
            List<Grib2Product> products = g2i.getProducts();
            if (checkPDS) {
                HashMap<Long, Integer> pdsMap = new HashMap<Long, Integer>();
                ArrayList<Integer> duplicate = new ArrayList<Integer>();
                CRC32 crc32 = new CRC32();
                for (int i = 0; i < products.size(); ++i) {
                    Grib2Product product = products.get(i);
                    crc32.reset();
                    crc32.update(product.getPDS().getPdsVars().getPDSBytes());
                    ByteBuffer bb = ByteBuffer.allocate(12);
                    bb.putInt(product.getDiscipline());
                    bb.putLong(product.getRefTime());
                    crc32.update(bb.array());
                    long crcv = crc32.getValue();
                    Integer recnum = (Integer)pdsMap.get(crcv);
                    if (recnum != null) {
                        StringBuilder str = new StringBuilder("Duplicate record with Discipline ");
                        str.append(product.getDiscipline());
                        if (!this.check2Products(inputRaf, products.get(recnum), product, str)) continue;
                        duplicate.add(recnum);
                        pdsMap.put(crcv, i);
                        str.append(" at file position " + i + " verses " + recnum);
                        if (logPDS.equals((Object)pdsLogType.systemout)) {
                            System.out.println(str.toString());
                            continue;
                        }
                        if (!logPDS.equals((Object)pdsLogType.logger)) continue;
                        this.log.info(str.toString());
                        continue;
                    }
                    pdsMap.put(crcv, i);
                }
                if (duplicate.size() > 0) {
                    StringBuilder str = new StringBuilder(inputRaf.getLocation());
                    str.append(" has Percentage of duplicates ");
                    str.append((int)((double)duplicate.size() / (double)products.size() * 100.0 + 0.5));
                    str.append("%, duplicates =");
                    str.append(duplicate.size());
                    str.append(" out of ");
                    str.append(products.size());
                    str.append(" records.");
                    if (logPDS.equals((Object)pdsLogType.systemout)) {
                        System.out.println(str.toString());
                    } else if (logPDS.equals((Object)pdsLogType.logger)) {
                        this.log.info(str.toString());
                    }
                    Collections.sort(duplicate, new CompareKeyDescend());
                    Iterator i$ = duplicate.iterator();
                    while (i$.hasNext()) {
                        int idx = (Integer)i$.next();
                        products.remove(idx);
                    }
                }
            }
            for (int i = 0; i < products.size(); ++i) {
                Grib2Product product = products.get(i);
                Grib2ProductDefinitionSection pds = product.getPDS();
                Grib2IdentificationSection id = product.getID();
                if (i == 0) {
                    sb.append(" center " + id.getCenter_id());
                    sb.append(" sub_center " + id.getSubcenter_id());
                    sb.append(" table_version " + id.getLocal_table_version());
                    baseTime = product.getBaseTime();
                    sb.append(" basetime " + dateFormat.format(baseTime));
                    sb.append(" ensemble ");
                    sb.append(pds.getPdsVars().isEnsemble() ? "true" : "false");
                    out.writeUTF(sb.toString());
                    out.writeInt(products.size());
                    if (verbose) {
                        System.out.println("Index created with number records =" + products.size());
                    }
                }
                out.writeInt(product.getDiscipline());
                out.writeLong(product.getRefTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getGdsOffset());
                out.writeLong(product.getPdsOffset());
                int length = pds.getPdsVars().getPDSBytes().length;
                out.writeInt(length);
                out.write(pds.getPdsVars().getPDSBytes(), 0, length);
                ++count;
            }
            Map<String, Grib2GridDefinitionSection> gdsHM = g2i.getGDSs();
            Set<String> keys = gdsHM.keySet();
            out.writeInt(keys.size());
            for (String key : keys) {
                Grib2GridDefinitionSection gds = gdsHM.get(key);
                int length = gds.getGdsVars().getGDSBytes().length;
                out.writeInt(length);
                out.write(gds.getGdsVars().getGDSBytes(), 0, length);
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
            boolean bl = false;
            return bl;
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex extendGribIndex(File grib, File gbx, String gribName, String gbxName, boolean makeIndex) throws IOException {
        RandomAccessFile raf = null;
        logPDS = pdsLogType.systemout;
        try {
            raf = new RandomAccessFile(gribName, "r");
            raf.order(0);
            GridIndex gridIndex = this.extendGribIndex(grib, gbx, gbxName, raf, makeIndex);
            return gridIndex;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex extendGribIndex(File grib, File gbx, String gbxName, RandomAccessFile raf, boolean makeIndex) throws IOException {
        DataOutputStream out = null;
        boolean success = false;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(gbxName + ".tmp", false)));
            success = this.extendGribIndex(gbxName, raf, grib.lastModified(), out);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        if (!success || out.size() == 8) {
            File tidx = new File(gbxName + ".tmp");
            tidx.delete();
            gbx.setLastModified(grib.lastModified() + 1000L);
        } else {
            gbx.delete();
            File tidx = new File(gbxName + ".tmp");
            tidx.renameTo(gbx);
        }
        if (success && makeIndex) {
            try {
                Thread.sleep(2000L);
                return new GribIndexReader().open(gbxName);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean extendGribIndex(String gbxName, RandomAccessFile inputRaf, long rafLastModified, DataOutputStream out) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = Calendar.getInstance().getTime();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib2ExtendIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(indexRafBufferSize);
        try {
            ArrayList<RawRecord> recordList = new ArrayList<RawRecord>();
            HashMap<String, GribGDSVariablesIF> gdsMap = new HashMap<String, GribGDSVariablesIF>();
            boolean newversion = this.rawGridIndex(gbxName, recordList, gdsMap);
            if (newversion) {
                RawRecord rr = (RawRecord)recordList.get(recordList.size() - 1);
                inputRaf.seek(rr.offset2);
            } else {
                inputRaf.seek(0L);
            }
            Grib2Input g2i = new Grib2Input(inputRaf);
            g2i.scan(true, false);
            out.writeLong(rafLastModified);
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 8.0");
            sb.append(" grid_edition 2");
            sb.append(" location " + inputRaf.getLocation().replaceAll(" ", "%20"));
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            Date baseTime = null;
            List<Grib2Product> products = g2i.getProducts();
            if (products.size() == 0) {
                boolean bl = false;
                return bl;
            }
            if (checkPDS) {
                HashMap<Long, Integer> pdsMap = new HashMap<Long, Integer>();
                ArrayList<Integer> duplicate1 = new ArrayList<Integer>();
                ArrayList<Integer> duplicate2 = new ArrayList<Integer>();
                CRC32 crc32 = new CRC32();
                int originalSize = recordList.size();
                for (int i = 0; i < recordList.size(); ++i) {
                    RawRecord rr = (RawRecord)recordList.get(i);
                    crc32.reset();
                    crc32.update(rr.pdsData);
                    ByteBuffer bb = ByteBuffer.allocate(12);
                    bb.putInt(rr.discipline);
                    bb.putLong(rr.refTime);
                    crc32.update(bb.array());
                    pdsMap.put(crc32.getValue(), i);
                }
                Calendar cal = Calendar.getInstance();
                for (int i = 0; i < products.size(); ++i) {
                    Grib2Product product = products.get(i);
                    crc32.reset();
                    crc32.update(product.getPDS().getPdsVars().getPDSBytes());
                    ByteBuffer bb = ByteBuffer.allocate(12);
                    bb.putInt(product.getDiscipline());
                    bb.putLong(product.getRefTime());
                    crc32.update(bb.array());
                    long crcv = crc32.getValue();
                    Integer recnum = (Integer)pdsMap.get(crcv);
                    if (recnum != null) {
                        StringBuilder str = new StringBuilder("Duplicate record with Discipline ");
                        str.append(product.getDiscipline());
                        boolean pdsMatch = recnum < originalSize ? this.checkRawRecordProduct(inputRaf, (RawRecord)recordList.get(recnum), cal, product, str) : this.check2Products(inputRaf, products.get(recnum - originalSize), product, str);
                        if (!pdsMatch) continue;
                        if (recnum < originalSize) {
                            duplicate1.add(recnum);
                            pdsMap.put(crcv, i + originalSize);
                        } else {
                            duplicate2.add(recnum - originalSize);
                            pdsMap.put(crcv, i + originalSize);
                        }
                        str.append(" at file position " + (i + originalSize) + " verses " + recnum);
                        if (logPDS.equals((Object)pdsLogType.systemout)) {
                            System.out.println(str.toString());
                            continue;
                        }
                        if (!logPDS.equals((Object)pdsLogType.logger)) continue;
                        this.log.info(str.toString());
                        continue;
                    }
                    pdsMap.put(crcv, i + originalSize);
                }
                if (duplicate1.size() > 0 || duplicate2.size() > 0) {
                    StringBuilder str = new StringBuilder(inputRaf.getLocation());
                    str.append(" has Percentage of duplicates ");
                    int dups = duplicate1.size() + duplicate2.size();
                    int recs = recordList.size() + products.size();
                    str.append((int)((double)dups / (double)recs * 100.0 + 0.5));
                    str.append("%, duplicates =");
                    str.append(dups);
                    str.append(" out of ");
                    str.append(recs);
                    str.append(" records.");
                    if (logPDS.equals((Object)pdsLogType.systemout)) {
                        System.out.println(str.toString());
                    } else if (logPDS.equals((Object)pdsLogType.logger)) {
                        this.log.info(str.toString());
                    }
                }
                if (duplicate1.size() > 0) {
                    Collections.sort(duplicate1, new CompareKeyDescend());
                    Iterator i$ = duplicate1.iterator();
                    while (i$.hasNext()) {
                        int idx = (Integer)i$.next();
                        recordList.remove(idx);
                    }
                }
                if (duplicate2.size() > 0) {
                    Collections.sort(duplicate2, new CompareKeyDescend());
                    Iterator i$ = duplicate2.iterator();
                    while (i$.hasNext()) {
                        int idx = (Integer)i$.next();
                        products.remove(idx);
                    }
                }
                if (products.size() == 0) {
                    boolean i$ = false;
                    return i$;
                }
            }
            for (int i = 0; i < products.size(); ++i) {
                Grib2Product product = products.get(i);
                Grib2ProductDefinitionSection pds = product.getPDS();
                Grib2IdentificationSection id = product.getID();
                if (i == 0) {
                    sb.append(" center " + id.getCenter_id());
                    sb.append(" sub_center " + id.getSubcenter_id());
                    sb.append(" table_version " + id.getLocal_table_version());
                    baseTime = product.getBaseTime();
                    sb.append(" basetime " + dateFormat.format(baseTime));
                    sb.append(" ensemble ");
                    sb.append(pds.getPdsVars().isEnsemble() ? "true" : "false");
                    out.writeUTF(sb.toString());
                    out.writeInt(products.size() + recordList.size());
                    if (verbose) {
                        System.out.println("Index extended with old new records " + recordList.size() + "  " + products.size());
                    }
                    for (RawRecord raw : recordList) {
                        out.writeInt(raw.discipline);
                        out.writeLong(raw.refTime);
                        out.writeInt(raw.gdsKey);
                        out.writeLong(raw.offset1);
                        out.writeLong(raw.offset2);
                        out.writeInt(raw.pdsSize);
                        out.write(raw.pdsData, 0, raw.pdsSize);
                    }
                    count = recordList.size();
                }
                out.writeInt(product.getDiscipline());
                out.writeLong(product.getRefTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getGdsOffset());
                out.writeLong(product.getPdsOffset());
                int length = pds.getPdsVars().getPDSBytes().length;
                out.writeInt(length);
                out.write(pds.getPdsVars().getPDSBytes(), 0, length);
                ++count;
            }
            Map<String, Grib2GridDefinitionSection> gdsHM = g2i.getGDSs();
            Set<String> keysHM = gdsHM.keySet();
            for (String key : keysHM) {
                Grib2GridDefinitionSection gds = gdsHM.get(key);
                if (gdsMap.containsKey(key)) continue;
                gdsMap.put(key, gds.getGdsVars());
            }
            out.writeInt(gdsMap.size());
            Set keyAll = gdsMap.keySet();
            for (String key : keyAll) {
                GribGDSVariablesIF gdsv = (GribGDSVariablesIF)gdsMap.get(key);
                int length = gdsv.getGDSBytes().length;
                out.writeInt(length);
                out.write(gdsv.getGDSBytes(), 0, length);
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
            boolean bl = false;
            return bl;
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rawGridIndex(String gbxName, List<RawRecord> recordList, Map<String, GribGDSVariablesIF> gdsMap) throws IOException {
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(gbxName)));
            ((DataInputStream)dis).readLong();
            String attributes = ((DataInputStream)dis).readUTF();
            if (attributes.contains("index_version 7")) {
                boolean bl = false;
                return bl;
            }
            boolean grid_edition_2 = attributes.contains("grid_edition 2");
            int number = ((DataInputStream)dis).readInt();
            for (int i = 0; i < number; ++i) {
                RawRecord rr = new RawRecord();
                rr.discipline = ((DataInputStream)dis).readInt();
                rr.refTime = ((DataInputStream)dis).readLong();
                rr.gdsKey = ((DataInputStream)dis).readInt();
                rr.offset1 = ((DataInputStream)dis).readLong();
                rr.offset2 = ((DataInputStream)dis).readLong();
                rr.pdsSize = ((DataInputStream)dis).readInt();
                rr.pdsData = new byte[rr.pdsSize];
                ((DataInputStream)dis).read(rr.pdsData);
                recordList.add(rr);
            }
            number = ((DataInputStream)dis).readInt();
            for (int j = 0; j < number; ++j) {
                GribGDSVariablesIF gdsv;
                int gdsSize = ((DataInputStream)dis).readInt();
                if (gdsSize == 4) {
                    recordList.removeAll(recordList);
                    boolean bl = false;
                    return bl;
                }
                byte[] gdsData = new byte[gdsSize];
                ((DataInputStream)dis).read(gdsData);
                if (grid_edition_2) {
                    gdsv = new Grib2GDSVariables(gdsData);
                    gdsMap.put(Integer.toString(((Grib2GDSVariables)gdsv).getGdsKey()), gdsv);
                    continue;
                }
                gdsv = new Grib1GDSVariables(gdsData);
                gdsMap.put(Integer.toString(((Grib1GDSVariables)gdsv).getGdsKey()), gdsv);
            }
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
        return true;
    }

    private boolean checkRawRecordProduct(RandomAccessFile inputRaf, RawRecord raw, Calendar cal, Grib2Product product, StringBuilder str) throws IOException {
        Grib2Pds pdsv1 = Grib2Pds.factory(raw.pdsData, raw.refTime, cal);
        Grib2Pds pdsv2 = product.getPDS().getPdsVars();
        return this.checkPdsAndData(inputRaf, raw.offset1, raw.offset2, pdsv1, product.getGdsOffset(), product.getPdsOffset(), pdsv2, str);
    }

    private boolean check2Products(RandomAccessFile inputRaf, Grib2Product product1, Grib2Product product2, StringBuilder str) throws IOException {
        Grib2Pds pdsv1 = product1.getPDS().getPdsVars();
        Grib2Pds pdsv2 = product2.getPDS().getPdsVars();
        return this.checkPdsAndData(inputRaf, product1.getGdsOffset(), product1.getPdsOffset(), pdsv1, product2.getGdsOffset(), product2.getPdsOffset(), pdsv2, str);
    }

    private boolean checkPdsAndData(RandomAccessFile inputRaf, long p1Offset1, long p1Offset2, Grib2Pds pdsv1, long p2Offset1, long p2Offset2, Grib2Pds pdsv2, StringBuilder str) throws IOException {
        byte[] pds1 = pdsv1.getPDSBytes();
        byte[] pds2 = pdsv2.getPDSBytes();
        boolean same = true;
        if (pds1.length != pds2.length) {
            same = false;
        } else {
            for (int j = 0; j < pds1.length; ++j) {
                if (pds1[j] == pds2[j]) continue;
                same = false;
                break;
            }
        }
        if (!same) {
            str.append(" and PDSs didn't match");
            return false;
        }
        str.append(" Category ");
        str.append(pdsv1.getParameterCategory());
        str.append(" Parameter ");
        str.append(pdsv1.getParameterNumber());
        str.append(" time ");
        str.append(pdsv1._getForecastTime());
        str.append(" p1offsets=" + p1Offset1 + " " + p1Offset2);
        str.append(" p2offsets=" + p2Offset1 + " " + p2Offset2);
        Grib2Data g1d = new Grib2Data(inputRaf);
        float[] data1 = g1d.getData(p1Offset1, p1Offset2, 0L);
        float[] data2 = g1d.getData(p2Offset1, p2Offset2, 0L);
        boolean datasame = true;
        if (data1 == null && data2 == null) {
            datasame = true;
        } else if (data1 != null && data2 == null || data1 == null && data2 != null) {
            datasame = false;
        } else {
            for (int i = 0; i < data1.length; ++i) {
                if (data1[i] == data2[i] || Float.valueOf(data1[i]).isNaN() && Float.valueOf(data2[i]).isNaN()) continue;
                datasame = false;
                break;
            }
        }
        if (!datasame) {
            str.append(" and Data didn't match");
        }
        return same;
    }

    public void setCheckPDS(boolean flag) {
        checkPDS = flag;
    }

    public void setLogPDS(pdsLogType flag) {
        logPDS = flag;
    }

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> scans for index creation");
        System.out.println("<IndexFile.idx> where to write index, default name + .gbx8");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <IndexFile>");
        System.exit(0);
    }

    public void setDebug(boolean flag) {
        debugTiming = flag;
    }

    public void setVerbose(boolean flag) {
        verbose = flag;
    }

    public static void main(String[] args) throws IOException {
        Grib2WriteIndex indexer = new Grib2WriteIndex();
        debugTiming = false;
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            Grib2WriteIndex.usage(cl.getName());
            System.exit(0);
        }
        String gribName = args[0];
        File grib = new File(args[0]);
        long rafLastModified = grib.lastModified();
        String gbxName = GribIndexName.getCurrentSuffix(gribName);
        if (args.length == 2) {
            File gbx = new File(gbxName);
            if (gbx.exists() && gbx.lastModified() > rafLastModified) {
                return;
            }
            if (gbx.exists()) {
                indexer.extendGribIndex(grib, gbx, gribName, gbxName, false);
            } else {
                indexer.writeGribIndex(grib, gribName, gbxName, false);
            }
        } else if (args.length == 1) {
            indexer.writeGribIndex(grib, gribName, gbxName, false);
        }
    }

    protected class CompareKeyDescend
    implements Comparator<Object> {
        protected CompareKeyDescend() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int i1 = (Integer)o1;
            int i2 = (Integer)o2;
            return i2 - i1;
        }
    }

    public class RawRecord {
        public int discipline;
        public long refTime;
        public int gdsKey;
        public long offset1;
        public long offset2;
        public int pdsSize;
        public byte[] pdsData;

        public RawRecord() {
        }

        public RawRecord(int discipline, long refTime, int gdsKey, long offset1, long offset2, int pdsSize, byte[] pdsData) {
            this.discipline = discipline;
            this.refTime = refTime;
            this.gdsKey = gdsKey;
            this.offset1 = offset1;
            this.offset2 = offset2;
            this.pdsSize = pdsSize;
            this.pdsData = pdsData;
        }
    }

    public static enum pdsLogType {
        logger,
        systemout,
        none;

    }
}

