/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf4;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.iosp.hdf4.ODLparser;

public class HdfEos {
    public static final String HDF5_GROUP = "HDFEOS_INFORMATION";
    public static final String HDFEOS_CRS = "_HDFEOS_CRS";
    public static final String HDFEOS_CRS_Projection = "Projection";
    public static final String HDFEOS_CRS_UpperLeft = "UpperLeftPointMtrs";
    public static final String HDFEOS_CRS_LowerRight = "LowerRightMtrs";
    public static final String HDFEOS_CRS_ProjParams = "ProjParams";
    public static final String HDFEOS_CRS_SphereCode = "SphereCode";
    private static Logger log = LoggerFactory.getLogger(HdfEos.class);
    static boolean showWork = false;
    private static final String GEOLOC_FIELDS = "Geolocation Fields";
    private static final String GEOLOC_FIELDS2 = "Geolocation_Fields";
    private static final String DATA_FIELDS = "Data Fields";
    private static final String DATA_FIELDS2 = "Data_Fields";

    public static boolean amendFromODL(NetcdfFile ncfile, Group eosGroup) throws IOException {
        String smeta = HdfEos.getStructMetadata(eosGroup);
        if (smeta == null) {
            return false;
        }
        HdfEos fixer = new HdfEos();
        fixer.fixAttributes(ncfile.getRootGroup());
        fixer.amendFromODL(ncfile, smeta);
        return true;
    }

    public static boolean getEosInfo(NetcdfFile ncfile, Group eosGroup, Formatter f) throws IOException {
        String smeta = HdfEos.getStructMetadata(eosGroup);
        if (smeta == null) {
            f.format("No StructMetadata variables in group %s %n", eosGroup.getFullName());
            return false;
        }
        f.format("raw = %n%s%n", smeta);
        ODLparser parser = new ODLparser();
        parser.parseFromString(smeta);
        StringWriter sw = new StringWriter(5000);
        parser.showDoc(new PrintWriter(sw));
        f.format("parsed = %n%s%n", sw.toString());
        return true;
    }

    private static String getStructMetadata(Group eosGroup) throws IOException {
        Variable structMetadataVar;
        StringBuilder sbuff = null;
        String structMetadata = null;
        int n = 0;
        while ((structMetadataVar = eosGroup.findVariable("StructMetadata." + n)) != null) {
            Array A;
            if (structMetadata != null && sbuff == null) {
                sbuff = new StringBuilder(64000);
                sbuff.append(structMetadata);
            }
            if ((A = structMetadataVar.read()) instanceof ArrayChar.D1) {
                ArrayChar ca = (ArrayChar)A;
                structMetadata = ca.getString();
            } else if (A instanceof ArrayObject.D0) {
                ArrayObject ao = (ArrayObject)A;
                structMetadata = (String)ao.getObject(0);
            } else {
                log.error("Unsupported array type {} for StructMetadata", (Object)A.getElementType());
            }
            if (sbuff != null) {
                sbuff.append(structMetadata);
            }
            ++n;
        }
        return sbuff != null ? sbuff.toString() : structMetadata;
    }

    private void amendFromODL(NetcdfFile ncfile, String structMetadata) throws IOException {
        Element pointStructure;
        Element gridStructure;
        Group rootg = ncfile.getRootGroup();
        ODLparser parser = new ODLparser();
        Element root = parser.parseFromString(structMetadata);
        Enum featureType = null;
        Element swathStructure = root.getChild("SwathStructure");
        if (swathStructure != null) {
            List swaths = swathStructure.getChildren();
            for (Element elemSwath : swaths) {
                Element swathNameElem = elemSwath.getChild("SwathName");
                if (swathNameElem == null) {
                    log.warn("No SwathName element in {} {} ", (Object)elemSwath.getName(), (Object)ncfile.getLocation());
                    continue;
                }
                String swathName = NetcdfFile.makeValidCdmObjectName(swathNameElem.getText().trim());
                Group swathGroup = this.findGroupNested(rootg, swathName);
                if (swathGroup != null) {
                    featureType = this.amendSwath(ncfile, elemSwath, swathGroup);
                    continue;
                }
                log.warn("Cant find swath group {} {}", (Object)swathName, (Object)ncfile.getLocation());
            }
        }
        if ((gridStructure = root.getChild("GridStructure")) != null) {
            List grids = gridStructure.getChildren();
            for (Element elemGrid : grids) {
                Element gridNameElem = elemGrid.getChild("GridName");
                if (gridNameElem == null) {
                    log.warn("No GridName element in {} {} ", (Object)elemGrid.getName(), (Object)ncfile.getLocation());
                    continue;
                }
                String gridName = NetcdfFile.makeValidCdmObjectName(gridNameElem.getText().trim());
                Group gridGroup = this.findGroupNested(rootg, gridName);
                if (gridGroup != null) {
                    featureType = this.amendGrid(elemGrid, ncfile, gridGroup, ncfile.getLocation());
                    continue;
                }
                log.warn("Cant find Grid group {} {}", (Object)gridName, (Object)ncfile.getLocation());
            }
        }
        if ((pointStructure = root.getChild("PointStructure")) != null) {
            List pts = pointStructure.getChildren();
            for (Element elem : pts) {
                Element nameElem = elem.getChild("PointName");
                if (nameElem == null) {
                    log.warn("No PointName element in {} {}", (Object)elem.getName(), (Object)ncfile.getLocation());
                    continue;
                }
                String name = nameElem.getText().trim();
                Group ptGroup = this.findGroupNested(rootg, name);
                if (ptGroup != null) {
                    featureType = FeatureType.POINT;
                    continue;
                }
                log.warn("Cant find Point group {} {}", (Object)name, (Object)ncfile.getLocation());
            }
        }
        if (featureType != null) {
            if (showWork) {
                log.debug("***EOS featureType= {}", (Object)featureType.toString());
            }
            rootg.addAttribute(new Attribute("featureType", featureType.toString()));
        }
    }

    private FeatureType amendSwath(NetcdfFile ncfile, Element swathElem, Group parent) {
        Group dataG;
        Variable v;
        FeatureType featureType = FeatureType.SWATH;
        ArrayList<Dimension> unknownDims = new ArrayList<Dimension>();
        Element d = swathElem.getChild("Dimension");
        List dims = d.getChildren();
        for (Element elem : dims) {
            Object name = elem.getChild("DimensionName").getText().trim();
            if (((String)(name = NetcdfFile.makeValidCdmObjectName((String)name))).equalsIgnoreCase("scalar")) continue;
            String sizeS = elem.getChild("Size").getText().trim();
            int length = Integer.parseInt(sizeS);
            if (length > 0) {
                Dimension dim = parent.findDimensionLocal((String)name);
                if (dim != null) {
                    if (dim.getLength() == length) continue;
                    log.error("Conflicting Dimensions = {} {}", (Object)dim, (Object)ncfile.getLocation());
                    throw new IllegalStateException("Conflicting Dimensions = " + (String)name);
                }
                dim = new Dimension((String)name, length);
                if (!parent.addDimensionIfNotExists(dim) || !showWork) continue;
                log.debug(" Add dimension {}", (Object)dim);
                continue;
            }
            log.warn("Dimension {} has size {} {}", new Object[]{name, sizeS, ncfile.getLocation()});
            Dimension udim = new Dimension((String)name, 1);
            udim.setGroup(parent);
            unknownDims.add(udim);
            if (!showWork) continue;
            log.debug(" Add dimension {}", (Object)udim);
        }
        Element dmap = swathElem.getChild("DimensionMap");
        List dimMaps = dmap.getChildren();
        for (Element elem : dimMaps) {
            String geoDimName = elem.getChild("GeoDimension").getText().trim();
            geoDimName = NetcdfFile.makeValidCdmObjectName(geoDimName);
            String dataDimName = elem.getChild("DataDimension").getText().trim();
            dataDimName = NetcdfFile.makeValidCdmObjectName(dataDimName);
            String offsetS = elem.getChild("Offset").getText().trim();
            String incrS = elem.getChild("Increment").getText().trim();
            int offset = Integer.parseInt(offsetS);
            int incr = Integer.parseInt(incrS);
            v = new Variable(ncfile, parent, null, dataDimName);
            v.setDimensions(geoDimName);
            v.setDataType(DataType.INT);
            int npts = (int)v.getSize();
            Array data = Array.makeArray(v.getDataType(), npts, offset, incr);
            v.setCachedData(data, true);
            v.addAttribute(new Attribute("_DimensionMap", ""));
            parent.addVariable(v);
            if (!showWork) continue;
            log.debug(" Add dimensionMap {}", (Object)v);
        }
        Group geoFieldsG = parent.findGroup(GEOLOC_FIELDS);
        if (geoFieldsG == null) {
            geoFieldsG = parent.findGroup(GEOLOC_FIELDS2);
        }
        if (geoFieldsG != null) {
            Variable latAxis = null;
            Variable lonAxis = null;
            Variable timeAxis = null;
            Element floc = swathElem.getChild("GeoField");
            List varsLoc = floc.getChildren();
            for (Element elem : varsLoc) {
                String varname = elem.getChild("GeoFieldName").getText().trim();
                Variable v2 = geoFieldsG.findVariable(varname);
                assert (v2 != null) : varname;
                AxisType axis = this.addAxisType(ncfile, v2);
                if (axis == AxisType.Lat) {
                    latAxis = v2;
                }
                if (axis == AxisType.Lon) {
                    lonAxis = v2;
                }
                if (axis == AxisType.Time) {
                    timeAxis = v2;
                }
                Element dimList = elem.getChild("DimList");
                List values = dimList.getChildren("value");
                this.setSharedDimensions(v2, values, unknownDims, ncfile.getLocation());
                if (!showWork) continue;
                log.debug(" set coordinate {}", (Object)v2);
            }
            if (latAxis != null && lonAxis != null) {
                log.debug("found lonAxis and latAxis -- testing XY domain");
                List<Dimension> xyDomain = CoordinateSystem.makeDomain(new Variable[]{latAxis, lonAxis});
                log.debug("xyDomain size {}", (Object)xyDomain.size());
                if (xyDomain.size() < 2) {
                    if (timeAxis != null) {
                        log.debug("found timeAxis -- testing if trajectory");
                        Dimension dd1 = timeAxis.getDimension(0);
                        Dimension dd2 = latAxis.getDimension(0);
                        Dimension dd3 = lonAxis.getDimension(0);
                        featureType = dd1.equals(dd2) && dd1.equals(dd3) ? FeatureType.TRAJECTORY : FeatureType.PROFILE;
                    } else {
                        featureType = FeatureType.PROFILE;
                    }
                }
            }
        }
        if ((dataG = parent.findGroup(DATA_FIELDS)) == null) {
            dataG = parent.findGroup(DATA_FIELDS2);
        }
        if (dataG != null) {
            Element f = swathElem.getChild("DataField");
            List vars = f.getChildren();
            for (Element elem : vars) {
                Element dataFieldNameElem = elem.getChild("DataFieldName");
                if (dataFieldNameElem == null) continue;
                String varname = NetcdfFile.makeValidCdmObjectName(dataFieldNameElem.getText().trim());
                v = dataG.findVariable(varname);
                if (v == null) {
                    log.error("Cant find variable {} {}", (Object)varname, (Object)ncfile.getLocation());
                    continue;
                }
                Element dimList = elem.getChild("DimList");
                List values = dimList.getChildren("value");
                this.setSharedDimensions(v, values, unknownDims, ncfile.getLocation());
            }
        }
        return featureType;
    }

    private AxisType addAxisType(NetcdfFile ncfile, Variable v) {
        String name = v.getShortName();
        if (name.equalsIgnoreCase("Latitude") || name.equalsIgnoreCase("GeodeticLatitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
            v.addAttribute(new Attribute("units", "degrees_north"));
            return AxisType.Lat;
        }
        if (name.equalsIgnoreCase("Longitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
            v.addAttribute(new Attribute("units", "degrees_east"));
            return AxisType.Lon;
        }
        if (name.equalsIgnoreCase("Time")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
            if (v.findAttribute("units") == null) {
                v.addAttribute(new Attribute("units", "seconds since 1993-01-01T00:00:00Z"));
                v.addAttribute(new Attribute("calendar", "TAI"));
            }
            return AxisType.Time;
        }
        if (name.equalsIgnoreCase("Pressure")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            return AxisType.Pressure;
        }
        if (name.equalsIgnoreCase("Altitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
            v.addAttribute(new Attribute("positive", "up"));
            return AxisType.Height;
        }
        return null;
    }

    private FeatureType amendGrid(Element gridElem, NetcdfFile ncfile, Group parent, String location) {
        Group dataG;
        ArrayList<Dimension> unknownDims = new ArrayList<Dimension>();
        String xdimSizeS = gridElem.getChild("XDim").getText().trim();
        String ydimSizeS = gridElem.getChild("YDim").getText().trim();
        int xdimSize = Integer.parseInt(xdimSizeS);
        int ydimSize = Integer.parseInt(ydimSizeS);
        parent.addDimensionIfNotExists(new Dimension("XDim", xdimSize));
        parent.addDimensionIfNotExists(new Dimension("YDim", ydimSize));
        Element proj = gridElem.getChild(HDFEOS_CRS_Projection);
        if (proj != null) {
            Variable crs = new Variable(ncfile, parent, null, HDFEOS_CRS);
            crs.setDataType(DataType.SHORT);
            crs.setDimensions("");
            crs.setCachedData(Array.makeArray(DataType.SHORT, 1, 0.0, 0.0));
            parent.addVariable(crs);
            this.addAttributeIfExists(gridElem, HDFEOS_CRS_Projection, crs, false);
            this.addAttributeIfExists(gridElem, HDFEOS_CRS_UpperLeft, crs, true);
            this.addAttributeIfExists(gridElem, HDFEOS_CRS_LowerRight, crs, true);
            this.addAttributeIfExists(gridElem, HDFEOS_CRS_ProjParams, crs, true);
            this.addAttributeIfExists(gridElem, HDFEOS_CRS_SphereCode, crs, false);
        }
        Element d = gridElem.getChild("Dimension");
        List dims = d.getChildren();
        for (Element elem : dims) {
            String name = elem.getChild("DimensionName").getText().trim();
            if ((name = NetcdfFile.makeValidCdmObjectName(name)).equalsIgnoreCase("scalar")) continue;
            String sizeS = elem.getChild("Size").getText().trim();
            int length = Integer.parseInt(sizeS);
            Dimension old = parent.findDimension(name);
            if (old != null && old.getLength() == length) continue;
            if (length > 0) {
                Dimension dim = new Dimension(name, length);
                if (!parent.addDimensionIfNotExists(dim) || !showWork) continue;
                log.debug(" Add dimension {}", (Object)dim);
                continue;
            }
            log.warn("Dimension {} has size {} {} ", new Object[]{sizeS, name, location});
            Dimension udim = new Dimension(name, 1);
            udim.setGroup(parent);
            unknownDims.add(udim);
            if (!showWork) continue;
            log.debug(" Add dimension {}", (Object)udim);
        }
        Group geoFieldsG = parent.findGroup(GEOLOC_FIELDS);
        if (geoFieldsG == null) {
            geoFieldsG = parent.findGroup(GEOLOC_FIELDS2);
        }
        if (geoFieldsG != null) {
            Element floc = gridElem.getChild("GeoField");
            List varsLoc = floc.getChildren();
            for (Element elem : varsLoc) {
                String varname = elem.getChild("GeoFieldName").getText().trim();
                Variable v = geoFieldsG.findVariable(varname);
                assert (v != null) : varname;
                Element dimList = elem.getChild("DimList");
                List values = dimList.getChildren("value");
                this.setSharedDimensions(v, values, unknownDims, location);
            }
        }
        if ((dataG = parent.findGroup(DATA_FIELDS)) == null) {
            dataG = parent.findGroup(DATA_FIELDS2);
        }
        if (dataG != null) {
            boolean isLatLon;
            Element f = gridElem.getChild("DataField");
            List vars = f.getChildren();
            for (Element elem : vars) {
                String varname = elem.getChild("DataFieldName").getText().trim();
                varname = NetcdfFile.makeValidCdmObjectName(varname);
                Variable v = dataG.findVariable(varname);
                assert (v != null) : varname;
                Element dimList = elem.getChild("DimList");
                List values = dimList.getChildren("value");
                this.setSharedDimensions(v, values, unknownDims, location);
            }
            String projS = null;
            Element projElem = gridElem.getChild(HDFEOS_CRS_Projection);
            if (projElem != null) {
                projS = projElem.getText().trim();
            }
            if (isLatLon = "GCTP_GEO".equals(projS)) {
                for (Variable v : dataG.getVariables()) {
                    if (!v.isCoordinateVariable()) continue;
                    if (v.getShortName().equals("YDim")) {
                        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                        v.addAttribute(new Attribute("units", "degrees_north"));
                    }
                    if (!v.getShortName().equals("XDim")) continue;
                    v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                }
            }
        }
        return FeatureType.GRID;
    }

    private void addAttributeIfExists(Element elem, String name, Variable v, boolean isDoubleArray) {
        Element child = elem.getChild(name);
        if (child == null) {
            return;
        }
        if (isDoubleArray) {
            List vElems = child.getChildren();
            ArrayList<Double> values = new ArrayList<Double>();
            for (Element ve : vElems) {
                String valueS = ve.getText().trim();
                try {
                    values.add(Double.parseDouble(valueS));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            Attribute att = new Attribute(name, values);
            v.addAttribute(att);
        } else {
            String value = child.getText().trim();
            Attribute att = new Attribute(name, value);
            v.addAttribute(att);
        }
    }

    private void setSharedDimensions(Variable v, List<Element> values, List<Dimension> unknownDims, String location) {
        if (values.size() == 0) {
            return;
        }
        Iterator<Element> iter = values.iterator();
        while (iter.hasNext()) {
            Element value = iter.next();
            String dimName = value.getText().trim();
            if (!dimName.equalsIgnoreCase("scalar")) continue;
            iter.remove();
        }
        List<Dimension> oldDims = v.getDimensions();
        if (oldDims.size() != values.size()) {
            log.error("Different number of dimensions for {} {}", (Object)v, (Object)location);
            return;
        }
        ArrayList<Dimension> newDims = new ArrayList<Dimension>();
        Group group = v.getParentGroup();
        for (int i = 0; i < values.size(); ++i) {
            Element value = values.get(i);
            String dimName = value.getText().trim();
            dimName = NetcdfFile.makeValidCdmObjectName(dimName);
            Dimension dim = group.findDimension(dimName);
            Dimension oldDim = oldDims.get(i);
            if (dim == null) {
                dim = this.checkUnknownDims(dimName, unknownDims, oldDim, location);
            }
            if (dim == null) {
                log.error("Unknown Dimension= {} for variable = {} {} ", new Object[]{dimName, v.getFullName(), location});
                return;
            }
            if (dim.getLength() != oldDim.getLength()) {
                log.error("Shared dimension ({}) has different length than data dimension ({}) shared={} org={} for {} {}", new Object[]{dim.getShortName(), oldDim.getShortName(), dim.getLength(), oldDim.getLength(), v, location});
                return;
            }
            newDims.add(dim);
        }
        v.setDimensions(newDims);
        if (showWork) {
            log.debug(" set shared dimensions for {}", (Object)v.getNameAndDimensions());
        }
    }

    private Dimension checkUnknownDims(String wantDim, List<Dimension> unknownDims, Dimension oldDim, String location) {
        for (Dimension dim : unknownDims) {
            if (!dim.getShortName().equals(wantDim)) continue;
            int len = oldDim.getLength();
            if (len == 0) {
                dim.setUnlimited(true);
            }
            dim.setLength(len);
            Group parent = dim.getGroup();
            parent.addDimensionIfNotExists(dim);
            unknownDims.remove(dim);
            log.warn("unknownDim {} length set to {}{}", new Object[]{wantDim, oldDim.getLength(), location});
            return dim;
        }
        return null;
    }

    private Group findGroupNested(Group parent, String name) {
        for (Group g : parent.getGroups()) {
            if (!g.getShortName().equals(name)) continue;
            return g;
        }
        for (Group g : parent.getGroups()) {
            Group result = this.findGroupNested(g, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void fixAttributes(Group g) {
        for (Variable v : g.getVariables()) {
            for (Attribute a : v.getAttributes()) {
                if (a.getShortName().equalsIgnoreCase("UNIT") || a.getShortName().equalsIgnoreCase("UNITS")) {
                    a.setShortName("units");
                }
                if (a.getShortName().equalsIgnoreCase("SCALE_FACTOR")) {
                    a.setShortName("scale_factor");
                }
                if (!a.getShortName().equalsIgnoreCase("OFFSET")) continue;
                a.setShortName("add_offset");
            }
        }
        for (Group ng : g.getGroups()) {
            this.fixAttributes(ng);
        }
    }
}

