/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.http.Header;
import ucar.nc2.util.net.HTTPFactory;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSession;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Urlencoded;

public class HTTPRandomAccessFile
extends RandomAccessFile {
    public static int defaultHTTPBufferSize = 20000;
    private String url;
    private HTTPSession session = null;
    private long total_length = 0L;
    private boolean debug = false;
    private boolean debugDetails = false;

    public HTTPRandomAccessFile(String url) throws IOException {
        this(url, defaultHTTPBufferSize);
        this.location = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Urlencoded
    public HTTPRandomAccessFile(String url, int bufferSize) throws IOException {
        super(bufferSize);
        this.file = null;
        this.url = url;
        this.location = url;
        if (debugLeaks) {
            allFiles.add(this.location);
        }
        this.session = HTTPFactory.newSession(url);
        boolean needtest = true;
        HTTPMethod method = null;
        try {
            method = HTTPFactory.Head(this.session);
            this.doConnect(method);
            Header head = method.getResponseHeader("Accept-Ranges");
            if (head == null) {
                needtest = true;
            } else if (head.getValue().equalsIgnoreCase("bytes")) {
                needtest = false;
            } else if (head.getValue().equalsIgnoreCase("none")) {
                throw new IOException("Server does not support byte Ranges");
            }
            head = method.getResponseHeader("Content-Length");
            if (head == null) {
                throw new IOException("Server does not support Content-Length");
            }
            try {
                this.total_length = Long.parseLong(head.getValue());
            }
            catch (NumberFormatException e) {
                throw new IOException("Server has malformed Content-Length header");
            }
        }
        finally {
            if (method != null) {
                method.close();
            }
        }
        if (needtest && !this.rangeOk(url)) {
            throw new IOException("Server does not support byte Ranges");
        }
        if (debugLeaks) {
            openFiles.add(this.location);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileCache != null) {
            this.fileCache.release(this);
            return;
        }
        if (debugLeaks) {
            openFiles.remove(this.location);
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rangeOk(String url) {
        HTTPMethod method = null;
        try {
            method = HTTPFactory.Get(this.session, url);
            method.setRequestHeader("Range", "bytes=0-1");
            this.doConnect(method);
            int code = method.getStatusCode();
            if (code != 206) {
                throw new IOException("Server does not support Range requests, code= " + code);
            }
            method.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (method != null) {
                method.close();
            }
        }
    }

    private void doConnect(HTTPMethod method) throws IOException {
        int statusCode = method.execute();
        if (statusCode == 404) {
            throw new FileNotFoundException(this.url + " " + method.getStatusLine());
        }
        if (statusCode >= 300) {
            throw new IOException(this.url + " " + method.getStatusLine());
        }
        if (this.debugDetails) {
            this.printHeaders("Request: " + method.getName() + " " + method.getPath(), method.getRequestHeaders());
            this.printHeaders("Response: " + method.getStatusCode(), method.getResponseHeaders());
        }
    }

    private void printHeaders(String title, Header[] heads) {
        System.out.println(title);
        for (Header head : heads) {
            System.out.print("  " + head.toString());
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int read_(long pos, byte[] buff, int offset, int len) throws IOException {
        long end = pos + (long)len - 1L;
        if (end >= this.total_length) {
            end = this.total_length - 1L;
        }
        if (this.debug) {
            System.out.println(" HTTPRandomAccessFile bytes=" + pos + "-" + end + ": ");
        }
        HTTPMethod method = null;
        try {
            method = HTTPFactory.Get(this.session);
            method.setFollowRedirects(true);
            method.setRequestHeader("Range", "bytes=" + pos + "-" + end);
            this.doConnect(method);
            int code = method.getStatusCode();
            if (code != 206) {
                throw new IOException("Server does not support Range requests, code= " + code);
            }
            String s = method.getResponseHeader("Content-Length").getValue();
            if (s == null) {
                throw new IOException("Server does not send Content-Length header");
            }
            int readLen = Integer.parseInt(s);
            readLen = Math.min(len, readLen);
            InputStream is = method.getResponseAsStream();
            int n = readLen = this.copy(is, buff, offset, readLen);
            return n;
        }
        finally {
            if (method != null) {
                method.close();
            }
        }
    }

    private int copy(InputStream in, byte[] buff, int offset, int want) throws IOException {
        int bytesRead;
        int done = 0;
        while (want > 0 && (bytesRead = in.read(buff, offset + done, want)) != -1) {
            done += bytesRead;
            want -= bytesRead;
        }
        return done;
    }

    @Override
    public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
        int n = (int)nbytes;
        byte[] buff = new byte[n];
        int done = this.read_(offset, buff, 0, n);
        dest.write(ByteBuffer.wrap(buff));
        return done;
    }

    @Override
    public long length() throws IOException {
        long fileLength = this.total_length;
        if (fileLength < this.dataEnd) {
            return this.dataEnd;
        }
        return fileLength;
    }
}

