/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import ucar.nc2.Variable;
import ucar.nc2.write.Nc4ChunkingStrategyImpl;

public class Nc4ChunkingStrategyGrib
extends Nc4ChunkingStrategyImpl {
    public Nc4ChunkingStrategyGrib(int deflateLevel, boolean shuffle) {
        super(deflateLevel, shuffle);
    }

    @Override
    public boolean isChunked(Variable v) {
        int n = v.getRank();
        return n >= 2 || v.isUnlimited();
    }

    @Override
    public long[] computeChunking(Variable v) {
        int n = v.getRank();
        long[] result = new long[n];
        if (n < 2) {
            result[0] = 1L;
        } else {
            for (int i = 0; i < n; ++i) {
                result[i] = i < n - 2 ? 1L : (long)v.getDimension(i).getLength();
            }
        }
        return result;
    }
}

