/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.writer.stax;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.Catalog;
import thredds.catalog2.Dataset;
import thredds.catalog2.Metadata;
import thredds.catalog2.xml.writer.ThreddsXmlWriter;
import thredds.catalog2.xml.writer.ThreddsXmlWriterException;
import thredds.catalog2.xml.writer.stax.CatalogElementWriter;

public class StaxWriter
implements ThreddsXmlWriter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String defaultCharEncoding = "UTF-8";
    private static final String indentString = "  ";
    private final XMLOutputFactory factory = XMLOutputFactory.newInstance();

    public static String getIndentString(int nestLevel) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nestLevel; ++i) {
            sb.append(indentString);
        }
        return sb.toString();
    }

    public StaxWriter() {
        this.factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
        if (this.factory.isPropertySupported("javax.xml.stream.isPrefixDefaulting")) {
            this.factory.setProperty("javax.xml.stream.isPrefixDefaulting", Boolean.TRUE);
        }
    }

    @Override
    public void writeCatalog(Catalog catalog, File file) throws ThreddsXmlWriterException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        FileOutputStream os = new FileOutputStream(file);
        XMLStreamWriter xmlStreamWriter = this.getXmlStreamWriter(os);
        CatalogElementWriter catalogWriter = new CatalogElementWriter();
        catalogWriter.writeElement(catalog, xmlStreamWriter, 0);
        ((OutputStream)os).close();
    }

    @Override
    public void writeCatalog(Catalog catalog, Writer writer) throws ThreddsXmlWriterException {
        XMLStreamWriter xmlStreamWriter = this.getXmlStreamWriter(writer);
        CatalogElementWriter catalogWriter = new CatalogElementWriter();
        catalogWriter.writeElement(catalog, xmlStreamWriter, 0);
    }

    @Override
    public void writeCatalog(Catalog catalog, OutputStream os) throws ThreddsXmlWriterException {
        XMLStreamWriter xmlStreamWriter = this.getXmlStreamWriter(os);
        CatalogElementWriter catalogWriter = new CatalogElementWriter();
        catalogWriter.writeElement(catalog, xmlStreamWriter, 0);
    }

    @Override
    public void writeDataset(Dataset dataset, File file) throws ThreddsXmlWriterException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        FileOutputStream os = new FileOutputStream(file);
        XMLStreamWriter xmlStreamWriter = this.getXmlStreamWriter(os);
        ((OutputStream)os).close();
    }

    @Override
    public void writeDataset(Dataset dataset, Writer writer) throws ThreddsXmlWriterException {
        XMLStreamWriter xmlStreamWriter = this.getXmlStreamWriter(writer);
    }

    @Override
    public void writeDataset(Dataset dataset, OutputStream os) throws ThreddsXmlWriterException {
        XMLStreamWriter xmlStreamWriter = this.getXmlStreamWriter(os);
    }

    @Override
    public void writeMetadata(Metadata metadata, File file) throws ThreddsXmlWriterException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        FileOutputStream os = new FileOutputStream(file);
        XMLStreamWriter xmlStreamWriter = this.getXmlStreamWriter(os);
        ((OutputStream)os).close();
    }

    @Override
    public void writeMetadata(Metadata metadata, Writer writer) throws ThreddsXmlWriterException {
        XMLStreamWriter xmlStreamWriter = this.getXmlStreamWriter(writer);
    }

    @Override
    public void writeMetadata(Metadata metadata, OutputStream os) throws ThreddsXmlWriterException {
        XMLStreamWriter xmlStreamWriter = this.getXmlStreamWriter(os);
    }

    private XMLStreamWriter getXmlStreamWriter(Writer writer) throws ThreddsXmlWriterException {
        if (writer == null) {
            throw new IllegalArgumentException("Writer may not be null.");
        }
        try {
            return this.factory.createXMLStreamWriter(writer);
        }
        catch (XMLStreamException e) {
            this.logger.error("getXmlStreamWriter(): Failed to create XMLStreamWriter: " + e.getMessage());
            throw new ThreddsXmlWriterException("Failed to create XMLStreamWriter: " + e.getMessage(), e);
        }
    }

    private XMLStreamWriter getXmlStreamWriter(OutputStream os) throws ThreddsXmlWriterException {
        if (os == null) {
            throw new IllegalArgumentException("OutputStream must not be null.");
        }
        try {
            return this.factory.createXMLStreamWriter(os, defaultCharEncoding);
        }
        catch (XMLStreamException e) {
            this.logger.error("getXmlStreamWriter(): Failed to create XMLStreamWriter: " + e.getMessage());
            throw new ThreddsXmlWriterException("Failed to create XMLStreamWriter: " + e.getMessage(), e);
        }
    }
}

