/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.point.writer2.CFPointWriterConfig;
import ucar.nc2.ft.point.writer2.WriterCFPointAbstract;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.EarthLocation;

class WriterCFTrajectoryCollection
extends WriterCFPointAbstract {
    private Structure featureStruct;
    private HashSet<String> featureVarMap = new HashSet();
    private boolean headerDone;
    private int trajRecno;
    private int obsRecno;

    WriterCFTrajectoryCollection(String fileOut, AttributeContainer globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writerb.addAttribute(new Attribute("featureType", CF.FeatureType.trajectory.name()));
        this.writerb.addAttribute(new Attribute("DSG_representation", "Contiguous ragged array representation of trajectories, H.4.3"));
    }

    int writeTrajectory(TrajectoryFeature traj) throws IOException {
        int count = 0;
        for (PointFeature pf : traj) {
            if (!this.headerDone) {
                if (this.id_strlen == 0) {
                    this.id_strlen = traj.getName().length() * 2;
                }
                this.writeHeader(traj, pf);
                this.headerDone = true;
            }
            this.writeObsData(pf);
            ++count;
        }
        this.writeTrajectoryData(traj, count);
        return count;
    }

    private void writeHeader(TrajectoryFeature feature, PointFeature obs) throws IOException {
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        coords.add(VariableSimpleBuilder.makeScalar("time", "time of measurement", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        coords.add(VariableSimpleBuilder.makeScalar("latitude", "latitude of measurement", "degrees_north", DataType.DOUBLE).build());
        coords.add(VariableSimpleBuilder.makeScalar("longitude", "longitude of measurement", "degrees_east", DataType.DOUBLE).build());
        Formatter coordNames = new Formatter().format("%s %s %s", "time", "latitude", "longitude");
        if (this.altUnits != null) {
            coords.add(VariableSimpleBuilder.makeScalar("altitude", "altitude of measurement", this.altUnits, DataType.DOUBLE).addAttribute("positive", CF1Convention.getZisPositive("altitude", this.altUnits)).build());
            coordNames.format(" %s", "altitude");
        }
        super.writeHeader(coords, feature.getFeatureData(), null, obs.getFeatureData(), coordNames.toString());
    }

    @Override
    void makeFeatureVariables(StructureData featureData, boolean isExtended) {
        Dimension trajDim = this.writerb.addDimension("traj", this.nfeatures);
        ArrayList<VariableSimpleIF> featureVars = new ArrayList<VariableSimpleIF>();
        featureVars.add(VariableSimpleBuilder.makeString("trajectoryId", "trajectory identifier", null, this.id_strlen).addAttribute("cf_role", "trajectory_id").build());
        featureVars.add(VariableSimpleBuilder.makeScalar("nobs", "number of obs for this profile", null, DataType.INT).addAttribute("sample_dimension", "obs").build());
        for (StructureMembers.Member m : featureData.getMembers()) {
            VariableSimpleIF dv = this.findDataVar(m.getName());
            if (dv == null) continue;
            featureVars.add(dv);
        }
        if (isExtended) {
            Structure.Builder structb = this.writerb.addStructure("trajectory", "traj");
            this.addCoordinatesExtended(structb, featureVars);
        } else {
            this.addCoordinatesClassic(trajDim, featureVars, this.featureVarMap);
        }
    }

    @Override
    void finishBuilding() throws IOException {
        super.finishBuilding();
        this.featureStruct = this.findStructure("trajectory");
    }

    private void writeTrajectoryData(TrajectoryFeature profile, int nobs) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberString("trajectoryId", null, null, profile.getName().trim(), this.id_strlen);
        smb.addMemberScalar("nobs", null, null, DataType.INT, nobs);
        StructureDataFromMember profileCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create((Iterable<StructureData>)ImmutableList.of((Object)profileCoords, (Object)profile.getFeatureData()));
        this.trajRecno = super.writeStructureData(this.trajRecno, this.featureStruct, sdall, this.featureVarMap);
    }

    private void writeObsData(PointFeature pf) throws IOException {
        EarthLocation loc = pf.getLocation();
        this.trackBB(loc.getLatLon(), this.timeUnit.makeCalendarDate(pf.getObservationTime()));
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("time", null, null, DataType.DOUBLE, pf.getObservationTime());
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, loc.getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, loc.getLongitude());
        if (this.altUnits != null) {
            smb.addMemberScalar("altitude", null, null, DataType.DOUBLE, loc.getAltitude());
        }
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create((Iterable<StructureData>)ImmutableList.of((Object)coords, (Object)pf.getFeatureData()));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

