/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.radial.RadialCoordSys;
import ucar.nc2.ft.FeatureDatasetFactory;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonRect;

public abstract class AbstractRadialAdapter
implements RadialDatasetSweep,
FeatureDatasetFactory {
    protected NetcdfDataset netcdfDataset;
    protected String title;
    protected String desc;
    protected String location;
    protected Date startDate;
    protected Date endDate;
    protected LatLonRect boundingBox;
    protected List<VariableSimpleIF> dataVariables = new ArrayList<VariableSimpleIF>();
    protected StringBuffer parseInfo = new StringBuffer();
    protected EarthLocation origin;
    protected HashMap csHash = new HashMap();
    protected DateUnit dateUnits;
    protected CalendarDateUnit calDateUnits;
    protected FileCacheIF fileCache;

    public AbstractRadialAdapter() {
    }

    public AbstractRadialAdapter(NetcdfDataset ds) {
        this.netcdfDataset = ds;
        this.location = this.netcdfDataset.getLocation();
        this.title = this.netcdfDataset.getTitle();
        if (this.title == null) {
            this.title = this.netcdfDataset.getRootGroup().findAttributeString("title", null);
        }
        if (this.desc == null) {
            this.desc = this.netcdfDataset.getRootGroup().findAttributeString("description", null);
        }
        this.parseInfo.append("RadialDatasetAdapter look for RadialVariables\n");
        for (Variable var : ds.getVariables()) {
            this.addRadialVariable(ds, var);
        }
    }

    protected abstract void addRadialVariable(NetcdfDataset var1, Variable var2);

    protected abstract RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset var1, Variable var2);

    protected abstract void setTimeUnits() throws Exception;

    protected abstract void setEarthLocation();

    protected abstract void setStartDate();

    protected abstract void setEndDate();

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setLocationURI(String location) {
        this.location = location;
    }

    protected void removeDataVariable(String varName) {
        Iterator<VariableSimpleIF> iter = this.dataVariables.iterator();
        while (iter.hasNext()) {
            VariableSimpleIF v = iter.next();
            if (!v.getShortName().equals(varName)) continue;
            iter.remove();
        }
    }

    protected void setBoundingBox() {
        LatLonRect largestBB = null;
        for (Object o : this.csHash.values()) {
            RadialCoordSys sys = (RadialCoordSys)o;
            sys.setOrigin(this.origin);
            LatLonRect bb = sys.getBoundingBox();
            if (largestBB == null) {
                largestBB = bb;
                continue;
            }
            if (bb == null) continue;
            largestBB.extend(bb);
        }
        this.boundingBox = largestBB;
    }

    public void calcBounds() throws IOException {
        this.setBoundingBox();
        try {
            this.setTimeUnits();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.setStartDate();
        this.setEndDate();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public LatLonRect getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public List<VariableSimpleIF> getDataVariables() {
        return this.dataVariables;
    }

    @Override
    public VariableSimpleIF getDataVariable(String shortName) {
        for (VariableSimpleIF s : this.dataVariables) {
            String ss = s.getShortName();
            if (!shortName.equals(ss)) continue;
            return s;
        }
        return null;
    }

    @Override
    public RadialDatasetSweep.Type getCommonType() {
        return null;
    }

    @Override
    public DateUnit getTimeUnits() {
        return this.dateUnits;
    }

    public CalendarDateUnit getCalendarDateUnit() {
        return this.calDateUnits;
    }

    public EarthLocation getEarthLocation() {
        return this.origin;
    }

    @Override
    public FeatureType[] getFeatureTypes() {
        return new FeatureType[]{FeatureType.RADIAL};
    }

    @Override
    public FeatureType getFeatureType() {
        return FeatureType.RADIAL;
    }

    public DateRange getDateRange() {
        return new DateRange(this.getStartDate(), this.getEndDate());
    }

    @Override
    public CalendarDateRange getCalendarDateRange() {
        return CalendarDateRange.of(this.getStartDate(), this.getEndDate());
    }

    @Override
    public CalendarDate getCalendarDateStart() {
        return CalendarDate.of(this.getStartDate());
    }

    @Override
    public CalendarDate getCalendarDateEnd() {
        return CalendarDate.of(this.getEndDate());
    }

    @Override
    public void getDetailInfo(Formatter sf) {
        sf.format("%s", this.getDetailInfo());
    }

    @Override
    public String getImplementationName() {
        return this.getClass().getName();
    }

    @Override
    @Deprecated
    public synchronized void setFileCache(FileCacheIF fileCache) {
        this.fileCache = fileCache;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fileCache != null && this.fileCache.release(this)) {
            return;
        }
        try {
            if (this.netcdfDataset != null) {
                this.netcdfDataset.close();
            }
        }
        finally {
            this.netcdfDataset = null;
        }
    }

    @Override
    @Deprecated
    public void release() throws IOException {
        if (this.netcdfDataset != null) {
            this.netcdfDataset.release();
        }
    }

    @Override
    @Deprecated
    public void reacquire() throws IOException {
        if (this.netcdfDataset != null) {
            this.netcdfDataset.reacquire();
        }
    }

    @Override
    public long getLastModified() {
        return this.netcdfDataset != null ? this.netcdfDataset.getLastModified() : 0L;
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.netcdfDataset;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String getLocationURI() {
        return this.location;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public AttributeContainer attributes() {
        return this.netcdfDataset != null ? this.netcdfDataset.getRootGroup().attributes() : new AttributeContainerMutable(this.getRadarName()).toImmutable();
    }

    @Override
    @Deprecated
    public List<Attribute> getGlobalAttributes() {
        if (this.netcdfDataset == null) {
            return new ArrayList<Attribute>();
        }
        return this.netcdfDataset.getGlobalAttributes();
    }

    @Override
    @Deprecated
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        if (this.netcdfDataset == null) {
            return null;
        }
        return this.netcdfDataset.findGlobalAttributeIgnoreCase(name);
    }

    public String getDetailInfo() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(" Radar ID = " + this.getRadarID() + "\n");
        sbuff.append(" Radar Name = " + this.getRadarName() + "\n");
        sbuff.append(" Data Format Name= " + this.getDataFormat() + "\n");
        sbuff.append(" Common Type = " + this.getCommonType() + "\n");
        sbuff.append(" Common Origin = " + this.getCommonOrigin() + "\n");
        CalendarDateUnit dt = this.getCalendarDateUnit();
        if (dt != null) {
            sbuff.append(" Date Unit = " + dt + "\n");
        }
        sbuff.append(" isStationary = " + this.isStationary() + "\n");
        sbuff.append(" isVolume = " + this.isVolume() + "\n");
        sbuff.append("\n");
        sbuff.append("  location= ").append(this.getLocation()).append("\n");
        sbuff.append("  title= ").append(this.getTitle()).append("\n");
        sbuff.append("  desc= ").append(this.getDescription()).append("\n");
        sbuff.append("  start= ").append(CalendarDateFormatter.toDateTimeString(this.getStartDate())).append("\n");
        sbuff.append("  end  = ").append(CalendarDateFormatter.toDateTimeString(this.getEndDate())).append("\n");
        sbuff.append("  bb   = ").append(this.getBoundingBox()).append("\n");
        if (this.getBoundingBox() != null) {
            sbuff.append("  bb   = ").append(this.getBoundingBox().toString2()).append("\n");
        }
        sbuff.append("  has netcdf = ").append(this.getNetcdfFile() != null).append("\n");
        if (!this.attributes().isEmpty()) {
            sbuff.append("  Attributes\n");
            for (Attribute a : this.attributes()) {
                sbuff.append("    ").append(a).append("\n");
            }
        }
        List<VariableSimpleIF> vars = this.getDataVariables();
        sbuff.append("  Variables (").append(vars.size()).append(")\n");
        for (VariableSimpleIF v : vars) {
            sbuff.append("    name='").append(v.getShortName()).append("' desc='").append(v.getDescription()).append("' units='").append(v.getUnitsString()).append("' type=").append((Object)v.getDataType()).append("\n");
        }
        sbuff.append("\nparseInfo=\n");
        sbuff.append(this.parseInfo);
        sbuff.append("\n");
        return sbuff.toString();
    }

    public static class MyRadialVariableAdapter
    implements VariableSimpleIF {
        private int rank = 1;
        private int[] shape = new int[]{1};
        protected String name;
        private String desc;
        private String units;
        private AttributeContainer attributes;

        public MyRadialVariableAdapter(String vName, Variable v) {
            this.name = vName;
            this.desc = v.getDescription();
            this.units = v.getUnitsString();
            this.attributes = v.attributes();
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(VariableSimpleIF o) {
            return this.getFullName().compareTo(o.getFullName());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getFullName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.name;
        }

        @Override
        public DataType getDataType() {
            return DataType.FLOAT;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        public String getInfo() {
            return this.desc;
        }

        @Override
        public String getUnitsString() {
            return this.units;
        }

        @Override
        public int getRank() {
            return this.rank;
        }

        @Override
        public int[] getShape() {
            return this.shape;
        }

        @Override
        public List<Dimension> getDimensions() {
            return null;
        }

        @Override
        @Deprecated
        public List<Attribute> getAttributes() {
            return this.attributes.getAttributes();
        }

        @Override
        public Attribute findAttributeIgnoreCase(String attName) {
            return this.attributes.findAttributeIgnoreCase(attName);
        }

        @Override
        public AttributeContainer attributes() {
            return new AttributeContainerMutable(this.name, this.attributes).toImmutable();
        }
    }
}

