/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.CancelTask;

public class StructurePseudoDS
extends StructureDS {
    private static Logger log = LoggerFactory.getLogger(StructurePseudoDS.class);
    private static boolean debugRecord;
    protected static final Set<NetcdfDataset.Enhance> enhanceScaleMissing;
    protected List<Variable> orgVariables = new ArrayList<Variable>();

    @Deprecated
    protected StructurePseudoDS(NetcdfDataset ncfile, Group group, String shortName) {
        super(ncfile, group, shortName);
    }

    @Deprecated
    public StructurePseudoDS(NetcdfDataset ncfile, Group group, String shortName, List<String> varNames, Dimension outerDim) {
        super(ncfile, group, shortName);
        Dimension dim0;
        this.setDimensions(outerDim.getShortName());
        if (group == null) {
            group = ncfile.getRootGroup();
        }
        if (varNames == null) {
            List<Variable> vars = group.getVariables();
            varNames = new ArrayList<String>(vars.size());
            for (Variable orgV : vars) {
                if (orgV.getDataType() == DataType.STRUCTURE || !outerDim.equals(dim0 = orgV.getDimension(0))) continue;
                varNames.add(orgV.getShortName());
            }
        }
        for (String name : varNames) {
            Variable orgV;
            orgV = group.findVariableLocal(name);
            if (orgV == null) {
                log.warn("StructurePseudoDS cannot find variable " + name);
                continue;
            }
            dim0 = orgV.getDimension(0);
            if (!outerDim.equals(dim0)) {
                throw new IllegalArgumentException("Variable " + orgV.getNameAndDimensions() + " must have outermost dimension=" + outerDim);
            }
            VariableDS memberV = new VariableDS(ncfile, group, this, orgV.getShortName(), orgV.getDataType(), null, orgV.getUnitsString(), orgV.getDescription());
            memberV.setSPobject(orgV.getSPobject());
            memberV.addAll(orgV.attributes());
            ArrayList<Dimension> dims = new ArrayList<Dimension>((Collection<Dimension>)orgV.getDimensions());
            dims.remove(0);
            memberV.setDimensions(dims);
            memberV.enhance(enhanceScaleMissing);
            this.addMemberVariable(memberV);
            this.orgVariables.add(orgV);
        }
        this.calcElementSize();
    }

    @Override
    protected StructureDS copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Structure select(List<String> memberNames) {
        StructurePseudoDS result = new StructurePseudoDS((NetcdfDataset)this.ncfile, this.getParentGroupOrRoot(), this.getShortName(), memberNames, this.getDimension(0));
        result.isSubset = true;
        return result;
    }

    @Override
    @Deprecated
    public boolean removeMemberVariable(Variable v) {
        if (super.removeMemberVariable(v)) {
            Iterator<Variable> iter = this.orgVariables.iterator();
            while (iter.hasNext()) {
                Variable mv = iter.next();
                if (!mv.getShortName().equals(v.getShortName())) continue;
                iter.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public Array reallyRead(Variable mainv, CancelTask cancelTask) throws IOException {
        if (debugRecord) {
            System.out.println(" read all psuedo records ");
        }
        StructureMembers smembers = this.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(smembers, this.getShape());
        for (Variable v : this.orgVariables) {
            Array data = v.read();
            StructureMembers.Member m = smembers.findMember(v.getShortName());
            m.setDataArray(data);
        }
        return asma;
    }

    @Override
    public Array reallyRead(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        String err;
        if (null == section) {
            return this._read();
        }
        if (debugRecord) {
            System.out.println(" read psuedo records " + section.getRange(0));
        }
        if ((err = section.checkInRange(this.getShape())) != null) {
            throw new InvalidRangeException(err);
        }
        Range r = section.getRange(0);
        StructureMembers smembers = this.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(smembers, section.getShape());
        for (Variable v : this.orgVariables) {
            ArrayList<Range> vsection = new ArrayList<Range>((Collection<Range>)v.getRanges());
            vsection.set(0, r);
            Array data = v.read(vsection);
            StructureMembers.Member m = smembers.findMember(v.getShortName());
            m.setDataArray(data);
        }
        return asma;
    }

    protected StructurePseudoDS(Builder<?> builder, Group parentGroup) {
        super((StructureDS.Builder<?>)builder, parentGroup);
        this.orgVariables = ((Builder)builder).orgVariables;
    }

    @Override
    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(StructurePseudoDS.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        b.addOriginalVariables(this.orgVariables);
        return (Builder)super.addLocalFieldsToBuilder((StructureDS.Builder<? extends StructureDS.Builder<?>>)b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    static {
        enhanceScaleMissing = EnumSet.of(NetcdfDataset.Enhance.ApplyScaleOffset, NetcdfDataset.Enhance.ConvertMissing);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends StructureDS.Builder<T> {
        private List<Variable> orgVariables = new ArrayList<Variable>();
        private boolean built;

        public T addOriginalVariable(Variable orgVar) {
            this.orgVariables.add(orgVar);
            return (T)((Builder)this.self());
        }

        public T addOriginalVariables(List<Variable> orgVars) {
            this.orgVariables.addAll(orgVars);
            return (T)((Builder)this.self());
        }

        @Override
        public StructurePseudoDS build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            this.setDataType(DataType.STRUCTURE);
            return new StructurePseudoDS(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

