/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.simpgeometry.adapter;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft2.simpgeometry.GeometryType;
import ucar.nc2.ft2.simpgeometry.Line;
import ucar.nc2.ft2.simpgeometry.Point;
import ucar.nc2.ft2.simpgeometry.Polygon;
import ucar.nc2.ft2.simpgeometry.SimpleGeometryReader;
import ucar.nc2.ft2.simpgeometry.adapter.SimpleGeometryCS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;

public class SimpleGeometryCSBuilder {
    private FeatureType type;
    private List<CoordinateAxis> allAxes;
    private List<CoordinateAxis> sgAxes;
    private List<CoordinateTransform> coordTransforms;
    private List<Dimension> dims;
    private List<String> geometrySeriesVarNames;
    private List<String> geometryContainerNames;
    private SimpleGeometryReader geometryReader;
    private Map<String, List<String>> geometryContainersAssoc;
    private ProjectionImpl orgProj;

    public static SimpleGeometryCSBuilder classify(NetcdfDataset ds, Formatter errlog) {
        if (errlog != null) {
            errlog.format("SimpleGeometryFactory for '%s'%n", ds.getLocation());
        }
        ArrayList<CoordinateSystem> css = new ArrayList<CoordinateSystem>(ds.getCoordinateSystems());
        css.sort((o1, o2) -> o2.getCoordinateAxes().size() - o1.getCoordinateAxes().size());
        SimpleGeometryCSBuilder builder = null;
        for (CoordinateSystem cs : css) {
            builder = new SimpleGeometryCSBuilder(ds, cs, errlog);
            if (builder.type == null) continue;
            break;
        }
        if (builder == null) {
            return null;
        }
        if (errlog != null) {
            errlog.format("simple geometry = %s%n", new Object[]{builder.type});
        }
        return builder;
    }

    public static String describe(NetcdfDataset ds, Formatter errlog) {
        SimpleGeometryCSBuilder fac = SimpleGeometryCSBuilder.classify(ds, errlog);
        return fac == null || fac.type == null ? "" : fac.showSummary();
    }

    public static String describe(NetcdfDataset ds, CoordinateSystem cs, Formatter errlog) {
        SimpleGeometryCSBuilder fac = new SimpleGeometryCSBuilder(ds, cs, errlog);
        return fac.type == null ? "" : fac.showSummary();
    }

    public SimpleGeometryCSBuilder(NetcdfDataset ds, CoordinateSystem cs, Formatter errlog) {
        if (cs.getRankDomain() < 2) {
            if (errlog != null) {
                errlog.format("CoordinateSystem '%s': domain rank < 2%n", cs.getName());
            }
            return;
        }
        this.sgAxes = new ArrayList<CoordinateAxis>();
        this.geometrySeriesVarNames = new ArrayList<String>();
        this.geometryContainerNames = new ArrayList<String>();
        this.geometryContainersAssoc = new HashMap<String, List<String>>();
        this.dims = ds.getDimensions();
        this.allAxes = cs.getCoordinateAxes();
        for (Variable var : ds.getVariables()) {
            if (var.findAttValueIgnoreCase("geometry", "").equals("")) continue;
            this.geometrySeriesVarNames.add(var.getFullNameEscaped());
            String varName = var.findAttValueIgnoreCase("geometry", "");
            if (ds.findVariable(varName) == null) continue;
            if (!this.geometryContainerNames.contains(varName)) {
                this.geometryContainerNames.add(varName);
            }
            if (this.geometryContainersAssoc.get(varName) == null) {
                ArrayList strList = new ArrayList();
                this.geometryContainersAssoc.put(varName, strList);
            }
            this.geometryContainersAssoc.get(var.findAttValueIgnoreCase("geometry", "")).add(var.getFullNameEscaped());
        }
        boolean sgtype = false;
        for (CoordinateAxis axis : cs.getCoordinateAxes()) {
            if (axis.getAxisType() != AxisType.SimpleGeometryID && axis.getAxisType() != AxisType.SimpleGeometryX && axis.getAxisType() != AxisType.SimpleGeometryY && axis.getAxisType() != AxisType.SimpleGeometryZ) continue;
            this.sgAxes.add(axis);
            sgtype = true;
        }
        if (sgtype) {
            this.geometryReader = new SimpleGeometryReader(ds);
            this.type = FeatureType.SIMPLE_GEOMETRY;
        } else {
            this.geometryReader = null;
        }
        this.type = this.classify();
        this.coordTransforms = new ArrayList<CoordinateTransform>(cs.getCoordinateTransforms());
        this.orgProj = cs.getProjection();
    }

    private FeatureType classify() {
        if (this.geometryReader != null) {
            return FeatureType.SIMPLE_GEOMETRY;
        }
        return null;
    }

    public List<CoordinateAxis> getAllAxes() {
        return this.allAxes;
    }

    public List<CoordinateTransform> getCoordTransforms() {
        return this.coordTransforms;
    }

    public List<Dimension> getDimensions() {
        return this.dims;
    }

    public List<CoordinateAxis> getSgAxes() {
        return this.sgAxes;
    }

    public GeometryType getGeometryType(String name) {
        return this.geometryReader.getGeometryType(name);
    }

    public Projection getProjection() {
        return this.orgProj;
    }

    public Polygon getPolygon(String name, int index) {
        return this.geometryReader.readPolygon(name, index);
    }

    public List<Polygon> getPolygons(String name, int indexBegin, int indexEnd) {
        ArrayList<Polygon> polyList = new ArrayList<Polygon>();
        for (int i = indexBegin; i <= indexEnd; ++i) {
            polyList.add(this.geometryReader.readPolygon(name, i));
        }
        return polyList;
    }

    public Line getLine(String name, int index) {
        return this.geometryReader.readLine(name, index);
    }

    public List<Line> getLines(String name, int indexBegin, int indexEnd) {
        ArrayList<Line> lineList = new ArrayList<Line>();
        for (int i = indexBegin; i <= indexEnd; ++i) {
            lineList.add(this.geometryReader.readLine(name, i));
        }
        return lineList;
    }

    public Point getPoint(String name, int index) {
        return this.geometryReader.readPoint(name, index);
    }

    public List<Point> getPoints(String name, int indexBegin, int indexEnd) {
        ArrayList<Point> ptList = new ArrayList<Point>();
        for (int i = indexBegin; i <= indexEnd; ++i) {
            ptList.add(this.geometryReader.readPoint(name, i));
        }
        return ptList;
    }

    public List<String> getGeometryContainerNames() {
        return this.geometryContainerNames;
    }

    public List<String> getGeometrySeriesNames() {
        return this.geometrySeriesVarNames;
    }

    public List<String> getGeometryContainerAssociations(String nameOfContainer) {
        return this.geometryContainersAssoc.get(nameOfContainer);
    }

    public SimpleGeometryCS makeCoordSys() {
        if (this.type == null) {
            return null;
        }
        if (this.type == FeatureType.SIMPLE_GEOMETRY) {
            return new SimpleGeometryCS(this);
        }
        return null;
    }

    public FeatureType getFeatureType() {
        return this.type;
    }

    public String toString() {
        Formatter f2 = new Formatter();
        f2.format("%s", this.type == null ? "" : this.type.toString());
        if (this.type == null) {
            f2.close();
            return "";
        }
        f2.format("}", new Object[0]);
        f2.format("%n allAxes=(", new Object[0]);
        for (CoordinateAxis axis : this.allAxes) {
            f2.format("%s, ", axis.getShortName());
        }
        f2.format(") {", new Object[0]);
        for (Dimension dim : CoordinateSystem.makeDomain(this.allAxes)) {
            f2.format("%s, ", dim.getShortName());
        }
        f2.format("}%n", new Object[0]);
        String stringRepres = f2.toString();
        f2.close();
        return stringRepres;
    }

    public String showSummary() {
        if (this.type == null) {
            return "";
        }
        Formatter f2 = new Formatter();
        f2.format("%s", this.type.toString());
        f2.format("(", new Object[0]);
        f2.format(")", new Object[0]);
        String stringRepres = f2.toString();
        f2.close();
        return stringRepres;
    }
}

