/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.remote;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.LatLonAxis2D;
import ucar.nc2.ft2.coverage.remote.CdmrFeatureProto;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamDataCol;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

public class CdmrfWriter {
    public static final byte[] MAGIC_START = new byte[]{67, 68, 70, 70};
    public static final int MAX_INLINE_NVALUES = 500;
    private static final boolean show = false;

    public long sendHeader(OutputStream out, CoverageCollection gridDataset, String location) throws IOException {
        long size = 0L;
        CdmrFeatureProto.CoverageDataset.Builder headerBuilder = this.encodeHeader(gridDataset, location);
        CdmrFeatureProto.CoverageDataset header = headerBuilder.build();
        size += (long)NcStream.writeBytes(out, NcStream.MAGIC_HEADERCOV);
        byte[] b = header.toByteArray();
        size += (long)NcStream.writeVInt(out, b.length);
        return size += (long)NcStream.writeBytes(out, b);
    }

    CdmrFeatureProto.CoverageDataset.Builder encodeHeader(CoverageCollection gridDataset, String location) {
        CdmrFeatureProto.CoverageDataset.Builder builder = CdmrFeatureProto.CoverageDataset.newBuilder();
        builder.setName(location);
        builder.setCoverageType(CdmrfWriter.convertCoverageType(gridDataset.getCoverageType()));
        builder.setDateRange(this.encodeDateRange(gridDataset.getCalendarDateRange()));
        if (gridDataset.getLatlonBoundingBox() != null) {
            builder.setLatlonRect(this.encodeRectangle(gridDataset.getLatlonBoundingBox()));
        }
        if (gridDataset.getProjBoundingBox() != null) {
            builder.setProjRect(this.encodeRectangle(gridDataset.getProjBoundingBox()));
        }
        for (Attribute att : gridDataset.getGlobalAttributes()) {
            builder.addAtts(NcStream.encodeAtt(att));
        }
        for (CoverageCoordSys gcs : gridDataset.getCoordSys()) {
            builder.addCoordSys(this.encodeCoordSys(gcs));
        }
        for (CoverageTransform gct : gridDataset.getCoordTransforms()) {
            builder.addCoordTransforms(this.encodeCoordTransform(gct));
        }
        for (CoverageCoordAxis axis : gridDataset.getCoordAxes()) {
            builder.addCoordAxes(this.encodeCoordAxis(axis));
        }
        for (Coverage grid : gridDataset.getCoverages()) {
            builder.addGrids(this.encodeGrid(grid));
        }
        return builder;
    }

    CdmrFeatureProto.Rectangle.Builder encodeRectangle(LatLonRect rect) {
        CdmrFeatureProto.Rectangle.Builder builder = CdmrFeatureProto.Rectangle.newBuilder();
        LatLonPointImpl ll = rect.getLowerLeftPoint();
        LatLonPointImpl ur = rect.getUpperRightPoint();
        builder.setStartx(ll.getLongitude());
        builder.setStarty(ll.getLatitude());
        builder.setIncx(rect.getWidth());
        builder.setIncy(ur.getLatitude() - ll.getLatitude());
        return builder;
    }

    CdmrFeatureProto.Rectangle.Builder encodeRectangle(ProjectionRect rect) {
        CdmrFeatureProto.Rectangle.Builder builder = CdmrFeatureProto.Rectangle.newBuilder();
        builder.setStartx(rect.getMinX());
        builder.setStarty(rect.getMaxX());
        builder.setIncx(rect.getWidth());
        builder.setIncy(rect.getHeight());
        return builder;
    }

    CdmrFeatureProto.CalendarDateRange.Builder encodeDateRange(CalendarDateRange dateRange) {
        CdmrFeatureProto.CalendarDateRange.Builder builder = CdmrFeatureProto.CalendarDateRange.newBuilder();
        builder.setStart(dateRange.getStart().getMillis());
        builder.setEnd(dateRange.getEnd().getMillis());
        Calendar cal = dateRange.getStart().getCalendar();
        builder.setCalendar(CdmrfWriter.convertCalendar(cal));
        return builder;
    }

    CdmrFeatureProto.Coverage.Builder encodeGrid(Coverage grid) {
        CdmrFeatureProto.Coverage.Builder builder = CdmrFeatureProto.Coverage.newBuilder();
        builder.setName(grid.getName());
        builder.setDataType(NcStream.convertDataType(grid.getDataType()));
        for (Attribute att : grid.getAttributes()) {
            builder.addAtts(NcStream.encodeAtt(att));
        }
        builder.setUnits(grid.getUnitsString());
        builder.setDescription(grid.getDescription());
        builder.setCoordSys(grid.getCoordSysName());
        return builder;
    }

    CdmrFeatureProto.CoordSys.Builder encodeCoordSys(CoverageCoordSys gcs) {
        CdmrFeatureProto.CoordSys.Builder builder = CdmrFeatureProto.CoordSys.newBuilder();
        builder.setName(gcs.getName());
        builder.setCoverageType(CdmrfWriter.convertCoverageType(gcs.getCoverageType()));
        for (String axis : gcs.getAxisNames()) {
            builder.addAxisNames(axis);
        }
        for (String gct : gcs.getTransformNames()) {
            builder.addTransformNames(gct);
        }
        return builder;
    }

    CdmrFeatureProto.CoordTransform.Builder encodeCoordTransform(CoverageTransform gct) {
        CdmrFeatureProto.CoordTransform.Builder builder = CdmrFeatureProto.CoordTransform.newBuilder();
        builder.setIsHoriz(gct.isHoriz());
        builder.setName(gct.getName());
        for (Attribute att : gct.getAttributes()) {
            builder.addParams(NcStream.encodeAtt(att));
        }
        return builder;
    }

    CdmrFeatureProto.CoordAxis.Builder encodeCoordAxis(CoverageCoordAxis axis) {
        CdmrFeatureProto.CoordAxis.Builder builder = CdmrFeatureProto.CoordAxis.newBuilder();
        builder.setName(axis.getName());
        builder.setDataType(NcStream.convertDataType(axis.getDataType()));
        builder.setAxisType(CdmrfWriter.convertAxisType(axis.getAxisType()));
        builder.setNvalues(axis.getNcoords());
        if (axis.getUnits() != null) {
            builder.setUnits(axis.getUnits());
        }
        if (axis.getDescription() != null) {
            builder.setDescription(axis.getDescription());
        }
        builder.setDepend(CdmrfWriter.convertDependenceType(axis.getDependenceType()));
        for (String string : axis.getDependsOnList()) {
            builder.addDependsOn(string);
        }
        if (axis instanceof LatLonAxis2D) {
            LatLonAxis2D latlon2D = (LatLonAxis2D)axis;
            for (int shape : latlon2D.getShape()) {
                builder.addShape(shape);
            }
        }
        for (Attribute attribute : axis.getAttributes()) {
            builder.addAtts(NcStream.encodeAtt(attribute));
        }
        builder.setSpacing(CdmrfWriter.convertSpacing(axis.getSpacing()));
        builder.setStartValue(axis.getStartValue());
        builder.setEndValue(axis.getEndValue());
        builder.setResolution(axis.getResolution());
        if (!axis.isRegular() && axis.getNcoords() < 500) {
            double[] values = axis.getValues();
            ByteBuffer byteBuffer = ByteBuffer.allocate(8 * values.length);
            DoubleBuffer db = byteBuffer.asDoubleBuffer();
            db.put(values);
            builder.setValues(ByteString.copyFrom((byte[])byteBuffer.array()));
        }
        return builder;
    }

    public static CdmrFeatureProto.AxisType convertAxisType(AxisType dtype) {
        switch (dtype) {
            case RunTime: {
                return CdmrFeatureProto.AxisType.RunTime;
            }
            case Ensemble: {
                return CdmrFeatureProto.AxisType.Ensemble;
            }
            case Time: {
                return CdmrFeatureProto.AxisType.Time;
            }
            case GeoX: {
                return CdmrFeatureProto.AxisType.GeoX;
            }
            case GeoY: {
                return CdmrFeatureProto.AxisType.GeoY;
            }
            case GeoZ: {
                return CdmrFeatureProto.AxisType.GeoZ;
            }
            case Lat: {
                return CdmrFeatureProto.AxisType.Lat;
            }
            case Lon: {
                return CdmrFeatureProto.AxisType.Lon;
            }
            case Height: {
                return CdmrFeatureProto.AxisType.Height;
            }
            case Pressure: {
                return CdmrFeatureProto.AxisType.Pressure;
            }
            case RadialAzimuth: {
                return CdmrFeatureProto.AxisType.RadialAzimuth;
            }
            case RadialDistance: {
                return CdmrFeatureProto.AxisType.RadialDistance;
            }
            case RadialElevation: {
                return CdmrFeatureProto.AxisType.RadialElevation;
            }
            case Spectral: {
                return CdmrFeatureProto.AxisType.Spectral;
            }
            case TimeOffset: {
                return CdmrFeatureProto.AxisType.TimeOffset;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)dtype));
    }

    public static CdmrFeatureProto.Calendar convertCalendar(Calendar type) {
        switch (type) {
            case gregorian: {
                return CdmrFeatureProto.Calendar.gregorian;
            }
            case proleptic_gregorian: {
                return CdmrFeatureProto.Calendar.proleptic_gregorian;
            }
            case noleap: {
                return CdmrFeatureProto.Calendar.noleap;
            }
            case all_leap: {
                return CdmrFeatureProto.Calendar.all_leap;
            }
            case uniform30day: {
                return CdmrFeatureProto.Calendar.uniform30day;
            }
            case julian: {
                return CdmrFeatureProto.Calendar.julian;
            }
            case none: {
                return CdmrFeatureProto.Calendar.none;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)type));
    }

    public static CdmrFeatureProto.CoverageType convertCoverageType(FeatureType type) {
        switch (type) {
            case COVERAGE: {
                return CdmrFeatureProto.CoverageType.General;
            }
            case CURVILINEAR: {
                return CdmrFeatureProto.CoverageType.Curvilinear;
            }
            case GRID: {
                return CdmrFeatureProto.CoverageType.Grid;
            }
            case SWATH: {
                return CdmrFeatureProto.CoverageType.Swath;
            }
            case FMRC: {
                return CdmrFeatureProto.CoverageType.Fmrc;
            }
        }
        throw new IllegalStateException("illegal CoverageType " + (Object)((Object)type));
    }

    public static CdmrFeatureProto.DependenceType convertDependenceType(CoverageCoordAxis.DependenceType type) {
        switch (type) {
            case independent: {
                return CdmrFeatureProto.DependenceType.independent;
            }
            case dependent: {
                return CdmrFeatureProto.DependenceType.dependent;
            }
            case scalar: {
                return CdmrFeatureProto.DependenceType.scalar;
            }
            case twoD: {
                return CdmrFeatureProto.DependenceType.twoD;
            }
            case fmrcReg: {
                return CdmrFeatureProto.DependenceType.fmrcReg;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)type));
    }

    public static CdmrFeatureProto.AxisSpacing convertSpacing(CoverageCoordAxis.Spacing type) {
        switch (type) {
            case regularPoint: {
                return CdmrFeatureProto.AxisSpacing.regularPoint;
            }
            case irregularPoint: {
                return CdmrFeatureProto.AxisSpacing.irregularPoint;
            }
            case contiguousInterval: {
                return CdmrFeatureProto.AxisSpacing.contiguousInterval;
            }
            case discontiguousInterval: {
                return CdmrFeatureProto.AxisSpacing.discontiguousInterval;
            }
            case regularInterval: {
                return CdmrFeatureProto.AxisSpacing.regularInterval;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)type));
    }

    public CdmrFeatureProto.CoverageDataResponse encodeDataResponse(Iterable<CoverageCoordAxis> axes, Iterable<CoverageCoordSys> coordSys, Iterable<CoverageTransform> transforms, List<GeoReferencedArray> arrays, boolean deflate) {
        CdmrFeatureProto.CoverageDataResponse.Builder builder = CdmrFeatureProto.CoverageDataResponse.newBuilder();
        for (CoverageCoordAxis axis : axes) {
            builder.addCoordAxes(this.encodeCoordAxis(axis));
        }
        for (CoverageCoordSys cs : coordSys) {
            builder.addCoordSys(this.encodeCoordSys(cs));
        }
        for (CoverageTransform t : transforms) {
            builder.addCoordTransforms(this.encodeCoordTransform(t));
        }
        for (GeoReferencedArray array : arrays) {
            builder.addGeoArray(this.encodeGeoReferencedArray(array, deflate));
        }
        return builder.build();
    }

    public CdmrFeatureProto.GeoReferencedArray.Builder encodeGeoReferencedArray(GeoReferencedArray geoArray, boolean deflate) {
        int[] shape;
        CdmrFeatureProto.GeoReferencedArray.Builder builder = CdmrFeatureProto.GeoReferencedArray.newBuilder();
        builder.setCoverageName(geoArray.getCoverageName());
        builder.setDataType(NcStream.convertDataType(geoArray.getDataType()));
        builder.setVersion(3);
        builder.setBigend(ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN);
        for (int aShape : shape = geoArray.getData().getShape()) {
            builder.addShape(aShape);
        }
        CoverageCoordSys csys = geoArray.getCoordSysForData();
        for (String axisName : csys.getAxisNames()) {
            builder.addAxisName(axisName);
        }
        builder.setCoordSysName(csys.getName());
        if (deflate) {
            builder.setCompress(NcStreamProto.Compress.DEFLATE);
            long uncompressedSize = geoArray.getData().getSizeBytes();
            builder.setUncompressedSize(uncompressedSize);
        } else {
            builder.setPrimdata(NcStreamDataCol.copyArrayToByteString(geoArray.getData()));
        }
        return builder;
    }

    private long sendData(Array data, OutputStream out, boolean deflate) throws IOException {
        long uncompressedLength = data.getSizeBytes();
        long size = 0L;
        if (deflate) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DeflaterOutputStream dout = new DeflaterOutputStream(bout);
            IospHelper.copyToOutputStream(data, dout);
            dout.close();
            int deflatedSize = bout.size();
            size += (long)NcStream.writeVInt(out, deflatedSize);
            bout.writeTo(out);
            size += (long)deflatedSize;
        } else {
            size += (long)NcStream.writeVInt(out, (int)uncompressedLength);
            size += IospHelper.copyToOutputStream(data, out);
        }
        return size;
    }

    private int writeBytes(OutputStream out, byte[] b) throws IOException {
        out.write(b);
        return b.length;
    }
}

