/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.radial.AbstractRadialAdapter;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;

public class Dorade2RadialAdapter
extends AbstractRadialAdapter {
    private NetcdfDataset ncd;
    float[] elev;
    float[] aziv;
    float[] disv;
    float[] lonv;
    float[] altv;
    float[] latv;
    double[] timv;
    float ranv;
    float cellv;
    float angv;
    float nyqv;
    float rangv;
    float contv;
    float rgainv;
    float bwidthv;

    @Override
    public Object isMine(FeatureType wantFeatureType, NetcdfDataset ncd, Formatter errlog) {
        String format;
        String convention = ncd.findAttValueIgnoreCase(null, "Conventions", null);
        if ("_Coordinates".equals(convention) && "Unidata/netCDF/Dorade".equals(format = ncd.findAttValueIgnoreCase(null, "Format", null))) {
            return this;
        }
        return null;
    }

    @Override
    public FeatureDataset open(FeatureType ftype, NetcdfDataset ncd, Object analysis, CancelTask task, Formatter errlog) {
        return new Dorade2RadialAdapter(ncd);
    }

    public FeatureType getScientificDataType() {
        return FeatureType.RADIAL;
    }

    public Dorade2RadialAdapter() {
    }

    public Dorade2RadialAdapter(NetcdfDataset ds) {
        super(ds);
        this.ncd = ds;
        this.desc = "dorade radar dataset";
        try {
            this.elev = (float[])this.ncd.findVariable("elevation").read().get1DJavaArray(Float.TYPE);
            this.aziv = (float[])this.ncd.findVariable("azimuth").read().get1DJavaArray(Float.TYPE);
            this.altv = (float[])this.ncd.findVariable("altitudes_1").read().get1DJavaArray(Float.TYPE);
            this.lonv = (float[])this.ncd.findVariable("longitudes_1").read().get1DJavaArray(Float.TYPE);
            this.latv = (float[])this.ncd.findVariable("latitudes_1").read().get1DJavaArray(Float.TYPE);
            this.disv = (float[])this.ncd.findVariable("distance_1").read().get1DJavaArray(Float.TYPE);
            this.timv = (double[])this.ncd.findVariable("rays_time").read().get1DJavaArray(Double.TYPE);
            this.angv = this.ncd.findVariable("Fixed_Angle").readScalarFloat();
            this.nyqv = this.ncd.findVariable("Nyquist_Velocity").readScalarFloat();
            this.rangv = this.ncd.findVariable("Unambiguous_Range").readScalarFloat();
            this.contv = this.ncd.findVariable("Radar_Constant").readScalarFloat();
            this.rgainv = this.ncd.findVariable("rcvr_gain").readScalarFloat();
            this.setStartDate();
            this.setEndDate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getRadarID() {
        return this.ncd.findGlobalAttribute("radar_name").getStringValue();
    }

    @Override
    public String getRadarName() {
        return "Dorade Radar";
    }

    @Override
    public String getDataFormat() {
        return "DORADE";
    }

    @Override
    public EarthLocation getCommonOrigin() {
        if (this.isStationary()) {
            return new EarthLocationImpl(this.latv[0], this.lonv[0], this.elev[0]);
        }
        return null;
    }

    @Override
    public boolean isStationary() {
        String t = this.ncd.findGlobalAttribute("IsStationary").getStringValue();
        return t.equals("1");
    }

    @Override
    public boolean isVolume() {
        return false;
    }

    @Override
    protected void setEarthLocation() {
        if (this.isStationary()) {
            this.origin = new EarthLocationImpl(this.latv[0], this.lonv[0], this.elev[0]);
        }
        this.origin = null;
    }

    @Override
    protected void addRadialVariable(NetcdfDataset nds, Variable var) {
        RadialDatasetSweep.RadialVariable rsvar = null;
        String vName = var.getShortName();
        int rnk = var.getRank();
        if (rnk == 2) {
            AbstractRadialAdapter.MyRadialVariableAdapter v = new AbstractRadialAdapter.MyRadialVariableAdapter(vName, var.getAttributes());
            rsvar = this.makeRadialVariable(nds, v, var);
        }
        if (rsvar != null) {
            this.dataVariables.add(rsvar);
        }
    }

    @Override
    protected RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
        return new Dorade2Variable(nds, v, v0);
    }

    @Override
    protected void setStartDate() {
        Date da = new Date((long)this.timv[0]);
        String start_datetime = da.toString();
        if (start_datetime != null) {
            this.startDate = da;
        } else {
            this.parseInfo.append("*** start_datetime not Found\n");
        }
    }

    @Override
    protected void setEndDate() {
        Date da = new Date((long)this.timv[this.timv.length - 1]);
        String end_datetime = da.toString();
        if (end_datetime != null) {
            this.endDate = da;
        } else {
            this.parseInfo.append("*** end_datetime not Found\n");
        }
    }

    @Override
    protected void setTimeUnits() throws Exception {
        for (CoordinateAxis axis : this.ncd.getCoordinateAxes()) {
            if (axis.getAxisType() != AxisType.Time) continue;
            String units = axis.getUnitsString();
            this.dateUnits = new DateUnit(units);
            return;
        }
        this.parseInfo.append("*** Time Units not Found\n");
    }

    public List getAttributes() {
        return this.ncd.getRootGroup().getAttributes();
    }

    @Override
    public DateUnit getTimeUnits() {
        return this.dateUnits;
    }

    public void getTimeUnits(DateUnit dateUnits) {
        this.dateUnits = dateUnits;
    }

    @Override
    public void clearDatasetMemory() {
        for (VariableSimpleIF rvar : this.getDataVariables()) {
            RadialDatasetSweep.RadialVariable radVar = (RadialDatasetSweep.RadialVariable)rvar;
            radVar.clearVariableMemory();
        }
    }

    private class Dorade2Variable
    extends AbstractRadialAdapter.MyRadialVariableAdapter
    implements RadialDatasetSweep.RadialVariable {
        ArrayList<Dorade2Sweep> sweeps;
        String name;
        float azi;

        @Override
        public int getNumSweeps() {
            return 1;
        }

        @Override
        public RadialDatasetSweep.Sweep getSweep(int nsw) {
            return this.sweeps.get(nsw);
        }

        private Dorade2Variable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
            super(v.getShortName(), v0.getAttributes());
            this.sweeps = new ArrayList();
            this.name = v.getShortName();
            int[] shape = v0.getShape();
            int count = v0.getRank() - 1;
            int ngates = shape[count];
            int nrays = shape[--count];
            this.sweeps.add(new Dorade2Sweep(v0, 0, nrays, ngates));
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public float[] readAllData() throws IOException {
            Array allData;
            RadialDatasetSweep.Sweep spn = this.sweeps.get(0);
            Variable v = spn.getsweepVar();
            try {
                allData = v.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            return (float[])allData.get1DJavaArray(Float.TYPE);
        }

        @Override
        public void clearVariableMemory() {
        }

        private class Dorade2Sweep
        implements RadialDatasetSweep.Sweep {
            int nrays;
            int ngates;
            double meanElevation = Double.NaN;
            Variable sweepVar;

            Dorade2Sweep(Variable v, int sweepno, int rays, int gates) {
                this.sweepVar = v;
                this.nrays = rays;
                this.ngates = gates;
            }

            @Override
            public Variable getsweepVar() {
                return this.sweepVar;
            }

            @Override
            public RadialDatasetSweep.Type getType() {
                return null;
            }

            public float getLon(int ray) {
                return Dorade2RadialAdapter.this.lonv[ray];
            }

            @Override
            public int getGateNumber() {
                return this.ngates;
            }

            @Override
            public int getRadialNumber() {
                return this.nrays;
            }

            @Override
            public int getSweepIndex() {
                return 0;
            }

            @Override
            public float[] readData() throws IOException {
                return Dorade2Variable.this.readAllData();
            }

            @Override
            public float[] readData(int ray) throws IOException {
                Array rayData;
                int[] shape = this.sweepVar.getShape();
                int[] origi = new int[this.sweepVar.getRank()];
                shape[0] = 1;
                origi[0] = ray;
                try {
                    rayData = this.sweepVar.read(origi, shape);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e.getMessage());
                }
                return (float[])rayData.get1DJavaArray(Float.TYPE);
            }

            @Override
            public float getBeamWidth() {
                try {
                    Dorade2RadialAdapter.this.bwidthv = Dorade2RadialAdapter.this.ncd.findVariable("bm_width").readScalarFloat();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Dorade2RadialAdapter.this.bwidthv;
            }

            @Override
            public float getNyquistFrequency() {
                return 0.0f;
            }

            @Override
            public float getRangeToFirstGate() {
                try {
                    Dorade2RadialAdapter.this.ranv = Dorade2RadialAdapter.this.ncd.findVariable("Range_to_First_Cell").readScalarFloat();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Dorade2RadialAdapter.this.ranv;
            }

            @Override
            public float getGateSize() {
                try {
                    Dorade2RadialAdapter.this.cellv = Dorade2RadialAdapter.this.ncd.findVariable("Cell_Spacing").readScalarFloat();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Dorade2RadialAdapter.this.cellv;
            }

            @Override
            public float getMeanElevation() {
                int[] shapeRadial = new int[]{this.nrays};
                Array data = Array.factory(DataType.FLOAT, shapeRadial, (Object)Dorade2RadialAdapter.this.elev);
                this.meanElevation = MAMath.sumDouble(data) / (double)data.getSize();
                return (float)this.meanElevation;
            }

            @Override
            public float getElevation(int ray) {
                return Dorade2RadialAdapter.this.elev[ray];
            }

            @Override
            public float[] getElevation() {
                return Dorade2RadialAdapter.this.elev;
            }

            @Override
            public float getAzimuth(int ray) {
                return Dorade2RadialAdapter.this.aziv[ray];
            }

            @Override
            public float[] getAzimuth() {
                return Dorade2RadialAdapter.this.aziv;
            }

            public float getTime() {
                return (float)Dorade2RadialAdapter.this.timv[0];
            }

            @Override
            public float getTime(int ray) {
                return (float)Dorade2RadialAdapter.this.timv[ray];
            }

            @Override
            public EarthLocation getOrigin(int ray) {
                return new EarthLocationImpl(Dorade2RadialAdapter.this.latv[ray], Dorade2RadialAdapter.this.lonv[ray], Dorade2RadialAdapter.this.altv[ray]);
            }

            @Override
            public float getMeanAzimuth() {
                if (this.getType() != null) {
                    return Dorade2Variable.this.azi;
                }
                return 0.0f;
            }

            @Override
            public Date getStartingTime() {
                return Dorade2RadialAdapter.this.startDate;
            }

            @Override
            public Date getEndingTime() {
                return Dorade2RadialAdapter.this.endDate;
            }

            @Override
            public void clearSweepMemory() {
            }
        }
    }
}

