/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import javax.annotation.concurrent.Immutable;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.VertTransformBuilderIF;
import ucar.unidata.geoloc.vertical.VerticalTransform;

@Immutable
public class VerticalCT
extends CoordinateTransform {
    private final Type type;
    private final VertTransformBuilderIF builder;

    public VerticalCT(String name, String authority, Type type, VertTransformBuilderIF builder) {
        super(name, authority, TransformType.Vertical);
        this.type = type;
        this.builder = builder;
    }

    public VerticalCT(VerticalCT from) {
        super(from.getName(), from.getAuthority(), from.getTransformType());
        this.type = from.getVerticalTransformType();
        this.builder = from.getBuilder();
    }

    public Type getVerticalTransformType() {
        return this.type;
    }

    public VerticalTransform makeVerticalTransform(NetcdfDataset ds, Dimension timeDim) {
        return this.builder.makeMathTransform(ds, timeDim, this);
    }

    public VertTransformBuilderIF getBuilder() {
        return this.builder;
    }

    @Override
    public String toString() {
        return "VerticalCT {type=" + (Object)((Object)this.type) + ", builder=" + this.builder.getTransformName() + '}';
    }

    public static enum Type {
        HybridSigmaPressure("atmosphere_hybrid_sigma_pressure_coordinate"),
        HybridHeight("atmosphere_hybrid_height_coordinate"),
        LnPressure("atmosphere_ln_pressure_coordinate"),
        OceanSigma("ocean_sigma_coordinate"),
        OceanS("ocean_s_coordinate"),
        Sleve("atmosphere_sleve_coordinate"),
        Sigma("atmosphere_sigma_coordinate"),
        OceanSG1("ocean_s_g1"),
        OceanSG2("ocean_s_g2"),
        Existing3DField("atmosphere_sigma"),
        WRFEta("WRFEta");

        private final String name;

        private Type(String s) {
            this.name = s;
        }

        public static Type getType(String name) {
            for (Type t : Type.values()) {
                if (!t.name.equalsIgnoreCase(name)) continue;
                return t;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

