/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.StringLocker;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.nc2.iosp.netcdf3.SPFactory;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.IO;
import ucar.nc2.util.Indent;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.rc.RC;
import ucar.unidata.io.InMemoryRandomAccessFile;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.http.HTTPRandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class NetcdfFile
implements FileCacheable,
Closeable {
    public static final String IOSP_MESSAGE_ADD_RECORD_STRUCTURE = "AddRecordStructure";
    public static final String IOSP_MESSAGE_CONVERT_RECORD_STRUCTURE = "ConvertRecordStructure";
    public static final String IOSP_MESSAGE_REMOVE_RECORD_STRUCTURE = "RemoveRecordStructure";
    public static final String IOSP_MESSAGE_RANDOM_ACCESS_FILE = "RandomAccessFile";
    private static Logger log;
    private static int default_buffersize;
    private static List<IOServiceProvider> registeredProviders;
    protected static boolean debugSPI;
    protected static boolean debugCompress;
    protected static boolean showRequest;
    static boolean debugStructureIterator;
    static boolean loadWarnings;
    private static boolean userLoads;
    private static StringLocker stringLocker;
    protected String location;
    protected String id;
    protected String title;
    protected String cacheName;
    protected Group rootGroup = this.makeRootGroup();
    private boolean immutable;
    protected FileCacheIF cache;
    protected IOServiceProvider spi;
    protected List<Variable> variables;
    protected List<Dimension> dimensions;
    protected List<Attribute> gattributes;
    public static final String reservedFullName = ".\\";
    public static final String reservedSectionSpec = "();,.\\";
    public static final String reservedCdl = "[ !\"#$%&'()*,:;<=>?[]^`{|}~\\";

    public static void registerIOProvider(String className) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> ioClass = NetcdfFile.class.getClassLoader().loadClass(className);
        NetcdfFile.registerIOProvider(ioClass);
    }

    public static void registerIOProvider(Class iospClass) throws IllegalAccessException, InstantiationException {
        NetcdfFile.registerIOProvider(iospClass, false);
    }

    public static void registerIOProvider(Class iospClass, boolean last) throws IllegalAccessException, InstantiationException {
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        if (userLoads && !last) {
            registeredProviders.add(0, spi);
        } else {
            registeredProviders.add(spi);
        }
    }

    public static void registerIOProviderPreferred(Class iospClass, Class target) throws IllegalAccessException, InstantiationException {
        NetcdfFile.iospDeRegister(iospClass);
        int pos = -1;
        for (int i = 0; i < registeredProviders.size(); ++i) {
            IOServiceProvider candidate = registeredProviders.get(i);
            if (candidate.getClass() != target) continue;
            if (pos >= i) break;
            pos = i;
            break;
        }
        if (pos < 0) {
            pos = 0;
        }
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        registeredProviders.add(pos, spi);
    }

    public static boolean iospRegistered(Class iospClass) {
        for (IOServiceProvider spi : registeredProviders) {
            if (spi.getClass() != iospClass) continue;
            return true;
        }
        return false;
    }

    public static boolean iospDeRegister(Class iospClass) {
        for (int i = 0; i < registeredProviders.size(); ++i) {
            IOServiceProvider spi = registeredProviders.get(i);
            if (spi.getClass() != iospClass) continue;
            registeredProviders.remove(i);
            return true;
        }
        return false;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugSPI = debugFlag.isSet("NetcdfFile/debugSPI");
        debugCompress = debugFlag.isSet("NetcdfFile/debugCompress");
        debugStructureIterator = debugFlag.isSet("NetcdfFile/structureIterator");
        N3header.disallowFileTruncation = debugFlag.isSet("NetcdfFile/disallowFileTruncation");
        N3header.debugHeaderSize = debugFlag.isSet("NetcdfFile/debugHeaderSize");
        showRequest = debugFlag.isSet("NetcdfFile/showRequest");
    }

    public static void setProperty(String name, String value) {
        N3iosp.setProperty(name, value);
    }

    public static NetcdfFile open(String location) throws IOException {
        return NetcdfFile.open(location, null);
    }

    public static NetcdfFile open(String location, CancelTask cancelTask) throws IOException {
        return NetcdfFile.open(location, -1, cancelTask);
    }

    public static NetcdfFile open(String location, int buffer_size, CancelTask cancelTask) throws IOException {
        return NetcdfFile.open(location, buffer_size, cancelTask, null);
    }

    public static NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        RandomAccessFile raf = NetcdfFile.getRaf(location, buffer_size);
        try {
            return NetcdfFile.open(raf, location, cancelTask, iospMessage);
        }
        catch (Throwable t) {
            raf.close();
            throw new IOException(t);
        }
    }

    public static boolean canOpen(String location) throws IOException {
        try (RandomAccessFile raf = NetcdfFile.getRaf(location, -1);){
            boolean bl = raf != null && NetcdfFile.canOpen(raf);
            return bl;
        }
    }

    private static boolean canOpen(RandomAccessFile raf) throws IOException {
        if (N3header.isValidFile(raf)) {
            return true;
        }
        for (IOServiceProvider iosp : ServiceLoader.load(IOServiceProvider.class)) {
            log.info("ServiceLoader IOServiceProvider {}", (Object)iosp.getClass().getName());
            System.out.printf("ServiceLoader IOServiceProvider found %s%n", iosp.getClass().getName());
            if (!iosp.isValidFile(raf)) continue;
            return true;
        }
        for (IOServiceProvider registeredSpi : registeredProviders) {
            if (!registeredSpi.isValidFile(raf)) continue;
            return true;
        }
        return false;
    }

    public static NetcdfFile open(String location, String iospClassName, int bufferSize, CancelTask cancelTask, Object iospMessage) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        Class<?> iospClass = NetcdfFile.class.getClassLoader().loadClass(iospClassName);
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        if (bufferSize <= 0) {
            bufferSize = default_buffersize;
        }
        RandomAccessFile raf = RandomAccessFile.acquire(NetcdfFile.canonicalizeUriString(location), bufferSize);
        NetcdfFile result = new NetcdfFile(spi, raf, location, cancelTask);
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        return result;
    }

    public static String canonicalizeUriString(String location) {
        String uriString = location.trim();
        if (uriString.startsWith("file://")) {
            uriString = uriString.substring(7);
        } else if (uriString.startsWith("file:")) {
            uriString = uriString.substring(5);
        }
        return StringUtil2.replace(uriString, '\\', "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RandomAccessFile getRaf(String location, int buffer_size) throws IOException {
        RandomAccessFile raf;
        String uriString = location.trim();
        if (buffer_size <= 0) {
            buffer_size = default_buffersize;
        }
        if (uriString.startsWith("http:") || uriString.startsWith("https:")) {
            raf = new HTTPRandomAccessFile(uriString);
        } else if (uriString.startsWith("nodods:")) {
            uriString = "http" + uriString.substring(6);
            raf = new HTTPRandomAccessFile(uriString);
        } else if (uriString.startsWith("httpserver:")) {
            uriString = "http" + uriString.substring(10);
            raf = new HTTPRandomAccessFile(uriString);
        } else if (uriString.startsWith("slurp:")) {
            uriString = "http" + uriString.substring(5);
            byte[] contents = IO.readURLContentsToByteArray(uriString);
            raf = new InMemoryRandomAccessFile(uriString, contents);
        } else {
            if ((uriString = StringUtil2.replace(uriString, '\\', "/")).startsWith("file:")) {
                uriString = StringUtil2.unescape(uriString.substring(5));
            }
            String uncompressedFileName = null;
            try {
                stringLocker.control(uriString);
                uncompressedFileName = NetcdfFile.makeUncompressed(uriString);
            }
            catch (Exception e) {
                log.warn("Failed to uncompress {}, err= {}; try as a regular file.", (Object)uriString, (Object)e.getMessage());
            }
            finally {
                stringLocker.release(uriString);
            }
            raf = uncompressedFileName != null ? RandomAccessFile.acquire(uncompressedFileName, buffer_size) : RandomAccessFile.acquire(uriString, buffer_size);
        }
        return raf;
    }

    /*
     * Exception decompiling
     */
    private static String makeUncompressed(String filename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [72[UNCONDITIONALDOLOOP]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static NetcdfFile openInMemory(String name, byte[] data, String iospClassName) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        InMemoryRandomAccessFile raf = new InMemoryRandomAccessFile(name, data);
        Class<?> iospClass = NetcdfFile.class.getClassLoader().loadClass(iospClassName);
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        return new NetcdfFile(spi, raf, name, null);
    }

    public static NetcdfFile openInMemory(String name, byte[] data) throws IOException {
        InMemoryRandomAccessFile raf = new InMemoryRandomAccessFile(name, data);
        return NetcdfFile.open(raf, name, null, null);
    }

    public static NetcdfFile openInMemory(String filename) throws IOException {
        File file = new File(filename);
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));){
            IO.copy(in, bos);
        }
        return NetcdfFile.openInMemory(filename, bos.toByteArray());
    }

    public static NetcdfFile openInMemory(URI uri) throws IOException {
        URL url = uri.toURL();
        byte[] contents = IO.readContentsToByteArray(url.openStream());
        return NetcdfFile.openInMemory(uri.toString(), contents);
    }

    public static NetcdfFile open(RandomAccessFile raf, String location, CancelTask cancelTask, Object iospMessage) throws IOException {
        Class<?> c;
        IOServiceProvider spi = null;
        if (debugSPI) {
            log.info("NetcdfFile try to open = {}", (Object)location);
        }
        for (IOServiceProvider registeredSpi : registeredProviders) {
            if (debugSPI) {
                log.info(" try iosp = {}", (Object)registeredSpi.getClass().getName());
            }
            if (!registeredSpi.isValidFile(raf)) continue;
            c = registeredSpi.getClass();
            try {
                spi = (IOServiceProvider)c.newInstance();
                break;
            }
            catch (InstantiationException e) {
                throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
            }
            catch (IllegalAccessException e) {
                throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
            }
        }
        if (N3header.isValidFile(raf)) {
            spi = SPFactory.getServiceProvider();
        } else if (H5header.isValidFile(raf)) {
            spi = new H5iosp();
        } else {
            for (IOServiceProvider loadedSpi : ServiceLoader.load(IOServiceProvider.class)) {
                if (!loadedSpi.isValidFile(raf)) continue;
                c = loadedSpi.getClass();
                try {
                    spi = (IOServiceProvider)c.newInstance();
                    break;
                }
                catch (InstantiationException e) {
                    throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
                }
                catch (IllegalAccessException e) {
                    throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
                }
            }
        }
        if (spi == null) {
            raf.close();
            throw new IOException("Cant read " + location + ": not a valid CDM file.");
        }
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        if (log.isDebugEnabled()) {
            log.debug("Using IOSP {}", (Object)spi.getClass().getName());
        }
        NetcdfFile result = new NetcdfFile(spi, raf, location, cancelTask);
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        return result;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.cache != null && this.cache.release(this)) {
            return;
        }
        try {
            if (null != this.spi) {
                this.spi.close();
            }
        }
        finally {
            this.spi = null;
        }
    }

    @Override
    public void release() throws IOException {
        if (this.spi != null) {
            this.spi.release();
        }
    }

    @Override
    public void reacquire() throws IOException {
        if (this.spi != null) {
            this.spi.reacquire();
        }
    }

    @Override
    public synchronized void setFileCache(FileCacheIF cache) {
        this.cache = cache;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    protected void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Group getRootGroup() {
        return this.rootGroup;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public Group findGroup(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return this.rootGroup;
        }
        Group g = this.rootGroup;
        StringTokenizer stoke = new StringTokenizer(fullName, "/");
        while (stoke.hasMoreTokens()) {
            String groupName = NetcdfFile.makeNameUnescaped(stoke.nextToken());
            if ((g = g.findGroup(groupName)) != null) continue;
            return null;
        }
        return g;
    }

    public Variable findVariable(Group g, String shortName) {
        if (g == null) {
            return this.findVariable(shortName);
        }
        return g.findVariable(shortName);
    }

    public Variable findVariable(String fullNameEscaped) {
        List<String> snames;
        if (fullNameEscaped == null || fullNameEscaped.isEmpty()) {
            return null;
        }
        Group g = this.rootGroup;
        String vars = fullNameEscaped;
        int pos = fullNameEscaped.lastIndexOf(47);
        if (pos >= 0) {
            String groups = fullNameEscaped.substring(0, pos);
            vars = fullNameEscaped.substring(pos + 1);
            StringTokenizer stoke = new StringTokenizer(groups, "/");
            while (stoke.hasMoreTokens()) {
                String token = NetcdfFile.makeNameUnescaped(stoke.nextToken());
                if ((g = g.findGroup(token)) != null) continue;
                return null;
            }
        }
        if ((snames = EscapeStrings.tokenizeEscapedName(vars)).isEmpty()) {
            return null;
        }
        String varShortName = NetcdfFile.makeNameUnescaped(snames.get(0));
        Variable v = g.findVariable(varShortName);
        if (v == null) {
            return null;
        }
        int memberCount = 1;
        while (memberCount < snames.size()) {
            String name;
            if (!(v instanceof Structure)) {
                return null;
            }
            if ((v = ((Structure)v).findVariable(name = NetcdfFile.makeNameUnescaped(snames.get(memberCount++)))) != null) continue;
            return null;
        }
        return v;
    }

    public Variable findVariableByAttribute(Group g, String attName, String attValue) {
        if (g == null) {
            g = this.getRootGroup();
        }
        for (Variable v : g.getVariables()) {
            for (Attribute att : v.getAttributes()) {
                if (!attName.equals(att.getShortName()) || !attValue.equals(att.getStringValue())) continue;
                return v;
            }
        }
        for (Group nested : g.getGroups()) {
            Variable v = this.findVariableByAttribute(nested, attName, attValue);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public List<Dimension> getDimensions() {
        return this.immutable ? this.dimensions : new ArrayList<Dimension>(this.dimensions);
    }

    public Dimension findDimension(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return null;
        }
        Group group = this.rootGroup;
        String dimShortName = fullName;
        int pos = fullName.lastIndexOf(47);
        if (pos >= 0) {
            String groups = fullName.substring(0, pos);
            dimShortName = fullName.substring(pos + 1);
            StringTokenizer stoke = new StringTokenizer(groups, "/");
            while (stoke.hasMoreTokens()) {
                String token = NetcdfFile.makeNameUnescaped(stoke.nextToken());
                if ((group = group.findGroup(token)) != null) continue;
                return null;
            }
        }
        return group.findDimensionLocal(dimShortName);
    }

    public boolean hasUnlimitedDimension() {
        return this.getUnlimitedDimension() != null;
    }

    public Dimension getUnlimitedDimension() {
        for (Dimension d : this.dimensions) {
            if (!d.isUnlimited()) continue;
            return d;
        }
        return null;
    }

    public List<Attribute> getGlobalAttributes() {
        return this.immutable ? this.gattributes : new ArrayList<Attribute>(this.gattributes);
    }

    public Attribute findGlobalAttribute(String name) {
        for (Attribute a : this.gattributes) {
            if (!name.equals(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    public Attribute findGlobalAttributeIgnoreCase(String name) {
        for (Attribute a : this.gattributes) {
            if (!name.equalsIgnoreCase(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    public Attribute findAttribute(String fullNameEscaped) {
        String varName;
        if (fullNameEscaped == null || fullNameEscaped.isEmpty()) {
            return null;
        }
        int posAtt = fullNameEscaped.indexOf(64);
        if (posAtt < 0 || posAtt >= fullNameEscaped.length() - 1) {
            return null;
        }
        if (posAtt == 0) {
            return this.findGlobalAttribute(fullNameEscaped.substring(1));
        }
        String path = fullNameEscaped.substring(0, posAtt);
        String attName = fullNameEscaped.substring(posAtt + 1);
        Group g = this.rootGroup;
        int pos = path.lastIndexOf(47);
        String string = varName = pos > 0 && pos < path.length() - 1 ? path.substring(pos + 1) : null;
        if (pos >= 0) {
            String groups = path.substring(0, pos);
            StringTokenizer stoke = new StringTokenizer(groups, "/");
            while (stoke.hasMoreTokens()) {
                String token = NetcdfFile.makeNameUnescaped(stoke.nextToken());
                if ((g = g.findGroup(token)) != null) continue;
                return null;
            }
        }
        if (varName == null) {
            return g.findAttribute(attName);
        }
        List<String> snames = EscapeStrings.tokenizeEscapedName(varName);
        if (snames.isEmpty()) {
            return null;
        }
        String varShortName = NetcdfFile.makeNameUnescaped(snames.get(0));
        Variable v = g.findVariable(varShortName);
        if (v == null) {
            return null;
        }
        int memberCount = 1;
        while (memberCount < snames.size()) {
            String name;
            if (!(v instanceof Structure)) {
                return null;
            }
            if ((v = ((Structure)v).findVariable(name = NetcdfFile.makeNameUnescaped(snames.get(memberCount++)))) != null) continue;
            return null;
        }
        return v.findAttribute(attName);
    }

    public String findAttValueIgnoreCase(Variable v, String attName, String defaultValue) {
        String attValue = null;
        Attribute att = v == null ? this.rootGroup.findAttributeIgnoreCase(attName) : v.findAttributeIgnoreCase(attName);
        if (att != null && att.isString()) {
            attValue = att.getStringValue();
        }
        if (null == attValue) {
            attValue = defaultValue;
        }
        return attValue;
    }

    public double readAttributeDouble(Variable v, String attName, double defValue) {
        Attribute att = v == null ? this.rootGroup.findAttributeIgnoreCase(attName) : v.findAttributeIgnoreCase(attName);
        if (att == null) {
            return defValue;
        }
        if (att.isString()) {
            return Double.parseDouble(att.getStringValue());
        }
        return att.getNumericValue().doubleValue();
    }

    public int readAttributeInteger(Variable v, String attName, int defValue) {
        Attribute att = v == null ? this.rootGroup.findAttributeIgnoreCase(attName) : v.findAttributeIgnoreCase(attName);
        if (att == null) {
            return defValue;
        }
        if (att.isString()) {
            return Integer.parseInt(att.getStringValue());
        }
        return att.getNumericValue().intValue();
    }

    public String toString() {
        Formatter f = new Formatter();
        this.writeCDL(f, new Indent(2), false);
        return f.toString();
    }

    public String toNcML(String url) {
        NcMLWriter ncmlWriter = new NcMLWriter();
        ncmlWriter.setWriteVariablesPredicate(NcMLWriter.writeNoVariablesPredicate);
        Element netcdfElement = ncmlWriter.makeNetcdfElement(this, url);
        return ncmlWriter.writeToString(netcdfElement);
    }

    public void writeCDL(OutputStream out, boolean strict) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.toStringStart(pw, strict);
        this.toStringEnd(pw);
        pw.flush();
    }

    public void writeCDL(PrintWriter pw, boolean strict) {
        this.toStringStart(pw, strict);
        this.toStringEnd(pw);
        pw.flush();
    }

    public void toStringStart(PrintWriter pw, boolean strict) {
        Formatter f = new Formatter();
        this.toStringStart(f, new Indent(2), strict);
        pw.write(f.toString());
    }

    public void toStringEnd(PrintWriter pw) {
        pw.print("}\n");
    }

    protected void writeCDL(Formatter f, Indent indent, boolean strict) {
        this.toStringStart(f, indent, strict);
        f.format("%s}%n", indent);
    }

    protected void toStringStart(Formatter f, Indent indent, boolean strict) {
        String name = this.getLocation();
        if (strict) {
            if (name.endsWith(".nc")) {
                name = name.substring(0, name.length() - 3);
            }
            if (name.endsWith(".cdl")) {
                name = name.substring(0, name.length() - 4);
            }
            name = NetcdfFile.makeValidCDLName(name);
        }
        f.format("%snetcdf %s {%n", indent, name);
        indent.incr();
        this.rootGroup.writeCDL(f, indent, strict);
        indent.decr();
    }

    public void writeNcML(OutputStream os, String uri) throws IOException {
        NcMLWriter ncmlWriter = new NcMLWriter();
        Element netcdfElem = ncmlWriter.makeNetcdfElement(this, uri);
        ncmlWriter.writeToStream(netcdfElem, os);
    }

    public void writeNcML(Writer writer, String uri) throws IOException {
        NcMLWriter ncmlWriter = new NcMLWriter();
        Element netcdfElem = ncmlWriter.makeNetcdfElement(this, uri);
        ncmlWriter.writeToWriter(netcdfElem, writer);
    }

    public boolean syncExtend() throws IOException {
        return this.spi != null && this.spi.syncExtend();
    }

    @Override
    public long getLastModified() {
        if (this.spi != null && this.spi instanceof AbstractIOServiceProvider) {
            AbstractIOServiceProvider aspi = (AbstractIOServiceProvider)this.spi;
            return aspi.getLastModified();
        }
        return 0L;
    }

    public NetcdfFile(String filename) throws IOException {
        this.location = filename;
        RandomAccessFile raf = RandomAccessFile.acquire(filename);
        this.spi = SPFactory.getServiceProvider();
        this.spi.open(raf, this, null);
        this.finish();
    }

    public NetcdfFile(URL url) throws IOException {
        this.location = url.toString();
        HTTPRandomAccessFile raf = new HTTPRandomAccessFile(this.location);
        this.spi = SPFactory.getServiceProvider();
        this.spi.open(raf, this, null);
        this.finish();
    }

    protected NetcdfFile(String iospClassName, Object iospParam, String location, int buffer_size, CancelTask cancelTask) throws IOException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> iospClass = this.getClass().getClassLoader().loadClass(iospClassName);
        this.spi = (IOServiceProvider)iospClass.newInstance();
        if (debugSPI) {
            log.info("NetcdfFile uses iosp = {}", (Object)this.spi.getClass().getName());
        }
        if (iospParam != null) {
            this.spi.sendIospMessage(iospParam);
        }
        this.location = location;
        RandomAccessFile raf = NetcdfFile.getRaf(location, buffer_size);
        try {
            this.spi.open(raf, this, cancelTask);
            this.finish();
        }
        catch (IOException | RuntimeException e) {
            try {
                this.spi.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.spi = null;
            throw e;
        }
        catch (Throwable t) {
            try {
                this.spi.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.spi = null;
            throw new RuntimeException(t);
        }
        if (this.id == null) {
            this.setId(this.findAttValueIgnoreCase(null, "_Id", null));
        }
        if (this.title == null) {
            this.setTitle(this.findAttValueIgnoreCase(null, "_Title", null));
        }
    }

    protected NetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
        this.spi = spi;
        this.location = location;
        if (debugSPI) {
            log.info("NetcdfFile uses iosp = {}", (Object)spi.getClass().getName());
        }
        try {
            spi.open(raf, this, cancelTask);
        }
        catch (IOException | RuntimeException e) {
            try {
                spi.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.spi = null;
            throw e;
        }
        catch (Throwable t) {
            try {
                spi.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.spi = null;
            throw new RuntimeException(t);
        }
        if (this.id == null) {
            this.setId(this.findAttValueIgnoreCase(null, "_Id", null));
        }
        if (this.title == null) {
            this.setTitle(this.findAttValueIgnoreCase(null, "_Title", null));
        }
        this.finish();
    }

    protected NetcdfFile(IOServiceProvider spi, String location) {
        this.spi = spi;
        this.location = location;
    }

    protected NetcdfFile() {
    }

    protected NetcdfFile(NetcdfFile ncfile) {
        this.location = ncfile.getLocation();
        this.id = ncfile.getId();
        this.title = ncfile.getTitle();
        this.spi = ncfile.spi;
    }

    public Attribute addAttribute(Group parent, Attribute att) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        parent.addAttribute(att);
        return att;
    }

    public Attribute addAttribute(Group parent, String name, String value) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (value == null) {
            return null;
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        Attribute att = new Attribute(name, value);
        parent.addAttribute(att);
        return att;
    }

    public Group addGroup(Group parent, Group g) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        parent.addGroup(g);
        return g;
    }

    public Dimension addDimension(Group parent, Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        parent.addDimension(d);
        return d;
    }

    public boolean removeDimension(Group g, String dimName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g == null) {
            g = this.rootGroup;
        }
        return g.removeDimension(dimName);
    }

    public Variable addVariable(Group g, Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g == null) {
            g = this.rootGroup;
        }
        if (v != null) {
            g.addVariable(v);
        }
        return v;
    }

    public Variable addVariable(Group g, String shortName, DataType dtype, String dims) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g == null) {
            g = this.rootGroup;
        }
        Variable v = new Variable(this, g, null, shortName);
        v.setDataType(dtype);
        v.setDimensions(dims);
        g.addVariable(v);
        return v;
    }

    public Variable addStringVariable(Group g, String shortName, String dims, int strlen) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g == null) {
            g = this.rootGroup;
        }
        String dimName = shortName + "_strlen";
        this.addDimension(g, new Dimension(dimName, strlen));
        Variable v = new Variable(this, g, null, shortName);
        v.setDataType(DataType.CHAR);
        v.setDimensions(dims + " " + dimName);
        g.addVariable(v);
        return v;
    }

    public boolean removeVariable(Group g, String varName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g == null) {
            g = this.rootGroup;
        }
        return g.removeVariable(varName);
    }

    public Attribute addVariableAttribute(Variable v, Attribute att) {
        return v.addAttribute(att);
    }

    public Object sendIospMessage(Object message) {
        if (null == message) {
            return null;
        }
        if (message == IOSP_MESSAGE_ADD_RECORD_STRUCTURE) {
            Variable v = this.rootGroup.findVariable("record");
            boolean gotit = v instanceof Structure;
            return gotit || this.makeRecordStructure() != false;
        }
        if (message == IOSP_MESSAGE_REMOVE_RECORD_STRUCTURE) {
            Variable v = this.rootGroup.findVariable("record");
            boolean gotit = v instanceof Structure;
            if (gotit) {
                this.rootGroup.remove(v);
                this.variables.remove(v);
                this.removeRecordStructure();
            }
            return gotit;
        }
        if (this.spi != null) {
            return this.spi.sendIospMessage(message);
        }
        return null;
    }

    protected Boolean makeRecordStructure() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        Boolean didit = false;
        if (this.spi != null && this.spi instanceof N3iosp && this.hasUnlimitedDimension()) {
            didit = (Boolean)this.spi.sendIospMessage(IOSP_MESSAGE_ADD_RECORD_STRUCTURE);
        }
        return didit;
    }

    protected Boolean removeRecordStructure() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        Boolean didit = false;
        if (this.spi != null && this.spi instanceof N3iosp) {
            didit = (Boolean)this.spi.sendIospMessage(IOSP_MESSAGE_REMOVE_RECORD_STRUCTURE);
        }
        return didit;
    }

    public void setId(String id) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.id = id;
    }

    public void setTitle(String title) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.title = title;
    }

    public void setLocation(String location) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.location = location;
    }

    public NetcdfFile setImmutable() {
        if (this.immutable) {
            return this;
        }
        this.immutable = true;
        this.setImmutable(this.rootGroup);
        this.variables = Collections.unmodifiableList(this.variables);
        this.dimensions = Collections.unmodifiableList(this.dimensions);
        this.gattributes = Collections.unmodifiableList(this.gattributes);
        return this;
    }

    private void setImmutable(Group g) {
        for (Variable v : g.variables) {
            v.setImmutable();
        }
        for (Dimension d : g.dimensions) {
            d.setImmutable();
        }
        for (Group nested : g.getGroups()) {
            this.setImmutable(nested);
        }
        g.setImmutable();
    }

    public void empty() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.variables = new ArrayList<Variable>();
        this.gattributes = new ArrayList<Attribute>();
        this.dimensions = new ArrayList<Dimension>();
        this.rootGroup = this.makeRootGroup();
    }

    protected Group makeRootGroup() {
        Group root = new Group(this, null, "");
        this.rootGroup = null;
        root.setParentGroup(null);
        return root;
    }

    public void finish() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.variables = new ArrayList<Variable>();
        this.dimensions = new ArrayList<Dimension>();
        this.gattributes = new ArrayList<Attribute>();
        this.finishGroup(this.rootGroup);
    }

    private void finishGroup(Group g) {
        String newName;
        this.variables.addAll(g.variables);
        for (Attribute oldAtt : g.getAttributes()) {
            if (g == this.rootGroup) {
                this.gattributes.add(oldAtt);
                continue;
            }
            newName = this.makeFullNameWithString(g, oldAtt.getShortName());
            this.gattributes.add(new Attribute(newName, oldAtt));
        }
        for (Dimension oldDim : g.dimensions) {
            if (!oldDim.isShared()) continue;
            if (g == this.rootGroup) {
                this.dimensions.add(oldDim);
                continue;
            }
            newName = this.makeFullNameWithString(g, oldDim.getShortName());
            this.dimensions.add(new Dimension(newName, oldDim));
        }
        List<Group> groups = g.getGroups();
        for (Group nested : groups) {
            this.finishGroup(nested);
        }
    }

    protected Array readData(Variable v, Section ranges) throws IOException, InvalidRangeException {
        long start = 0L;
        if (showRequest) {
            log.info("Data request for variable: {} section {}...", (Object)v.getFullName(), (Object)ranges);
            start = System.currentTimeMillis();
        }
        if (this.spi == null) {
            throw new IOException("spi is null, perhaps file has been closed. Trying to read variable " + v.getFullName());
        }
        Array result = this.spi.readData(v, ranges);
        if (showRequest) {
            long took = System.currentTimeMillis() - start;
            log.info(" ...took= {} msecs", (Object)took);
        }
        return result;
    }

    public Array readSection(String variableSection) throws IOException, InvalidRangeException {
        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection(this, variableSection);
        if (cer.child == null) {
            return cer.v.read(cer.section);
        }
        if (this.spi == null) {
            return IospHelper.readSection(cer);
        }
        return this.spi.readSection(cer);
    }

    protected long readToByteChannel(Variable v, Section section, WritableByteChannel wbc) throws IOException, InvalidRangeException {
        if (this.spi == null || v.hasCachedData()) {
            return IospHelper.copyToByteChannel(v.read(section), wbc);
        }
        return this.spi.readToByteChannel(v, section, wbc);
    }

    protected long readToOutputStream(Variable v, Section section, OutputStream out) throws IOException, InvalidRangeException {
        if (this.spi == null || v.hasCachedData()) {
            return IospHelper.copyToOutputStream(v.read(section), out);
        }
        return this.spi.readToOutputStream(v, section, out);
    }

    protected StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        return this.spi.getStructureIterator(s, bufferSize);
    }

    public List<Array> readArrays(List<Variable> variables) throws IOException {
        ArrayList<Array> result = new ArrayList<Array>();
        for (Variable variable : variables) {
            result.add(variable.read());
        }
        return result;
    }

    public Array read(String variableSection, boolean flatten) throws IOException, InvalidRangeException {
        if (!flatten) {
            throw new UnsupportedOperationException("NetdfFile.read(String variableSection, boolean flatten=false)");
        }
        return this.readSection(variableSection);
    }

    protected String toStringDebug(Object o) {
        return this.spi == null ? "" : this.spi.toStringDebug(o);
    }

    public String getDetailInfo() {
        Formatter f = new Formatter();
        this.getDetailInfo(f);
        return f.toString();
    }

    public void getDetailInfo(Formatter f) {
        f.format("NetcdfFile location= %s%n", this.getLocation());
        f.format("  title= %s%n", this.getTitle());
        f.format("  id= %s%n", this.getId());
        f.format("  fileType= %s%n", this.getFileTypeId());
        f.format("  fileDesc= %s%n", this.getFileTypeDescription());
        f.format("  fileVersion= %s%n", this.getFileTypeVersion());
        f.format("  class= %s%n", this.getClass().getName());
        if (this.spi == null) {
            f.format("  has no IOSP%n", new Object[0]);
        } else {
            f.format("  iosp= %s%n%n", this.spi.getClass());
            f.format("%s", this.spi.getDetailInfo());
        }
        this.showCached(f);
        this.showProxies(f);
    }

    protected void showCached(Formatter f) {
        int maxNameLen = 8;
        for (Variable v : this.getVariables()) {
            maxNameLen = Math.max(maxNameLen, v.getShortName().length());
        }
        long total = 0L;
        long totalCached = 0L;
        f.format("%n%-" + maxNameLen + "s isCaching  size     cachedSize (bytes) %n", "Variable");
        for (Variable v : this.getVariables()) {
            long vtotal = v.getSize() * (long)v.getElementSize();
            total += vtotal;
            f.format(" %-" + maxNameLen + "s %5s %8d ", v.getShortName(), v.isCaching(), vtotal);
            if (v.hasCachedData()) {
                Array data;
                try {
                    data = v.read();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                long size = data.getSizeBytes();
                f.format(" %8d", size);
                totalCached += size;
            }
            f.format("%n", new Object[0]);
        }
        f.format(" %" + maxNameLen + "s                  --------%n", " ");
        f.format(" %" + maxNameLen + "s total %8d Mb cached= %8d Kb%n", " ", total / 1000L / 1000L, totalCached / 1000L);
    }

    protected void showProxies(Formatter f) {
        int maxNameLen = 8;
        boolean hasProxy = false;
        for (Variable v : this.getVariables()) {
            if (v.proxyReader != v) {
                hasProxy = true;
            }
            maxNameLen = Math.max(maxNameLen, v.getShortName().length());
        }
        if (!hasProxy) {
            return;
        }
        f.format("%n%-" + maxNameLen + "s  proxyReader   Variable.Class %n", "Variable");
        for (Variable v : this.getVariables()) {
            if (v.proxyReader == v) continue;
            f.format(" %-" + maxNameLen + "s  %s %s%n", v.getShortName(), v.proxyReader.getClass().getName(), v.getClass().getName());
        }
        f.format("%n", new Object[0]);
    }

    public IOServiceProvider getIosp() {
        return this.spi;
    }

    @Nonnull
    public String getFileTypeId() {
        if (this.spi != null) {
            return this.spi.getFileTypeId();
        }
        return "N/A";
    }

    public String getFileTypeDescription() {
        if (this.spi != null) {
            return this.spi.getFileTypeDescription();
        }
        return "N/A";
    }

    public String getFileTypeVersion() {
        if (this.spi != null) {
            return this.spi.getFileTypeVersion();
        }
        return "N/A";
    }

    public static String makeValidCdmObjectName(String shortName) {
        if (shortName == null) {
            return null;
        }
        return StringUtil2.makeValidCdmObjectName(shortName);
    }

    public static String makeValidCDLName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedCdl);
    }

    public static String makeValidPathName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedFullName);
    }

    public static String makeValidSectionSpecName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedSectionSpec);
    }

    public static String makeNameUnescaped(String vname) {
        return EscapeStrings.backslashUnescape(vname);
    }

    protected static String makeFullName(CDMNode v) {
        return NetcdfFile.makeFullName(v, reservedFullName);
    }

    protected static String makeFullNameSectionSpec(CDMNode v) {
        return NetcdfFile.makeFullName(v, reservedSectionSpec);
    }

    protected static String makeFullName(CDMNode node, String reservedChars) {
        Group parent = node.getParentGroup();
        if ((parent == null || parent.isRoot()) && !node.isMemberOfStructure()) {
            return EscapeStrings.backslashEscape(node.getShortName(), reservedChars);
        }
        StringBuilder sbuff = new StringBuilder();
        NetcdfFile.appendGroupName(sbuff, parent, reservedChars);
        NetcdfFile.appendStructureName(sbuff, node, reservedChars);
        return sbuff.toString();
    }

    private static void appendGroupName(StringBuilder sbuff, Group g, String reserved) {
        if (g == null) {
            return;
        }
        if (g.getParentGroup() == null) {
            return;
        }
        NetcdfFile.appendGroupName(sbuff, g.getParentGroup(), reserved);
        sbuff.append(EscapeStrings.backslashEscape(g.getShortName(), reserved));
        sbuff.append("/");
    }

    private static void appendStructureName(StringBuilder sbuff, CDMNode n, String reserved) {
        if (n.isMemberOfStructure()) {
            NetcdfFile.appendStructureName(sbuff, n.getParentStructure(), reserved);
            sbuff.append(".");
        }
        sbuff.append(EscapeStrings.backslashEscape(n.getShortName(), reserved));
    }

    protected String makeFullNameWithString(Group parent, String name) {
        name = NetcdfFile.makeValidPathName(name);
        StringBuilder sbuff = new StringBuilder();
        NetcdfFile.appendGroupName(sbuff, parent, null);
        sbuff.append(name);
        return sbuff.toString();
    }

    static {
        block5: {
            block4: {
                log = LoggerFactory.getLogger(NetcdfFile.class);
                default_buffersize = 8092;
                registeredProviders = new ArrayList<IOServiceProvider>();
                stringLocker = new StringLocker();
                RC.initialize();
                try {
                    NetcdfFile.registerIOProvider("ucar.nc2.stream.NcStreamIosp");
                }
                catch (Throwable e) {
                    if (!loadWarnings) break block4;
                    log.info("Cant load class NcStreamIosp", e);
                }
            }
            try {
                NetcdfFile.registerIOProvider("ucar.nc2.iosp.hdf4.H4iosp");
            }
            catch (Throwable e) {
                if (!loadWarnings) break block5;
                log.info("Cant load class H4iosp", e);
            }
        }
        userLoads = true;
    }
}

