/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;

public class NcepMnemonic {
    private static final Pattern fields3 = Pattern.compile((String)"^\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s*\\|");
    private static final Pattern fields2 = Pattern.compile((String)"^\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|");
    private static final Pattern fields5 = Pattern.compile((String)"^\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|");
    private static final Pattern ints6 = Pattern.compile((String)"^\\d{6}");
    private static final int XlocalCutoff = 48;
    private static final int YlocalCutoff = 192;
    private static final boolean debugTable = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean read(InputStream ios, BufrTables.Tables tables) throws IOException {
        if (ios == null) {
            return false;
        }
        if (tables.b == null) {
            tables.b = new TableB("fake", "fake");
        }
        if (tables.d == null) {
            tables.d = new TableD("fake", "fake");
        }
        HashMap<String, String> number = new HashMap<String, String>();
        HashMap<String, String> desc = new HashMap<String, String>();
        HashMap<String, String> mnseq = new HashMap<String, String>();
        try {
            String string;
            String fxy;
            Matcher m;
            Object line;
            String line2;
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, StandardCharsets.UTF_8));
            do {
                if ((line2 = dataIS.readLine()) != null) continue;
                throw new RuntimeException("Bad NCEP mnemonic BUFR table ");
            } while (!line2.contains("MNEMONIC"));
            while ((line = dataIS.readLine()) != null && !((String)line).contains("MNEMONIC")) {
                if (((String)line).contains("----") || ((String)line).startsWith("*") || ((String)line).startsWith("|       ") || !(m = fields3.matcher((CharSequence)line)).find()) continue;
                String string2 = m.group(1).trim();
                fxy = m.group(2).trim();
                if (fxy.startsWith("3")) {
                    number.put(string2, fxy);
                    desc.put(string2, m.group(3).replace("TABLE D ENTRY - ", "").trim());
                    continue;
                }
                if (fxy.startsWith("0")) {
                    number.put(string2, fxy);
                    desc.put(string2, m.group(3).replace("TABLE B ENTRY - ", "").trim());
                    continue;
                }
                if (!fxy.startsWith("A")) continue;
                number.put(string2, fxy);
                desc.put(string2, m.group(3).replace("TABLE A ENTRY - ", "").trim());
            }
            while ((line = dataIS.readLine()) != null && !((String)line).contains("MNEMONIC")) {
                if (((String)line).contains("----") || ((String)line).startsWith("|       ") || ((String)line).startsWith("*") || !(m = fields2.matcher((CharSequence)line)).find()) continue;
                String string3 = m.group(1).trim();
                if (mnseq.containsKey(string3)) {
                    String value = (String)mnseq.get(string3);
                    value = value + " " + m.group(2);
                    mnseq.put(string3, value);
                    continue;
                }
                mnseq.put(string3, m.group(2));
            }
            for (Map.Entry entry : mnseq.entrySet()) {
                String seq = (String)entry.getValue();
                seq = seq.replaceAll("\\<", "1-1-0 0-31-0 ");
                seq = seq.replaceAll("\\>", "");
                seq = seq.replaceAll("\\{", "1-1-0 0-31-1 ");
                seq = seq.replaceAll("\\}", "");
                seq = seq.replaceAll("\\(", "1-1-0 0-31-2 ");
                seq = seq.replaceAll("\\)", "");
                StringTokenizer stoke = new StringTokenizer(seq, " ");
                ArrayList<Short> list = new ArrayList<Short>();
                while (stoke.hasMoreTokens()) {
                    String mn = stoke.nextToken();
                    if (mn.charAt(1) == '-') {
                        list.add(Descriptor.getFxy(mn));
                        continue;
                    }
                    m = ints6.matcher((CharSequence)mn);
                    if (m.find()) {
                        String F = mn.substring(0, 1);
                        String X = NcepMnemonic.removeLeading0(mn.substring(1, 3));
                        String Y = NcepMnemonic.removeLeading0(mn.substring(3));
                        list.add(Descriptor.getFxy(F + "-" + X + "-" + Y));
                        continue;
                    }
                    if (mn.startsWith("\"")) {
                        int idx = mn.lastIndexOf(34);
                        String count = mn.substring(idx + 1);
                        list.add(Descriptor.getFxy("1-1-" + count));
                        mn = mn.substring(1, idx);
                    }
                    if (mn.startsWith(".")) {
                        String des = mn.substring(mn.length() - 4);
                        mn = mn.replace(des, "....");
                    }
                    String fxy2 = (String)number.get(mn);
                    String F = fxy2.substring(0, 1);
                    String X = NcepMnemonic.removeLeading0(fxy2.substring(1, 3));
                    String Y = NcepMnemonic.removeLeading0(fxy2.substring(3));
                    list.add(Descriptor.getFxy(F + "-" + X + "-" + Y));
                }
                String fxy3 = (String)number.get(entry.getKey());
                String X = NcepMnemonic.removeLeading0(fxy3.substring(1, 3));
                String Y = NcepMnemonic.removeLeading0(fxy3.substring(3));
                if (48 > Integer.parseInt(X) && 192 > Integer.parseInt(Y)) continue;
                short seqX = Short.parseShort(X.trim());
                short seqY = Short.parseShort(Y.trim());
                tables.d.addDescriptor(seqX, seqY, (String)entry.getKey(), list);
            }
            ArrayList<Short> list = new ArrayList<Short>();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-2"));
            tables.d.addDescriptor((short)60, (short)1, "", list);
            list = new ArrayList();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-1"));
            tables.d.addDescriptor((short)60, (short)2, "", list);
            list = new ArrayList();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-1"));
            tables.d.addDescriptor((short)60, (short)3, "", list);
            list = new ArrayList();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-0"));
            tables.d.addDescriptor((short)60, (short)4, "", list);
            while ((string = dataIS.readLine()) != null) {
                if (string.contains("MNEMONIC")) {
                    break;
                }
                if (string.startsWith("|       ") || string.startsWith("*") || !(m = fields5.matcher((CharSequence)string)).find() || m.group(1).equals("") || !number.containsKey(m.group(1).trim())) continue;
                fxy = (String)number.get(m.group(1).trim());
                String X = fxy.substring(1, 3);
                String Y = fxy.substring(3);
                String mnu2 = m.group(1).trim();
                String descr = (String)desc.get(mnu2);
                short x = Short.parseShort(X.trim());
                short y = Short.parseShort(Y.trim());
                if (48 > x && 192 > y) continue;
                int scale = Integer.parseInt(m.group(2).trim());
                int refVal = Integer.parseInt(m.group(3).trim());
                int width = Integer.parseInt(m.group(4).trim());
                String units = m.group(5).trim();
                tables.b.addDescriptor(x, y, scale, refVal, width, mnu2, units, descr);
            }
        }
        finally {
            ios.close();
        }
        tables.b.addDescriptor((short)63, (short)0, 0, 0, 16, "Byte count", "Numeric", null);
        return true;
    }

    private static String removeLeading0(String number) {
        if (number.length() == 2 && number.startsWith("0")) {
            number = number.substring(1);
        } else if (number.length() == 3 && number.startsWith("00")) {
            number = number.substring(2);
        } else if (number.length() == 3 && number.startsWith("0")) {
            number = number.substring(1);
        }
        return number;
    }
}

