/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.NcepTable;
import ucar.nc2.iosp.bufr.tables.TableA;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.nc2.wmo.CommonCodeTable;

public class BufrTableLookup {
    private int center;
    private int subCenter;
    private int masterId;
    private int masterVersion;
    private int localVersion;
    private int bufrEdition;
    private int category;
    private int subCategory;
    private int localSubCategory;
    private TableLookup tlookup;

    public static BufrTableLookup factory(Message m) throws IOException {
        return new BufrTableLookup(m.is.getBufrEdition(), m.ids.getCenterId(), m.ids.getSubCenterId(), m.ids.getMasterTableId(), m.ids.getMasterTableVersion(), m.ids.getLocalTableVersion(), m.ids.getCategory(), m.ids.getSubCategory(), m.ids.getLocalSubCategory());
    }

    private BufrTableLookup(int bufrEdition, int center, int subCenter, int masterId, int masterVersion, int localVersion, int category, int subCategory, int localSubCategory) throws IOException {
        this.bufrEdition = bufrEdition;
        this.center = center;
        this.subCenter = subCenter;
        this.masterId = masterId;
        this.masterVersion = masterVersion;
        this.localVersion = localVersion;
        this.category = category;
        this.subCategory = subCategory;
        this.localSubCategory = localSubCategory;
        this.tlookup = new TableLookup(center, subCenter, masterVersion, localVersion, category);
    }

    public int getBufrEdition() {
        return this.bufrEdition;
    }

    public int getCenter() {
        return this.center;
    }

    public int getSubCenter() {
        return this.subCenter;
    }

    public int getMasterTableId() {
        return this.masterId;
    }

    public int getMasterTableVersion() {
        return this.masterVersion;
    }

    public int getLocalTableVersion() {
        return this.localVersion;
    }

    public int getCategory() {
        return this.category;
    }

    public int getSubCategory() {
        return this.subCategory;
    }

    public int getLocalSubCategory() {
        return this.localSubCategory;
    }

    public String getCenterName() {
        String name = CommonCodeTable.getCenterNameBufr((int)this.getCenter(), (int)this.getBufrEdition());
        String subname = CommonCodeTable.getSubCenterName((int)this.getCenter(), (int)this.getSubCenter());
        if (subname != null) {
            name = name + " / " + subname;
        }
        return this.getCenter() + "." + this.getSubCenter() + " (" + name + ")";
    }

    public String getCenterNo() {
        return this.getCenter() + "." + this.getSubCenter();
    }

    public String getTableName() {
        return this.getMasterTableId() + "." + this.getMasterTableVersion() + "." + this.getLocalTableVersion();
    }

    public String getCategoryFullName() {
        String catName = this.getCategoryName();
        String subcatName = this.getSubCategoryName();
        if (subcatName != null) {
            return this.getCategoryNo() + "=" + catName + " / " + subcatName;
        }
        return this.getCategoryNo() + "=" + catName;
    }

    public String getSubCategoryName() {
        String subcatName = null;
        if (this.center == 7) {
            subcatName = NcepTable.getDataSubcategory(this.getCategory(), this.getSubCategory());
        }
        if (subcatName == null) {
            subcatName = CommonCodeTable.getDataSubcategoy((int)this.getCategory(), (int)this.getSubCategory());
        }
        return subcatName;
    }

    public String getCategoryName() {
        return TableA.getDataCategory(this.getCategory());
    }

    public String getCategoryNo() {
        String result = this.getCategory() + "." + this.getSubCategory();
        if (this.getLocalSubCategory() >= 0) {
            result = result + "." + this.getLocalSubCategory();
        }
        return result;
    }

    private void init() {
    }

    public void setTableLookup(TableLookup tlookup) {
        this.tlookup = tlookup;
    }

    public TableB.Descriptor getDescriptorTableB(short fxy) {
        return this.tlookup.getDescriptorTableB(fxy);
    }

    public TableD.Descriptor getDescriptorTableD(short fxy) {
        return this.tlookup.getDescriptorTableD(fxy);
    }

    public String getWmoTableBName() {
        return this.tlookup.getWmoTableBName();
    }

    public String getLocalTableBName() {
        return this.tlookup.getLocalTableBName();
    }

    public String getLocalTableDName() {
        return this.tlookup.getLocalTableDName();
    }

    public String getWmoTableDName() {
        return this.tlookup.getWmoTableDName();
    }

    public BufrTables.Mode getMode() {
        return this.tlookup.getMode();
    }

    public void showMissingFields(List<Short> ddsList, Formatter out) throws IOException {
        for (short fxy : ddsList) {
            TableB.Descriptor b;
            int f = (fxy & 0xC000) >> 14;
            if (f == 3) {
                List<Short> sublist = this.getDescriptorListTableD(fxy);
                if (sublist == null) {
                    out.format("%s, ", Descriptor.makeString(fxy));
                    continue;
                }
                this.showMissingFields(sublist, out);
                continue;
            }
            if (f != 0 || (b = this.getDescriptorTableB(fxy)) != null) continue;
            out.format("%s, ", Descriptor.makeString(fxy));
        }
    }

    public List<String> getDescriptorListTableD(String fxy) {
        short id = Descriptor.getFxy(fxy);
        List<Short> seq = this.getDescriptorListTableD(id);
        if (seq == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(seq.size());
        for (Short s : seq) {
            result.add(Descriptor.makeString(s));
        }
        return result;
    }

    public List<Short> getDescriptorListTableD(short id) {
        TableD.Descriptor d = this.getDescriptorTableD(id);
        if (d != null) {
            return d.getSequence();
        }
        return null;
    }
}

