/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ThrowStatement
extends Statement {
    public Expression exception;
    public TypeBinding exceptionType;

    public ThrowStatement(Expression exception, int startPosition) {
        this.exception = exception;
        this.sourceStart = startPosition;
        this.sourceEnd = exception.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.exception.analyseCode(currentScope, flowContext, flowInfo);
        flowContext.checkExceptionHandlers(this.exceptionType, (AstNode)this, flowInfo, currentScope);
        return FlowInfo.DEAD_END;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.exception.generateCode(currentScope, codeStream, true);
        codeStream.athrow();
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void resolve(BlockScope scope) {
        this.exceptionType = this.exception.resolveTypeExpecting(scope, scope.getJavaLangThrowable());
        if (this.exceptionType == BaseTypes.NullBinding && scope.environment().options.complianceLevel <= 2) {
            scope.problemReporter().cannotThrowNull(this);
        }
        this.exception.implicitWidening(this.exceptionType, this.exceptionType);
    }

    public String toString(int tab) {
        String s = AstNode.tabString(tab);
        s = String.valueOf(s) + "throw ";
        s = String.valueOf(s) + this.exception.toStringExpression();
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.exception.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

