/*
 * Decompiled with CFR 0.152.
 */
package io.dotlearn.lrnplayer.loader;

import io.dotlearn.lrnplayer.loader.VideoDb;
import io.dotlearn.lrnplayer.loader.di.Injector;
import io.dotlearn.lrnplayer.loader.download.Downloader;
import io.dotlearn.lrnplayer.loader.model.VideoDataResponse;
import io.dotlearn.lrnplayer.loader.model.VideoMetadata;
import io.dotlearn.lrnplayer.loader.videodata.VideoDataFetcher;
import io.dotlearn.lrnplayer.utils.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ0\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J%\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0016J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/dotlearn/lrnplayer/loader/VideoLoader;", "", "()V", "videoDataFetcher", "Lio/dotlearn/lrnplayer/loader/videodata/VideoDataFetcher;", "videoDownloader", "Lio/dotlearn/lrnplayer/loader/download/Downloader;", "cancel", "", "cancel$lrnplayer_release", "downloadVideo", "accessToken", "", "videoId", "videoData", "Lio/dotlearn/lrnplayer/loader/model/VideoDataResponse;", "key", "callback", "Lio/dotlearn/lrnplayer/loader/VideoLoader$VideoLoadCallback;", "fetchVideoData", "getStuff", "load", "load$lrnplayer_release", "loadVideo", "VideoLoadCallback", "lrnplayer_release"})
public final class VideoLoader {
    private static final VideoDataFetcher a;
    private static final Downloader b;
    public static final VideoLoader INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void load$lrnplayer_release(@NotNull String accessToken, @NotNull String videoId, @NotNull VideoLoadCallback callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        Logger.INSTANCE.d$lrnplayer_release("Loading video. AccessToken: " + accessToken + ". VideoId: " + videoId);
        callback.onVideoLoadStarted();
        String string = videoId;
        String string2 = accessToken;
        string2 = string2 + string;
        VideoLoader.a((String)var1_1, (String)var2_2, string2, (VideoLoadCallback)var3_3);
    }

    public final void cancel$lrnplayer_release() {
        b.cancelAll$lrnplayer_release();
    }

    private static void a(String string, String string2, String string3, VideoLoadCallback videoLoadCallback) {
        if (!VideoDb.INSTANCE.exist$lrnplayer_release(string, string2)) {
            Logger.INSTANCE.d$lrnplayer_release("Video metadata and file is available on device");
            Logger.INSTANCE.d$lrnplayer_release("Fetching video data");
            a.fetch$lrnplayer_release(string, string2, new VideoDataFetcher.VideoDataFetchCallback(string, string2, string3, videoLoadCallback){
                final /* synthetic */ String a;
                final /* synthetic */ String b;
                final /* synthetic */ String c;
                final /* synthetic */ VideoLoadCallback d;

                /*
                 * WARNING - void declaration
                 */
                public final void onVideoDataFetched(@NotNull VideoDataResponse videoData) {
                    void var1_1;
                    Intrinsics.checkParameterIsNotNull((Object)videoData, (String)"videoData");
                    VideoDb.INSTANCE.saveMetadata$lrnplayer_release(this.a, this.b, videoData.getMetaData());
                    VideoLoader.access$downloadVideo(VideoLoader.INSTANCE, this.a, this.b, (VideoDataResponse)var1_1, this.c, this.d);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void onVideoDataFetchError(@NotNull Exception e2) {
                    void var1_1;
                    Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                    this.d.onVideoLoadError((Exception)var1_1);
                }
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.a = var1_1;
                    this.b = var2_2;
                    this.c = var3_3;
                    this.d = $captured_local_variable$3;
                }
            });
            return;
        }
        Logger.INSTANCE.d$lrnplayer_release("Video metadata or file is not available on the device");
        VideoDb.INSTANCE.load$lrnplayer_release(string, string2, string3, new VideoDb.VideoLoadCallback(videoLoadCallback){
            final /* synthetic */ VideoLoadCallback a;

            /*
             * WARNING - void declaration
             */
            public final void onVideoLoaded(@NotNull VideoDb.VideoLoadResponse videoData) {
                void var1_1;
                Intrinsics.checkParameterIsNotNull((Object)videoData, (String)"videoData");
                this.a.onVideoLoaded(videoData.getMetadata(), var1_1.getBytesBase64Encoded());
            }

            /*
             * WARNING - void declaration
             */
            public final void onVideoLoadError(@NotNull Exception e2) {
                void var1_1;
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                this.a.onVideoLoadError((Exception)var1_1);
            }
            {
                void var1_1;
                this.a = var1_1;
            }
        });
    }

    private VideoLoader() {
    }

    static {
        INSTANCE = new VideoLoader();
        a = Injector.INSTANCE.provideVideoDataFetcher$lrnplayer_release();
        b = Injector.INSTANCE.provideDownloader$lrnplayer_release();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$downloadVideo(VideoLoader $this, @NotNull String accessToken, @NotNull String videoId, @NotNull VideoDataResponse videoData, @NotNull String key, @NotNull VideoLoadCallback callback) {
        String string;
        void var2_2;
        void v0 = var2_2;
        void v1 = string;
        VideoLoadCallback videoLoadCallback = callback;
        string = key;
        var2_2 = v1;
        void var1_1 = v0;
        String string2 = accessToken;
        b.download$lrnplayer_release(var2_2.getUrl(), VideoDb.INSTANCE.getFile$lrnplayer_release(string2, (String)var1_1), (String)var1_1, string, new Downloader.DownloadCallback(videoLoadCallback, string2, (String)var1_1, string){
            final /* synthetic */ VideoLoadCallback a;
            final /* synthetic */ String b;
            final /* synthetic */ String c;
            final /* synthetic */ String d;

            /*
             * WARNING - void declaration
             */
            public final void onDownloadStarted(@NotNull String downloadTag) {
                void var1_1;
                Intrinsics.checkParameterIsNotNull((Object)downloadTag, (String)"downloadTag");
                Logger.INSTANCE.d$lrnplayer_release("Download started. Tag: " + (String)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void onDownloadProgressUpdate(@NotNull String downloadTag, long bytesTransferred, long totalBytes) {
                void var2_2;
                void var1_1;
                Intrinsics.checkParameterIsNotNull((Object)downloadTag, (String)"downloadTag");
                Logger.INSTANCE.d$lrnplayer_release("Download progress update. Tag: " + (String)var1_1);
                this.a.onVideoLoadProgress((long)var2_2, totalBytes);
            }

            /*
             * WARNING - void declaration
             */
            public final void onDownloadError(@NotNull String downloadTag, @NotNull Exception e2) {
                void var2_2;
                void var1_1;
                Intrinsics.checkParameterIsNotNull((Object)downloadTag, (String)"downloadTag");
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                Logger.INSTANCE.d$lrnplayer_release("Download error. Tag: " + (String)var1_1);
                this.a.onVideoLoadError((Exception)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final void onDownloadCompleted(@NotNull String downloadTag) {
                void var1_1;
                Intrinsics.checkParameterIsNotNull((Object)downloadTag, (String)"downloadTag");
                Logger.INSTANCE.d$lrnplayer_release("Download completed. Tag: " + (String)var1_1);
                VideoLoader.access$loadVideo(VideoLoader.INSTANCE, this.b, this.c, this.d, this.a);
            }
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.a = var1_1;
                this.b = var2_2;
                this.c = var3_3;
                this.d = $captured_local_variable$3;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$loadVideo(VideoLoader $this, @NotNull String accessToken, @NotNull String videoId, @NotNull String key, @NotNull VideoLoadCallback callback) {
        void var3_3;
        void var2_2;
        VideoLoader.a(accessToken, (String)var2_2, (String)var3_3, callback);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&J\b\u0010\u000b\u001a\u00020\u0003H&J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a8\u0006\u0011"}, d2={"Lio/dotlearn/lrnplayer/loader/VideoLoader$VideoLoadCallback;", "", "onVideoLoadError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onVideoLoadProgress", "bytesTransferred", "", "totalBytes", "onVideoLoadStarted", "onVideoLoaded", "metadata", "Lio/dotlearn/lrnplayer/loader/model/VideoMetadata;", "videoDataBase64Encoded", "", "lrnplayer_release"})
    public static interface VideoLoadCallback {
        public void onVideoLoadStarted();

        public void onVideoLoadProgress(long var1, long var3);

        public void onVideoLoaded(@NotNull VideoMetadata var1, @NotNull String var2);

        public void onVideoLoadError(@NotNull Exception var1);
    }
}

