/*
 * Decompiled with CFR 0.152.
 */
package io.dotlearn.lrnplayer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import io.dotlearn.lrnplayer.LRNPlayerContract;
import io.dotlearn.lrnplayer.LRNPlayerWebInterface;
import io.dotlearn.lrnplayer.R;
import io.dotlearn.lrnplayer.error.LRNPlayerException;
import io.dotlearn.lrnplayer.error.LRNPlayerNotPreparedException;
import io.dotlearn.lrnplayer.error.LRNPlayerOfflineException;
import io.dotlearn.lrnplayer.listener.OnDownloadProgressListener;
import io.dotlearn.lrnplayer.listener.OnErrorListener;
import io.dotlearn.lrnplayer.listener.OnFullScreenToggledListener;
import io.dotlearn.lrnplayer.listener.OnGetCurrentPositionListener;
import io.dotlearn.lrnplayer.listener.OnMetadataLoadedListener;
import io.dotlearn.lrnplayer.listener.OnPlaybackCompletionListener;
import io.dotlearn.lrnplayer.listener.OnPreparedListener;
import io.dotlearn.lrnplayer.utils.DisplayUtils;
import io.dotlearn.lrnplayer.utils.WirelessUtils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001NB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u0010J\b\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u00020\u001e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\"\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nH\u0002J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0002J0\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\nH\u0014J\u0006\u0010.\u001a\u00020\u001eJ\b\u0010/\u001a\u00020\u001eH\u0016J\u0012\u00100\u001a\u00020\u001e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J(\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u001eH\u0016J\u0010\u00107\u001a\u00020\u001e2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u001e2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u001e2\u0006\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020\u001eH\u0003J\b\u0010M\u001a\u00020\u001eH\u0016R\u000e\u0010\f\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lio/dotlearn/lrnplayer/LRNPlayerView;", "Landroid/widget/FrameLayout;", "Lio/dotlearn/lrnplayer/LRNPlayerContract$PlayerView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "containerView", "displayUtils", "Lio/dotlearn/lrnplayer/utils/DisplayUtils;", "isPrepared", "", "isWebViewLoaded", "prepareRequest", "Lio/dotlearn/lrnplayer/LRNPlayerView$PrepareRequest;", "webInterface", "Lio/dotlearn/lrnplayer/LRNPlayerWebInterface;", "webView", "Landroid/webkit/WebView;", "calculateWidthAndHeight", "Lkotlin/Pair;", "checkIsPrepared", "actionName", "", "debug", "", "getWindowManager", "Landroid/view/WindowManager;", "init", "loadVideo", "videoWidth", "videoHeight", "onError", "e", "Lio/dotlearn/lrnplayer/error/LRNPlayerException;", "onLayout", "changed", "l", "t", "r", "b", "onPrepared", "pause", "prepare", "accessToken", "videoId", "autoStart", "onPrepareListener", "Lio/dotlearn/lrnplayer/listener/OnPreparedListener;", "release", "seekTo", "seekPos", "", "setOnCompletionListener", "completionListener", "Lio/dotlearn/lrnplayer/listener/OnPlaybackCompletionListener;", "setOnDownloadListener", "downloadProgressListener", "Lio/dotlearn/lrnplayer/listener/OnDownloadProgressListener;", "setOnErrorListener", "errorListener", "Lio/dotlearn/lrnplayer/listener/OnErrorListener;", "setOnFullScreenToggledListener", "fullScreenToggledListener", "Lio/dotlearn/lrnplayer/listener/OnFullScreenToggledListener;", "setOnGetCurrentPositionListener", "getCurrentPositionListener", "Lio/dotlearn/lrnplayer/listener/OnGetCurrentPositionListener;", "setOnMetadataLoadedListener", "metadataLoadedListener", "Lio/dotlearn/lrnplayer/listener/OnMetadataLoadedListener;", "setupWebView", "start", "PrepareRequest", "lrnplayer_release"})
public final class LRNPlayerView
extends FrameLayout
implements LRNPlayerContract.PlayerView {
    private WebView webView;
    private FrameLayout containerView;
    private boolean isPrepared;
    private boolean isWebViewLoaded;
    private PrepareRequest prepareRequest;
    private LRNPlayerWebInterface webInterface;
    private DisplayUtils displayUtils;
    private HashMap _$_findViewCache;

    private final void init(AttributeSet attrs, int defStyle) {
        View layoutView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_lrnplayer, (ViewGroup)this);
        View view = layoutView.findViewById(R.id.lrn_container);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"layoutView.findViewById(R.id.lrn_container)");
        this.containerView = (FrameLayout)view;
        View view2 = layoutView.findViewById(R.id.lrn_web_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"layoutView.findViewById(R.id.lrn_web_view)");
        this.webView = (WebView)view2;
        this.displayUtils = new DisplayUtils(this.getWindowManager());
        this.webInterface = new LRNPlayerWebInterface(this);
        this.setupWebView();
    }

    private final WindowManager getWindowManager() {
        Object object = this.getContext().getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        return (WindowManager)object;
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private final void setupWebView() {
        WebSettings webSettings;
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        WebSettings webSettings2 = webSettings = webView.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)webSettings2, (String)"webSettings");
        webSettings2.setJavaScriptEnabled(true);
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        webView2.addJavascriptInterface((Object)lRNPlayerWebInterface, "Android");
        WebView webView3 = this.webView;
        if (webView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView3.setWebChromeClient(new WebChromeClient(this){
            final /* synthetic */ LRNPlayerView this$0;

            public boolean onConsoleMessage(@NotNull ConsoleMessage consoleMessage) {
                Intrinsics.checkParameterIsNotNull((Object)consoleMessage, (String)"consoleMessage");
                LRNPlayerView.access$getWebInterface$p(this.this$0).log("Line no: " + consoleMessage.lineNumber() + ',' + " Source id: " + consoleMessage.sourceId() + ',' + " Message: " + consoleMessage.message());
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
        WebView webView4 = this.webView;
        if (webView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView4.setWebViewClient(new WebViewClient(this){
            final /* synthetic */ LRNPlayerView this$0;

            public void onPageFinished(@NotNull WebView view, @NotNull String url) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                LRNPlayerView.access$setWebViewLoaded$p(this.this$0, true);
                LRNPlayerView.access$prepare(this.this$0, LRNPlayerView.access$getPrepareRequest$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        });
        WebView webView5 = this.webView;
        if (webView5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView5.loadUrl("file:///android_asset/base.html");
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.prepare(this.prepareRequest);
    }

    public final void debug(boolean debug) {
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setDebug$lrnplayer_release(debug);
    }

    @Override
    public void prepare(@NotNull String accessToken, @NotNull String videoId, boolean autoStart, @NotNull OnPreparedListener onPrepareListener) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
        Intrinsics.checkParameterIsNotNull((Object)onPrepareListener, (String)"onPrepareListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setPrepareListener$lrnplayer_release(onPrepareListener);
        PrepareRequest prepareRequest = new PrepareRequest(accessToken, videoId, autoStart);
        if (ViewCompat.isLaidOut((View)((View)this))) {
            LRNPlayerWebInterface lRNPlayerWebInterface2 = this.webInterface;
            if (lRNPlayerWebInterface2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
            }
            lRNPlayerWebInterface2.log("View is laid out. Preparing");
            this.prepare(prepareRequest);
        } else {
            LRNPlayerWebInterface lRNPlayerWebInterface3 = this.webInterface;
            if (lRNPlayerWebInterface3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
            }
            lRNPlayerWebInterface3.log("View is not laid out. Scheduling video preparation...");
            this.prepareRequest = prepareRequest;
        }
    }

    private final void prepare(PrepareRequest prepareRequest) {
        if (prepareRequest != null) {
            if (this.isWebViewLoaded) {
                Pair<Integer, Integer> widthHeightPair = this.calculateWidthAndHeight();
                this.loadVideo(prepareRequest, ((Number)widthHeightPair.getFirst()).intValue(), ((Number)widthHeightPair.getSecond()).intValue());
                this.prepareRequest = null;
            } else {
                this.prepareRequest = prepareRequest;
            }
        }
    }

    private final Pair<Integer, Integer> calculateWidthAndHeight() {
        int videoHeight;
        DisplayUtils displayUtils = this.displayUtils;
        if (displayUtils == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayUtils");
        }
        int videoWidth = displayUtils.px2dp$lrnplayer_release(this.getWidth());
        DisplayUtils displayUtils2 = this.displayUtils;
        if (displayUtils2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayUtils");
        }
        int usableScreenHeight = displayUtils2.getUsableScreenHeight$lrnplayer_release();
        DisplayUtils displayUtils3 = this.displayUtils;
        if (displayUtils3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayUtils");
        }
        if ((videoHeight = displayUtils3.calculateHeightBasedOnWidthAndAspectRatio$lrnplayer_release(1.77777778, videoWidth)) > usableScreenHeight) {
            videoHeight = usableScreenHeight;
        }
        return new Pair((Object)videoWidth, (Object)videoHeight);
    }

    private final void loadVideo(PrepareRequest prepareRequest, int videoWidth, int videoHeight) {
        this.isPrepared = false;
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        if (WirelessUtils.INSTANCE.isConnected$lrnplayer_release(context)) {
            String stringToLoad = "javascript:prepare(\n                        \"" + prepareRequest.getAccessToken() + "\", \"" + prepareRequest.getVideoId() + "\",\n                        " + prepareRequest.getAutoStart() + ", " + videoWidth + ", " + videoHeight + ");";
            LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
            if (lRNPlayerWebInterface == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
            }
            lRNPlayerWebInterface.log(stringToLoad);
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            }
            webView.loadUrl(stringToLoad);
        } else {
            LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
            if (lRNPlayerWebInterface == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
            }
            lRNPlayerWebInterface.onError(new LRNPlayerOfflineException("Cannot prepare video while the device is offline"));
        }
    }

    public final void onPrepared() {
        this.isPrepared = true;
    }

    @Override
    public void start() {
        if (this.checkIsPrepared("start()")) {
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            }
            webView.loadUrl("javascript:play();");
        }
    }

    @Override
    public void pause() {
        if (this.checkIsPrepared("pause()")) {
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            }
            webView.loadUrl("javascript:pause();");
        }
    }

    @Override
    public void seekTo(long seekPos) {
        if (this.checkIsPrepared("seekTo()")) {
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            }
            webView.loadUrl("javascript:seekTo(\"" + seekPos + "\");");
        }
    }

    @Override
    public void setOnCompletionListener(@NotNull OnPlaybackCompletionListener completionListener) {
        Intrinsics.checkParameterIsNotNull((Object)completionListener, (String)"completionListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setCompletionListener$lrnplayer_release(completionListener);
    }

    @Override
    public void setOnErrorListener(@NotNull OnErrorListener errorListener) {
        Intrinsics.checkParameterIsNotNull((Object)errorListener, (String)"errorListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setErrorListener$lrnplayer_release(errorListener);
    }

    @Override
    public void setOnGetCurrentPositionListener(@NotNull OnGetCurrentPositionListener getCurrentPositionListener) {
        Intrinsics.checkParameterIsNotNull((Object)getCurrentPositionListener, (String)"getCurrentPositionListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setGetCurrentPositionListener$lrnplayer_release(getCurrentPositionListener);
    }

    @Override
    public void setOnDownloadListener(@NotNull OnDownloadProgressListener downloadProgressListener) {
        Intrinsics.checkParameterIsNotNull((Object)downloadProgressListener, (String)"downloadProgressListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setDownloadProgressListener$lrnplayer_release(downloadProgressListener);
    }

    @Override
    public void setOnMetadataLoadedListener(@NotNull OnMetadataLoadedListener metadataLoadedListener) {
        Intrinsics.checkParameterIsNotNull((Object)metadataLoadedListener, (String)"metadataLoadedListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setMetadataLoadedListener$lrnplayer_release(metadataLoadedListener);
    }

    @Override
    public void setOnFullScreenToggledListener(@NotNull OnFullScreenToggledListener fullScreenToggledListener) {
        Intrinsics.checkParameterIsNotNull((Object)fullScreenToggledListener, (String)"fullScreenToggledListener");
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.setFullScreenToggledListener$lrnplayer_release(fullScreenToggledListener);
    }

    @Override
    public void release() {
        FrameLayout frameLayout = this.containerView;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerView");
        }
        frameLayout.removeAllViews();
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView.clearHistory();
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView2.clearCache(false);
        WebView webView3 = this.webView;
        if (webView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView3.loadUrl("about:blank");
        WebView webView4 = this.webView;
        if (webView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView4.onPause();
        WebView webView5 = this.webView;
        if (webView5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
        }
        webView5.destroy();
    }

    private final void onError(LRNPlayerException e) {
        LRNPlayerWebInterface lRNPlayerWebInterface = this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        lRNPlayerWebInterface.onError(e);
    }

    private final boolean checkIsPrepared(String actionName) {
        if (!this.isPrepared) {
            this.onError(new LRNPlayerNotPreparedException("LRNPlayerView is not prepared. " + "Ensure that the Player is prepared before calling " + actionName));
            return false;
        }
        return true;
    }

    public LRNPlayerView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.init(null, 0);
    }

    public LRNPlayerView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.init(attrs, 0);
    }

    public LRNPlayerView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    @NotNull
    public static final /* synthetic */ LRNPlayerWebInterface access$getWebInterface$p(LRNPlayerView $this) {
        LRNPlayerWebInterface lRNPlayerWebInterface = $this.webInterface;
        if (lRNPlayerWebInterface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webInterface");
        }
        return lRNPlayerWebInterface;
    }

    public static final /* synthetic */ void access$setWebInterface$p(LRNPlayerView $this, @NotNull LRNPlayerWebInterface lRNPlayerWebInterface) {
        $this.webInterface = lRNPlayerWebInterface;
    }

    public static final /* synthetic */ boolean access$isWebViewLoaded$p(LRNPlayerView $this) {
        return $this.isWebViewLoaded;
    }

    public static final /* synthetic */ void access$setWebViewLoaded$p(LRNPlayerView $this, boolean bl) {
        $this.isWebViewLoaded = bl;
    }

    public static final /* synthetic */ void access$prepare(LRNPlayerView $this, @Nullable PrepareRequest prepareRequest) {
        $this.prepare(prepareRequest);
    }

    @Nullable
    public static final /* synthetic */ PrepareRequest access$getPrepareRequest$p(LRNPlayerView $this) {
        return $this.prepareRequest;
    }

    public static final /* synthetic */ void access$setPrepareRequest$p(LRNPlayerView $this, @Nullable PrepareRequest prepareRequest) {
        $this.prepareRequest = prepareRequest;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lio/dotlearn/lrnplayer/LRNPlayerView$PrepareRequest;", "", "accessToken", "", "videoId", "autoStart", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getAccessToken", "()Ljava/lang/String;", "getAutoStart", "()Z", "getVideoId", "lrnplayer_release"})
    public static final class PrepareRequest {
        @NotNull
        private final String accessToken;
        @NotNull
        private final String videoId;
        private final boolean autoStart;

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        @NotNull
        public final String getVideoId() {
            return this.videoId;
        }

        public final boolean getAutoStart() {
            return this.autoStart;
        }

        public PrepareRequest(@NotNull String accessToken, @NotNull String videoId, boolean autoStart) {
            Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
            Intrinsics.checkParameterIsNotNull((Object)videoId, (String)"videoId");
            this.accessToken = accessToken;
            this.videoId = videoId;
            this.autoStart = autoStart;
        }
    }
}

