/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.simpleast.core.util;

import dev.vankka.simpleast.core.TextStyle;
import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.node.StyleNode;
import dev.vankka.simpleast.core.node.TextNode;
import dev.vankka.simpleast.core.util.ASTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeMatcher {
    private Map<Class, NodeMatcher> matchers = new HashMap<Class, NodeMatcher>();

    public boolean matches(List<? extends Node> tree1, List<? extends Node> tree2) {
        ArrayList tree1PostOrder = new ArrayList();
        ArrayList tree2PostOrder = new ArrayList();
        ASTUtils.traversePostOrder(tree1, tree1PostOrder::add);
        ASTUtils.traversePostOrder(tree2, tree2PostOrder::add);
        if (tree1PostOrder.size() != tree2PostOrder.size()) {
            return false;
        }
        for (int i = 0; i < tree1PostOrder.size(); ++i) {
            Node node1 = (Node)tree1PostOrder.get(i);
            Node node2 = (Node)tree2PostOrder.get(i);
            if (node1.getClass() != node2.getClass()) {
                return false;
            }
            Class<?> clazz = node1.getClass();
            if (!this.matchers.containsKey(clazz) || this.matchers.get(clazz).matches(node1, node2)) continue;
            return false;
        }
        return true;
    }

    public void registerMatcher(Class clazz, NodeMatcher matcher) {
        this.matchers.put(clazz, matcher);
    }

    public void registerDefaultMatchers() {
        this.registerMatcher(TextNode.class, (node1, node2) -> {
            TextNode textNode1 = (TextNode)node1;
            TextNode textNode2 = (TextNode)node2;
            return textNode1.getContent().equals(textNode2.getContent());
        });
        this.registerMatcher(StyleNode.class, (node1, node2) -> {
            StyleNode styleNode1 = (StyleNode)node1;
            StyleNode styleNode2 = (StyleNode)node2;
            List styles1 = styleNode1.getStyles();
            List styles2 = styleNode2.getStyles();
            if (styles1.size() != styles2.size()) {
                return false;
            }
            for (int i = 0; i < styles1.size(); ++i) {
                TextStyle style1 = (TextStyle)styles1.get(i);
                TextStyle style2 = (TextStyle)styles2.get(i);
                if (style1.getClass() != style2.getClass()) {
                    return false;
                }
                if (style1.equals(style2)) continue;
                return false;
            }
            return true;
        });
    }

    public static interface NodeMatcher {
        public boolean matches(Node var1, Node var2);
    }
}

