/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.renderer.implementation;

import dev.vankka.mcdiscordreserializer.renderer.MinecraftRenderer;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class DefaultMinecraftRenderer
implements MinecraftRenderer {
    public static final DefaultMinecraftRenderer INSTANCE = new DefaultMinecraftRenderer();
    private static final Pattern PATTERN_NEWLINE = Pattern.compile("\n");

    @Override
    public Component strikethrough(Component component) {
        return component.decoration(TextDecoration.STRIKETHROUGH, true);
    }

    @Override
    public Component underline(Component component) {
        return component.decoration(TextDecoration.UNDERLINED, true);
    }

    @Override
    public Component italics(Component component) {
        return component.decoration(TextDecoration.ITALIC, true);
    }

    @Override
    public Component bold(Component component) {
        return component.decoration(TextDecoration.BOLD, true);
    }

    @Override
    public Component codeString(Component component) {
        return component.color((TextColor)NamedTextColor.DARK_GRAY);
    }

    @Override
    public Component codeBlock(Component component) {
        return component.color((TextColor)NamedTextColor.DARK_GRAY);
    }

    @Override
    public Component appendSpoiler(Component component, Component content) {
        return component.append(content.decoration(TextDecoration.OBFUSCATED, true).color((TextColor)NamedTextColor.DARK_GRAY).hoverEvent((HoverEventSource)HoverEvent.showText((Component)content)));
    }

    @Override
    public Component appendQuote(Component component, Component content) {
        TextComponent prefix = Component.text((String)"| ", (TextColor)NamedTextColor.DARK_GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD});
        return ((TextComponent)Component.empty().append((Component)prefix)).append(component.replaceText(PATTERN_NEWLINE, arg_0 -> DefaultMinecraftRenderer.lambda$appendQuote$0((Component)prefix, arg_0)));
    }

    @Override
    public Component appendEmoteMention(Component component, String name, String id) {
        return component.append((Component)Component.text((String)(":" + name + ":")));
    }

    @Override
    public Component appendChannelMention(Component component, String id) {
        return component.append((Component)Component.text((String)("<#" + id + ">")));
    }

    @Override
    public Component appendUserMention(Component component, String id) {
        return component.append((Component)Component.text((String)("<@" + id + ">")));
    }

    @Override
    public Component appendRoleMention(Component component, String id) {
        return component.append((Component)Component.text((String)("<@&" + id + ">")));
    }

    private static /* synthetic */ ComponentLike lambda$appendQuote$0(Component prefix, TextComponent.Builder builder) {
        return builder.append(prefix);
    }
}

