/*
 * Decompiled with CFR 0.152.
 */
package dev.petuska.klip;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import dev.petuska.klip.KlipProcessor$process$;
import dev.petuska.klip.Klippable;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0014\u0010\u0019\u001a\u00020\u0010*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/petuska/klip/KlipProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "sourcesRoot", "", "klipRoots", "", "(Lcom/google/devtools/ksp/processing/CodeGenerator;Lcom/google/devtools/ksp/processing/KSPLogger;Ljava/lang/String;Ljava/util/Map;)V", "assertKlip", "className", "buildStubs", "klipClassRoot", "generate", "", "classDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "klip", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "appendText", "Ljava/io/OutputStream;", "str", "klip-processor"})
public final class KlipProcessor
implements SymbolProcessor {
    @NotNull
    private final CodeGenerator codeGenerator;
    @NotNull
    private final KSPLogger logger;
    @NotNull
    private final String sourcesRoot;
    @NotNull
    private final Map<String, String> klipRoots;

    public KlipProcessor(@NotNull CodeGenerator codeGenerator, @NotNull KSPLogger logger, @NotNull String sourcesRoot, @NotNull Map<String, String> klipRoots) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)sourcesRoot, (String)"sourcesRoot");
        Intrinsics.checkNotNullParameter(klipRoots, (String)"klipRoots");
        this.codeGenerator = codeGenerator;
        this.logger = logger;
        this.sourcesRoot = sourcesRoot;
        this.klipRoots = klipRoots;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        void $this$mapTo$iv$iv;
        Sequence symbols;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String string = Reflection.getOrCreateKotlinClass(Klippable.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        Sequence $this$filterIsInstance$iv = symbols = Resolver.DefaultImpls.getSymbolsWithAnnotation$default((Resolver)resolver, (String)string, (boolean)false, (int)2, null);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)process$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        List classes = SequencesKt.toList((Sequence)sequence);
        Iterable $this$map$iv = classes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KSClassDeclaration kSClassDeclaration = (KSClassDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.generate((KSClassDeclaration)it);
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return CollectionsKt.emptyList();
    }

    private final void appendText(OutputStream $this$appendText, String str) {
        String string = str;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        $this$appendText.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generate(KSClassDeclaration classDeclaration) {
        String containingFilePath;
        KSFile kSFile = classDeclaration.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        KSFile containingFile = kSFile;
        String string = containingFilePath = containingFile.getFilePath();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        String[] stringArray = new String[]{"/"};
        String klipName = (String)StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)it, (CharSequence)Intrinsics.stringPlus((String)this.sourcesRoot, (Object)"/")), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
        String klipRoot = this.klipRoots.get(klipName);
        if (klipRoot != null) {
            String packageName = classDeclaration.getPackageName().asString();
            String className = classDeclaration.getSimpleName().asString();
            Object object = new KSFile[]{containingFile};
            object = this.codeGenerator.createNewFile(new Dependencies(true, object), packageName, Intrinsics.stringPlus((String)className, (Object)"Klip"), "kt");
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                OutputStream file = (OutputStream)object;
                boolean bl6 = false;
                CharSequence charSequence = packageName;
                boolean bl7 = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    this.appendText(file, "package " + packageName + "\n\n");
                }
                String klipClassRoot = Intrinsics.stringPlus((String)klipRoot, (Object)StringsKt.removePrefix((String)containingFilePath, (CharSequence)(this.sourcesRoot + '/' + klipName + "/kotlin")));
                this.appendText(file, this.buildStubs(className, klipClassRoot));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        } else {
            KSPLogger.DefaultImpls.warn$default((KSPLogger)this.logger, (String)("Klip root for [" + klipName + "] not found. Please add it via 'klip.root." + klipName + "' ksp option"), null, (int)2, null);
        }
    }

    private final String buildStubs(String className, String klipClassRoot) {
        return Intrinsics.stringPlus((String)StringsKt.trimIndent((String)("\n        private val klipManager = dev.petuska.klip.KlipManager(\"" + klipClassRoot + "\")\n        \n        " + this.klip(className) + "        \n        " + this.assertKlip(className) + "\n  ")), (Object)"\n");
    }

    private final String klip(String className) {
        return StringsKt.trimIndent((String)("\n        public fun " + className + ".klip(id: Any, source: () -> String): String = klipManager.klip(id, source)\n  "));
    }

    private final String assertKlip(String className) {
        return StringsKt.trimIndent((String)("\n        public fun <T> " + className + ".assertKlip(id: Any, actual: T) {\n            val valueStr = actual.toString()\n            kotlin.test.assertEquals(klip(id) { valueStr }, valueStr)\n        }\n  "));
    }

    public void finish() {
        SymbolProcessor.DefaultImpls.finish((SymbolProcessor)this);
    }

    public void onError() {
        SymbolProcessor.DefaultImpls.onError((SymbolProcessor)this);
    }
}

