/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.crypto.sodium;

import com.google.common.primitives.Bytes;
import dev.paseto.jpaseto.PasetoSecurityException;
import dev.paseto.jpaseto.crypto.sodium.Blake2b;
import dev.paseto.jpaseto.impl.crypto.PreAuthEncoder;
import dev.paseto.jpaseto.impl.crypto.V2LocalCryptoProvider;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.apache.tuweni.crypto.sodium.XChaCha20Poly1305;

public class SodiumV2LocalCryptoProvider
implements V2LocalCryptoProvider {
    private static final byte[] HEADER_BYTES = "v2.local.".getBytes(StandardCharsets.UTF_8);

    public byte[] blake2b(byte[] random, byte[] payload) {
        return Blake2b.hash(24, payload, random);
    }

    public byte[] encrypt(byte[] payload, byte[] footer, byte[] nonce, SecretKey sharedSecret) {
        byte[] preAuth = PreAuthEncoder.encode((byte[][])new byte[][]{HEADER_BYTES, nonce, footer});
        byte[] payloadCipher = XChaCha20Poly1305.encrypt((byte[])payload, (byte[])preAuth, (XChaCha20Poly1305.Key)XChaCha20Poly1305.Key.fromBytes((byte[])sharedSecret.getEncoded()), (XChaCha20Poly1305.Nonce)XChaCha20Poly1305.Nonce.fromBytes((byte[])nonce));
        return Bytes.concat((byte[][])new byte[][]{nonce, payloadCipher});
    }

    public byte[] decrypt(byte[] encryptedBytes, byte[] footer, SecretKey sharedSecret) {
        byte[] nonce = Arrays.copyOf(encryptedBytes, 24);
        byte[] encryptedMessage = Arrays.copyOfRange(encryptedBytes, 24, encryptedBytes.length);
        byte[] preAuth = PreAuthEncoder.encode((byte[][])new byte[][]{HEADER_BYTES, nonce, footer});
        byte[] payloadBytes = XChaCha20Poly1305.decrypt((byte[])encryptedMessage, (byte[])preAuth, (XChaCha20Poly1305.Key)XChaCha20Poly1305.Key.fromBytes((byte[])sharedSecret.getEncoded()), (XChaCha20Poly1305.Nonce)XChaCha20Poly1305.Nonce.fromBytes((byte[])nonce));
        if (payloadBytes == null) {
            throw new PasetoSecurityException("Decryption failed, likely cause is an invalid sharedSecret or MAC.");
        }
        return payloadBytes;
    }
}

