/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl.crypto;

import dev.paseto.jpaseto.PasetoSignatureException;
import dev.paseto.jpaseto.impl.crypto.PreAuthEncoder;
import dev.paseto.jpaseto.impl.crypto.V2PublicCryptoProvider;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class JcaV2PublicCryptoProvider
implements V2PublicCryptoProvider {
    private static final byte[] HEADER_BYTES = "v2.public.".getBytes(StandardCharsets.UTF_8);

    @Override
    public byte[] sign(byte[] payload, byte[] footer, PrivateKey privateKey) {
        byte[] m2 = PreAuthEncoder.encode(HEADER_BYTES, payload, footer);
        try {
            Signature signature = this.signature();
            signature.initSign(privateKey);
            signature.update(m2);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new PasetoSignatureException("Failed to sign token", (Throwable)e);
        }
    }

    @Override
    public boolean verify(byte[] message, byte[] footer, byte[] signature, PublicKey publicKey) {
        byte[] preAuth = PreAuthEncoder.encode(HEADER_BYTES, message, footer);
        try {
            Signature eddsaSignature = this.signature();
            eddsaSignature.initVerify(publicKey);
            eddsaSignature.update(preAuth);
            return eddsaSignature.verify(signature);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new PasetoSignatureException("Could not verify token signature", (Throwable)e);
        }
    }

    private Signature signature() {
        try {
            return Signature.getInstance("Ed25519");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PasetoSignatureException("Could not load signature algorithm 'Ed25519' ensure you are using jpaseto-bouncy-castle.jar or Java 11+", (Throwable)e);
        }
    }
}

