/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl;

import dev.paseto.jpaseto.FooterClaims;
import dev.paseto.jpaseto.KeyResolver;
import dev.paseto.jpaseto.PasetoParser;
import dev.paseto.jpaseto.PasetoParserBuilder;
import dev.paseto.jpaseto.Purpose;
import dev.paseto.jpaseto.Version;
import dev.paseto.jpaseto.impl.DefaultPasetoParser;
import dev.paseto.jpaseto.io.Deserializer;
import dev.paseto.jpaseto.lang.Assert;
import dev.paseto.jpaseto.lang.Services;
import java.security.PublicKey;
import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.crypto.SecretKey;

public class DefaultPasetoParserBuilder
implements PasetoParserBuilder {
    private PublicKey publicKey = null;
    private SecretKey sharedSecret = null;
    private KeyResolver keyResolver = null;
    private Deserializer<Map<String, Object>> deserializer;
    private Clock clock = Clock.systemUTC();
    private Duration allowedClockSkew = Duration.ofMillis(0L);
    private final Map<String, Predicate<Object>> expectedClaimsMap = new HashMap<String, Predicate<Object>>();
    private final Map<String, Predicate<Object>> expectedFooterClaimsMap = new HashMap<String, Predicate<Object>>();

    public PasetoParserBuilder setKeyResolver(KeyResolver keyResolver) {
        this.keyResolver = keyResolver;
        return this;
    }

    public PasetoParserBuilder setSharedSecret(SecretKey sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public PasetoParserBuilder setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public PasetoParserBuilder setDeserializer(Deserializer<Map<String, Object>> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public PasetoParser build() {
        boolean hasDirectKeys;
        Assert.isTrue((this.publicKey != null || this.sharedSecret != null ? 1 : 0) != 0, (String)"PasetoParser must be configure with a public key (for public tokens) and/or a sharedSecret (for local tokens).");
        Deserializer tmpDeserializer = this.deserializer != null ? this.deserializer : (Deserializer)Services.loadFirst(Deserializer.class);
        boolean bl = hasDirectKeys = this.publicKey != null || this.sharedSecret != null;
        if (hasDirectKeys && this.keyResolver != null) {
            throw new IllegalStateException("Both a KeyResolver and a publicKey/sharedSecret cannot be used together, use one or the other");
        }
        KeyResolver tmpKeyResolver = this.keyResolver != null ? this.keyResolver : new SimpleKeyResolver(this.publicKey, this.sharedSecret);
        return new DefaultPasetoParser(tmpKeyResolver, (Deserializer<Map<String, Object>>)tmpDeserializer, this.clock, this.allowedClockSkew, this.expectedClaimsMap, this.expectedFooterClaimsMap);
    }

    public PasetoParserBuilder require(String claimName, Predicate<Object> value) {
        Assert.hasText((String)claimName, (String)"claim name cannot be null or empty.");
        Assert.notNull(value, (String)("The value cannot be null for claim name: " + claimName));
        this.expectedClaimsMap.put(claimName, value);
        return this;
    }

    public PasetoParserBuilder requireFooter(String claimName, Predicate<Object> value) {
        Assert.hasText((String)claimName, (String)"claim name cannot be null or empty.");
        Assert.notNull(value, (String)("The value cannot be null for claim name: " + claimName));
        this.expectedFooterClaimsMap.put(claimName, value);
        return this;
    }

    public PasetoParserBuilder setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"Clock instance cannot be null.");
        this.clock = clock;
        return this;
    }

    public PasetoParserBuilder setAllowedClockSkew(Duration allowedClockSkewMillis) {
        this.allowedClockSkew = allowedClockSkewMillis;
        return this;
    }

    private static class SimpleKeyResolver
    implements KeyResolver {
        private final PublicKey publicKey;
        private final SecretKey sharedSecret;

        private SimpleKeyResolver(PublicKey publicKey, SecretKey sharedSecret) {
            this.publicKey = publicKey;
            this.sharedSecret = sharedSecret;
        }

        public PublicKey resolvePublicKey(Version version, Purpose purpose, FooterClaims footer) {
            Assert.notNull((Object)this.publicKey, (String)"A public key has not been configured.  A public key must be configured in 'Pasetos.parserBuilder().setPublicKey(...)' or Pasetos.parserBuilder().setKeyResolver(...)");
            return this.publicKey;
        }

        public SecretKey resolveSharedKey(Version version, Purpose purpose, FooterClaims footer) {
            Assert.notNull((Object)this.sharedSecret, (String)"A shared secret has not been configured.  A shared secret must be configured in 'Pasetos.parserBuilder().setSharedSecret(...)' or Pasetos.parserBuilder().setKeyResolver(...)");
            return this.sharedSecret;
        }
    }
}

