/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl.crypto;

import dev.paseto.jpaseto.impl.crypto.Hmacs;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public interface V1LocalCryptoProvider {
    public byte[] encrypt(byte[] var1, byte[] var2, byte[] var3, SecretKey var4);

    public byte[] decrypt(byte[] var1, byte[] var2, byte[] var3, SecretKey var4);

    default public byte[] nonce(byte[] payload, byte[] randomBytes) {
        return Hmacs.createNonce(randomBytes, payload);
    }

    public static byte[] doCipher(int mode, byte[] key, byte[] nonce, byte[] input) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            cipher.init(mode, (Key)secretKeySpec, new IvParameterSpec(nonce));
            return cipher.doFinal(input);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SecurityException("Failed create cipher.");
        }
    }
}

