/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl;

import dev.paseto.jpaseto.PasetoV2PublicBuilder;
import dev.paseto.jpaseto.impl.AbstractPasetoBuilder;
import dev.paseto.jpaseto.impl.CryptoProviders;
import dev.paseto.jpaseto.impl.crypto.V2PublicCryptoProvider;
import java.security.PrivateKey;

public class DefaultPasetoV2PublicBuilder
extends AbstractPasetoBuilder<PasetoV2PublicBuilder>
implements PasetoV2PublicBuilder {
    private static final String HEADER = "v2.public.";
    private PrivateKey privateKey;
    private final V2PublicCryptoProvider cryptoProvider;

    public DefaultPasetoV2PublicBuilder() {
        this(CryptoProviders.v2PublicCryptoProvider());
    }

    private DefaultPasetoV2PublicBuilder(V2PublicCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public PasetoV2PublicBuilder setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public String compact() {
        byte[] payload = this.payloadAsBytes();
        byte[] footer = this.footerAsBytes();
        byte[] signature = this.cryptoProvider.sign(payload, footer, this.privateKey);
        return HEADER + this.noPadBase64(payload, signature) + this.footerToString(footer);
    }
}

