/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl;

import dev.paseto.jpaseto.RequiredTypeException;
import dev.paseto.jpaseto.lang.DateFormats;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

abstract class ClaimsMap
implements Map<String, Object> {
    private static final String CONVERSION_ERROR_MSG = "Cannot convert existing claim value of type '%s' to desired type '%s'. JPaseto only converts simple String, Instant, Date, Long, Integer, Short and Byte types automatically. Anything more complex is expected to be already converted to your desired type by the JSON Deserializer implementation. You may specify a custom Deserializer for a JwtParser with the desired conversion configuration via the PasetoParserBuilder.setDeserializer() method. See https://github.com/paseto-toolkit/jpaseto#custom-json for more information. If using Jackson, you can specify custom claim POJO types as described in https://github.com/paseto-toolkit/jpaseto#json-jackson-custom-types";
    private final Map<String, Object> claims;

    ClaimsMap() {
        this(new HashMap<String, Object>());
    }

    public ClaimsMap(Map<String, Object> claims) {
        this.claims = claims;
    }

    @Override
    public int size() {
        return this.claims.size();
    }

    @Override
    public boolean isEmpty() {
        return this.claims.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.claims.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.claims.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.claims.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        if (value == null) {
            return this.claims.remove(key);
        }
        return this.claims.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.claims.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (m == null) {
            return;
        }
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.claims.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.claims.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.claims.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.claims.entrySet();
    }

    protected <T> T get(String claimName, Class<T> requiredType) {
        Object value = this.get(claimName);
        if (value == null) {
            return null;
        }
        if (Instant.class.equals(requiredType)) {
            value = this.isSpecDate(claimName) ? ClaimsMap.toSpecDate(value, claimName) : ClaimsMap.toInstant(value, claimName);
        }
        if (Date.class.equals(requiredType)) {
            value = this.isSpecDate(claimName) ? Date.from(ClaimsMap.toSpecDate(value, claimName)) : Date.from(ClaimsMap.toInstant(value, claimName));
        }
        return this.castClaimValue(value, requiredType);
    }

    <T> T castClaimValue(Object value, Class<T> requiredType) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (requiredType == Long.class) {
                value = (long)intValue;
            } else if (requiredType == Short.class && Short.MIN_VALUE <= intValue && intValue <= Short.MAX_VALUE) {
                value = (short)intValue;
            } else if (requiredType == Byte.class && -128 <= intValue && intValue <= 127) {
                value = (byte)intValue;
            }
        }
        if (!requiredType.isInstance(value)) {
            throw new RequiredTypeException(String.format(CONVERSION_ERROR_MSG, value.getClass(), requiredType));
        }
        return requiredType.cast(value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClaimsMap that = (ClaimsMap)o;
        return Objects.equals(this.claims, that.claims);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.claims);
    }

    public String toString() {
        return this.claims.toString();
    }

    protected static Instant toSpecDate(Object v, String name) {
        if (v == null) {
            return null;
        }
        return ClaimsMap.toInstant(v, name);
    }

    protected static Instant toInstant(Object v, String name) {
        if (v == null) {
            return null;
        }
        if (v instanceof Instant) {
            return (Instant)v;
        }
        if (v instanceof Date) {
            return ((Date)v).toInstant();
        }
        if (v instanceof Calendar) {
            return ((Calendar)v).toInstant();
        }
        if (v instanceof Number) {
            long millis = ((Number)v).longValue();
            return Instant.ofEpochMilli(millis);
        }
        if (v instanceof String) {
            return ClaimsMap.parseIso8601Date((String)v, name);
        }
        throw new IllegalStateException("Cannot create Date from '" + name + "' value '" + v + "'.");
    }

    private static Instant parseIso8601Date(String s, String name) throws IllegalArgumentException {
        try {
            return DateFormats.parseIso8601Date((String)s);
        }
        catch (DateTimeException e) {
            String msg = "'" + name + "' value does not appear to be ISO-8601-formatted: " + s;
            throw new IllegalArgumentException(msg, e);
        }
    }

    protected boolean isSpecDate(String claimName) {
        return false;
    }
}

