/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.Client;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventBus;
import dev.openfeature.sdk.EventDetails;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.EventSupport;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.OpenFeatureClient;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.ProviderRepository;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import dev.openfeature.sdk.internal.AutoCloseableLock;
import dev.openfeature.sdk.internal.AutoCloseableReentrantReadWriteLock;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFeatureAPI
implements EventBus<OpenFeatureAPI> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenFeatureAPI.class);
    static AutoCloseableReentrantReadWriteLock lock = new AutoCloseableReentrantReadWriteLock();
    private final List<Hook> apiHooks = new ArrayList<Hook>();
    private ProviderRepository providerRepository = new ProviderRepository();
    private EventSupport eventSupport = new EventSupport();
    private EvaluationContext evaluationContext;

    protected OpenFeatureAPI() {
    }

    public static OpenFeatureAPI getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Metadata getProviderMetadata() {
        return this.getProvider().getMetadata();
    }

    public Metadata getProviderMetadata(String clientName) {
        return this.getProvider(clientName).getMetadata();
    }

    public Client getClient() {
        return this.getClient(null, null);
    }

    public Client getClient(@Nullable String name) {
        return this.getClient(name, null);
    }

    public Client getClient(@Nullable String name, @Nullable String version) {
        return new OpenFeatureClient(this, name, version);
    }

    public void setEvaluationContext(EvaluationContext evaluationContext) {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            this.evaluationContext = evaluationContext;
        }
    }

    public EvaluationContext getEvaluationContext() {
        try (AutoCloseableLock __ = lock.readLockAutoCloseable();){
            EvaluationContext evaluationContext = this.evaluationContext;
            return evaluationContext;
        }
    }

    public void setProvider(FeatureProvider provider) {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            this.providerRepository.setProvider(provider, this::attachEventProvider, this::emitReady, this::detachEventProvider, this::emitError, false);
        }
    }

    public void setProvider(String clientName, FeatureProvider provider) {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            this.providerRepository.setProvider(clientName, provider, this::attachEventProvider, this::emitReady, this::detachEventProvider, this::emitError, false);
        }
    }

    public void setProviderAndWait(FeatureProvider provider) throws OpenFeatureError {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            this.providerRepository.setProvider(provider, this::attachEventProvider, this::emitReady, this::detachEventProvider, this::emitErrorAndThrow, true);
        }
    }

    public void setProviderAndWait(String clientName, FeatureProvider provider) throws OpenFeatureError {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            this.providerRepository.setProvider(clientName, provider, this::attachEventProvider, this::emitReady, this::detachEventProvider, this::emitErrorAndThrow, true);
        }
    }

    private void attachEventProvider(FeatureProvider provider) {
        if (provider instanceof EventProvider) {
            ((EventProvider)provider).attach((p, event, details) -> this.runHandlersForProvider((FeatureProvider)p, (ProviderEvent)((Object)event), (ProviderEventDetails)details));
        }
    }

    private void emitReady(FeatureProvider provider) {
        this.runHandlersForProvider(provider, ProviderEvent.PROVIDER_READY, (ProviderEventDetails)ProviderEventDetails.builder().build());
    }

    private void detachEventProvider(FeatureProvider provider) {
        if (provider instanceof EventProvider) {
            ((EventProvider)provider).detach();
        }
    }

    private void emitError(FeatureProvider provider, OpenFeatureError exception) {
        this.runHandlersForProvider(provider, ProviderEvent.PROVIDER_ERROR, (ProviderEventDetails)((ProviderEventDetails.ProviderEventDetailsBuilder)ProviderEventDetails.builder().message(exception.getMessage())).build());
    }

    private void emitErrorAndThrow(FeatureProvider provider, OpenFeatureError exception) throws OpenFeatureError {
        this.emitError(provider, exception);
        throw exception;
    }

    public FeatureProvider getProvider() {
        return this.providerRepository.getProvider();
    }

    public FeatureProvider getProvider(String name) {
        return this.providerRepository.getProvider(name);
    }

    public void addHooks(Hook ... hooks) {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            this.apiHooks.addAll(Arrays.asList(hooks));
        }
    }

    public List<Hook> getHooks() {
        try (AutoCloseableLock __ = lock.readLockAutoCloseable();){
            List<Hook> list = this.apiHooks;
            return list;
        }
    }

    public void clearHooks() {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            this.apiHooks.clear();
        }
    }

    public void shutdown() {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            this.providerRepository.shutdown();
            this.eventSupport.shutdown();
            this.providerRepository = new ProviderRepository();
            this.eventSupport = new EventSupport();
        }
    }

    @Override
    public OpenFeatureAPI onProviderReady(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_READY, (Consumer)handler);
    }

    @Override
    public OpenFeatureAPI onProviderConfigurationChanged(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, (Consumer)handler);
    }

    @Override
    public OpenFeatureAPI onProviderStale(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_STALE, (Consumer)handler);
    }

    @Override
    public OpenFeatureAPI onProviderError(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_ERROR, (Consumer)handler);
    }

    @Override
    public OpenFeatureAPI on(ProviderEvent event, Consumer<EventDetails> handler) {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            this.eventSupport.addGlobalHandler(event, handler);
            OpenFeatureAPI openFeatureAPI = this;
            return openFeatureAPI;
        }
    }

    @Override
    public OpenFeatureAPI removeHandler(ProviderEvent event, Consumer<EventDetails> handler) {
        this.eventSupport.removeGlobalHandler(event, handler);
        return this;
    }

    void removeHandler(String clientName, ProviderEvent event, Consumer<EventDetails> handler) {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            this.eventSupport.removeClientHandler(clientName, event, handler);
        }
    }

    void addHandler(String clientName, ProviderEvent event, Consumer<EventDetails> handler) {
        try (AutoCloseableLock __ = lock.writeLockAutoCloseable();){
            if (Optional.ofNullable(this.providerRepository.getProvider(clientName).getState()).orElse(ProviderState.READY).matchesEvent(event)) {
                this.eventSupport.runHandler(handler, (EventDetails)((EventDetails.EventDetailsBuilder)EventDetails.builder().clientName(clientName)).build());
            }
            this.eventSupport.addClientHandler(clientName, event, handler);
        }
    }

    private void runHandlersForProvider(FeatureProvider provider, ProviderEvent event, ProviderEventDetails details) {
        try (AutoCloseableLock __ = lock.readLockAutoCloseable();){
            List<String> clientNamesForProvider = this.providerRepository.getClientNamesForProvider(provider);
            String providerName = Optional.ofNullable(provider.getMetadata()).map(metadata -> metadata.getName()).orElse(null);
            this.eventSupport.runGlobalHandlers(event, EventDetails.fromProviderEventDetails(details, providerName));
            clientNamesForProvider.forEach(name -> this.eventSupport.runClientHandlers((String)name, event, EventDetails.fromProviderEventDetails(details, providerName, name)));
            if (this.providerRepository.isDefaultProvider(provider)) {
                Set<String> allClientNames = this.eventSupport.getAllClientNames();
                Set<String> boundClientNames = this.providerRepository.getAllBoundClientNames();
                allClientNames.removeAll(boundClientNames);
                allClientNames.forEach(name -> this.eventSupport.runClientHandlers((String)name, event, EventDetails.fromProviderEventDetails(details, providerName, name)));
            }
        }
    }

    private static class SingletonHolder {
        private static final OpenFeatureAPI INSTANCE = new OpenFeatureAPI();

        private SingletonHolder() {
        }
    }
}

