/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EventDetails;
import dev.openfeature.sdk.ProviderEvent;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventSupport {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventSupport.class);
    private static final String defaultClientUuid = UUID.randomUUID().toString();
    private static final ExecutorService taskExecutor = Executors.newCachedThreadPool();
    private final Map<String, HandlerStore> handlerStores = new ConcurrentHashMap<String, HandlerStore>();
    private final HandlerStore globalHandlerStore = new HandlerStore();

    EventSupport() {
    }

    public void runClientHandlers(@Nullable String clientName, ProviderEvent event, EventDetails eventDetails) {
        clientName = Optional.ofNullable(clientName).orElse(defaultClientUuid);
        Optional.ofNullable(this.handlerStores.get(clientName)).filter(store -> Optional.of(store).isPresent()).map(store -> (List)((HandlerStore)store).handlerMap.get((Object)event)).ifPresent(handlers -> handlers.forEach(handler -> this.runHandler((Consumer<EventDetails>)handler, eventDetails)));
    }

    public void runGlobalHandlers(ProviderEvent event, EventDetails eventDetails) {
        ((List)this.globalHandlerStore.handlerMap.get((Object)event)).forEach(handler -> this.runHandler((Consumer<EventDetails>)handler, eventDetails));
    }

    public void addClientHandler(@Nullable String clientName, ProviderEvent event, Consumer<EventDetails> handler) {
        String name = Optional.ofNullable(clientName).orElse(defaultClientUuid);
        HandlerStore store = Optional.ofNullable(this.handlerStores.get(name)).orElseGet(() -> {
            HandlerStore newStore = new HandlerStore();
            this.handlerStores.put(name, newStore);
            return newStore;
        });
        store.addHandler(event, handler);
    }

    public void removeClientHandler(String clientName, ProviderEvent event, Consumer<EventDetails> handler) {
        clientName = Optional.ofNullable(clientName).orElse(defaultClientUuid);
        this.handlerStores.get(clientName).removeHandler(event, handler);
    }

    public void addGlobalHandler(ProviderEvent event, Consumer<EventDetails> handler) {
        this.globalHandlerStore.addHandler(event, handler);
    }

    public void removeGlobalHandler(ProviderEvent event, Consumer<EventDetails> handler) {
        this.globalHandlerStore.removeHandler(event, handler);
    }

    public Set<String> getAllClientNames() {
        return this.handlerStores.keySet();
    }

    public void runHandler(Consumer<EventDetails> handler, EventDetails eventDetails) {
        taskExecutor.submit(() -> {
            try {
                handler.accept(eventDetails);
            }
            catch (Exception e) {
                log.error("Exception in event handler {}", (Object)handler, (Object)e);
            }
        });
    }

    public void shutdown() {
        taskExecutor.shutdown();
    }

    static class HandlerStore {
        private final Map<ProviderEvent, List<Consumer<EventDetails>>> handlerMap = new ConcurrentHashMap<ProviderEvent, List<Consumer<EventDetails>>>();

        HandlerStore() {
            this.handlerMap.put(ProviderEvent.PROVIDER_READY, new ArrayList());
            this.handlerMap.put(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, new ArrayList());
            this.handlerMap.put(ProviderEvent.PROVIDER_ERROR, new ArrayList());
            this.handlerMap.put(ProviderEvent.PROVIDER_STALE, new ArrayList());
        }

        void addHandler(ProviderEvent event, Consumer<EventDetails> handler) {
            this.handlerMap.get((Object)event).add(handler);
        }

        void removeHandler(ProviderEvent event, Consumer<EventDetails> handler) {
            this.handlerMap.get((Object)event).remove(handler);
        }
    }
}

