/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk.multiprovider;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.multiprovider.FirstMatchStrategy;
import dev.openfeature.sdk.multiprovider.MultiProviderMetadata;
import dev.openfeature.sdk.multiprovider.Strategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiProvider
extends EventProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiProvider.class);
    private static final String NAME = "multiprovider";
    public static final int INIT_THREADS_COUNT = Runtime.getRuntime().availableProcessors();
    private final Map<String, FeatureProvider> providers;
    private final Strategy strategy;
    private MultiProviderMetadata metadata;

    public MultiProvider(List<FeatureProvider> providers) {
        this(providers, new FirstMatchStrategy());
    }

    public MultiProvider(List<FeatureProvider> providers, Strategy strategy) {
        this.providers = MultiProvider.buildProviders(providers);
        this.strategy = Objects.requireNonNull(strategy, "strategy must not be null");
    }

    protected static Map<String, FeatureProvider> buildProviders(List<FeatureProvider> providers) {
        LinkedHashMap<String, FeatureProvider> providersMap = new LinkedHashMap<String, FeatureProvider>(providers.size());
        for (FeatureProvider provider : providers) {
            FeatureProvider prevProvider = providersMap.put(provider.getMetadata().getName(), provider);
            if (prevProvider == null) continue;
            log.info("duplicated provider name: {}", (Object)provider.getMetadata().getName());
        }
        return Collections.unmodifiableMap(providersMap);
    }

    @Override
    public void initialize(EvaluationContext evaluationContext) throws Exception {
        MultiProviderMetadata.MultiProviderMetadataBuilder metadataBuilder = MultiProviderMetadata.builder().name(NAME);
        HashMap<String, Metadata> providersMetadata = new HashMap<String, Metadata>();
        if (this.providers.isEmpty()) {
            metadataBuilder.originalMetadata(Collections.unmodifiableMap(providersMetadata));
            this.metadata = metadataBuilder.build();
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(INIT_THREADS_COUNT, this.providers.size()));
        try {
            ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>(this.providers.size());
            for (FeatureProvider provider : this.providers.values()) {
                tasks.add(() -> {
                    provider.initialize(evaluationContext);
                    return null;
                });
                Metadata providerMetadata = provider.getMetadata();
                providersMetadata.put(providerMetadata.getName(), providerMetadata);
            }
            metadataBuilder.originalMetadata(Collections.unmodifiableMap(providersMetadata));
            List results = executorService.invokeAll(tasks);
            for (Future result : results) {
                result.get();
            }
        }
        catch (Exception e) {
            try {
                this.shutdown();
            }
            catch (Exception shutdownEx) {
                log.error("error during shutdown after failed initialize", (Throwable)shutdownEx);
            }
            throw e;
        }
        finally {
            executorService.shutdown();
        }
        this.metadata = metadataBuilder.build();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.strategy.evaluate(this.providers, key, defaultValue, ctx, p -> p.getBooleanEvaluation(key, defaultValue, ctx));
    }

    @Override
    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        return this.strategy.evaluate(this.providers, key, defaultValue, ctx, p -> p.getStringEvaluation(key, defaultValue, ctx));
    }

    @Override
    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.strategy.evaluate(this.providers, key, defaultValue, ctx, p -> p.getIntegerEvaluation(key, defaultValue, ctx));
    }

    @Override
    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        return this.strategy.evaluate(this.providers, key, defaultValue, ctx, p -> p.getDoubleEvaluation(key, defaultValue, ctx));
    }

    @Override
    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        return this.strategy.evaluate(this.providers, key, defaultValue, ctx, p -> p.getObjectEvaluation(key, defaultValue, ctx));
    }

    @Override
    public void shutdown() {
        log.debug("shutdown begin");
        for (FeatureProvider provider : this.providers.values()) {
            try {
                provider.shutdown();
            }
            catch (Exception e) {
                log.error("error shutdown provider {}", (Object)provider.getMetadata().getName(), (Object)e);
            }
        }
        log.debug("shutdown end");
        super.shutdown();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static String getNAME() {
        return NAME;
    }
}

