/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.Client;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventBus;
import dev.openfeature.sdk.EventDetails;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.EventSupport;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.FeatureProviderStateManager;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.NoOpTransactionContextPropagator;
import dev.openfeature.sdk.OpenFeatureClient;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.ProviderRepository;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.TransactionContextPropagator;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import dev.openfeature.sdk.internal.AutoCloseableLock;
import dev.openfeature.sdk.internal.AutoCloseableReentrantReadWriteLock;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFeatureAPI
implements EventBus<OpenFeatureAPI> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenFeatureAPI.class);
    static AutoCloseableReentrantReadWriteLock lock = new AutoCloseableReentrantReadWriteLock();
    private final ConcurrentLinkedQueue<Hook> apiHooks;
    private ProviderRepository providerRepository;
    private EventSupport eventSupport;
    private final AtomicReference<EvaluationContext> evaluationContext = new AtomicReference();
    private TransactionContextPropagator transactionContextPropagator;

    protected OpenFeatureAPI() {
        this.apiHooks = new ConcurrentLinkedQueue();
        this.providerRepository = new ProviderRepository(this);
        this.eventSupport = new EventSupport();
        this.transactionContextPropagator = new NoOpTransactionContextPropagator();
    }

    public static OpenFeatureAPI getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Metadata getProviderMetadata() {
        return this.getProvider().getMetadata();
    }

    public Metadata getProviderMetadata(String domain) {
        return this.getProvider(domain).getMetadata();
    }

    public Client getClient() {
        return this.getClient(null, null);
    }

    public Client getClient(String domain) {
        return this.getClient(domain, null);
    }

    public Client getClient(String domain, String version) {
        return new OpenFeatureClient(this, domain, version);
    }

    public OpenFeatureAPI setEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext.set(evaluationContext);
        return this;
    }

    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext.get();
    }

    public TransactionContextPropagator getTransactionContextPropagator() {
        try (AutoCloseableLock ignored = lock.readLockAutoCloseable();){
            TransactionContextPropagator transactionContextPropagator = this.transactionContextPropagator;
            return transactionContextPropagator;
        }
    }

    public void setTransactionContextPropagator(TransactionContextPropagator transactionContextPropagator) {
        if (transactionContextPropagator == null) {
            throw new IllegalArgumentException("Transaction context propagator cannot be null");
        }
        try (AutoCloseableLock ignored = lock.writeLockAutoCloseable();){
            this.transactionContextPropagator = transactionContextPropagator;
        }
    }

    EvaluationContext getTransactionContext() {
        return this.transactionContextPropagator.getTransactionContext();
    }

    public void setTransactionContext(EvaluationContext evaluationContext) {
        this.transactionContextPropagator.setTransactionContext(evaluationContext);
    }

    public void setProvider(FeatureProvider provider) {
        try (AutoCloseableLock ignored = lock.writeLockAutoCloseable();){
            this.providerRepository.setProvider(provider, this::attachEventProvider, this::emitReady, this::detachEventProvider, this::emitError, false);
        }
    }

    public void setProvider(String domain, FeatureProvider provider) {
        try (AutoCloseableLock ignored = lock.writeLockAutoCloseable();){
            this.providerRepository.setProvider(domain, provider, this::attachEventProvider, this::emitReady, this::detachEventProvider, this::emitError, false);
        }
    }

    public void setProviderAndWait(FeatureProvider provider) throws OpenFeatureError {
        try (AutoCloseableLock ignored = lock.writeLockAutoCloseable();){
            this.providerRepository.setProvider(provider, this::attachEventProvider, this::emitReady, this::detachEventProvider, this::emitErrorAndThrow, true);
        }
    }

    public void setProviderAndWait(String domain, FeatureProvider provider) throws OpenFeatureError {
        try (AutoCloseableLock ignored = lock.writeLockAutoCloseable();){
            this.providerRepository.setProvider(domain, provider, this::attachEventProvider, this::emitReady, this::detachEventProvider, this::emitErrorAndThrow, true);
        }
    }

    private void attachEventProvider(FeatureProvider provider) {
        if (provider instanceof EventProvider) {
            ((EventProvider)provider).attach(this::runHandlersForProvider);
        }
    }

    private void emitReady(FeatureProvider provider) {
        this.runHandlersForProvider(provider, ProviderEvent.PROVIDER_READY, (ProviderEventDetails)ProviderEventDetails.builder().build());
    }

    private void detachEventProvider(FeatureProvider provider) {
        if (provider instanceof EventProvider) {
            ((EventProvider)provider).detach();
        }
    }

    private void emitError(FeatureProvider provider, OpenFeatureError exception) {
        this.runHandlersForProvider(provider, ProviderEvent.PROVIDER_ERROR, (ProviderEventDetails)((ProviderEventDetails.ProviderEventDetailsBuilder)ProviderEventDetails.builder().message(exception.getMessage())).build());
    }

    private void emitErrorAndThrow(FeatureProvider provider, OpenFeatureError exception) throws OpenFeatureError {
        this.emitError(provider, exception);
        throw exception;
    }

    public FeatureProvider getProvider() {
        return this.providerRepository.getProvider();
    }

    public FeatureProvider getProvider(String domain) {
        return this.providerRepository.getProvider(domain);
    }

    public void addHooks(Hook ... hooks) {
        this.apiHooks.addAll(Arrays.asList(hooks));
    }

    public List<Hook> getHooks() {
        return new ArrayList<Hook>(this.apiHooks);
    }

    Collection<Hook> getMutableHooks() {
        return this.apiHooks;
    }

    public void clearHooks() {
        this.apiHooks.clear();
    }

    public void shutdown() {
        try (AutoCloseableLock ignored = lock.writeLockAutoCloseable();){
            this.providerRepository.shutdown();
            this.eventSupport.shutdown();
            this.providerRepository = new ProviderRepository(this);
            this.eventSupport = new EventSupport();
        }
    }

    @Override
    public OpenFeatureAPI onProviderReady(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_READY, (Consumer)handler);
    }

    @Override
    public OpenFeatureAPI onProviderConfigurationChanged(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, (Consumer)handler);
    }

    @Override
    public OpenFeatureAPI onProviderStale(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_STALE, (Consumer)handler);
    }

    @Override
    public OpenFeatureAPI onProviderError(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_ERROR, (Consumer)handler);
    }

    @Override
    public OpenFeatureAPI on(ProviderEvent event, Consumer<EventDetails> handler) {
        try (AutoCloseableLock ignored = lock.writeLockAutoCloseable();){
            this.eventSupport.addGlobalHandler(event, handler);
            OpenFeatureAPI openFeatureAPI = this;
            return openFeatureAPI;
        }
    }

    @Override
    public OpenFeatureAPI removeHandler(ProviderEvent event, Consumer<EventDetails> handler) {
        try (AutoCloseableLock ignored = lock.writeLockAutoCloseable();){
            this.eventSupport.removeGlobalHandler(event, handler);
        }
        return this;
    }

    void removeHandler(String domain, ProviderEvent event, Consumer<EventDetails> handler) {
        try (AutoCloseableLock ignored = lock.writeLockAutoCloseable();){
            this.eventSupport.removeClientHandler(domain, event, handler);
        }
    }

    void addHandler(String domain, ProviderEvent event, Consumer<EventDetails> handler) {
        try (AutoCloseableLock ignored = lock.writeLockAutoCloseable();){
            if (Optional.ofNullable(this.providerRepository.getProviderState(domain)).orElse(ProviderState.READY).matchesEvent(event)) {
                this.eventSupport.runHandler(handler, (EventDetails)((EventDetails.EventDetailsBuilder)EventDetails.builder().domain(domain)).build());
            }
            this.eventSupport.addClientHandler(domain, event, handler);
        }
    }

    FeatureProviderStateManager getFeatureProviderStateManager(String domain) {
        return this.providerRepository.getFeatureProviderStateManager(domain);
    }

    private void runHandlersForProvider(FeatureProvider provider, ProviderEvent event, ProviderEventDetails details) {
        try (AutoCloseableLock ignored = lock.readLockAutoCloseable();){
            List<String> domainsForProvider = this.providerRepository.getDomainsForProvider(provider);
            String providerName = Optional.ofNullable(provider.getMetadata()).map(Metadata::getName).orElse(null);
            this.eventSupport.runGlobalHandlers(event, EventDetails.fromProviderEventDetails(details, providerName));
            domainsForProvider.forEach(domain -> this.eventSupport.runClientHandlers((String)domain, event, EventDetails.fromProviderEventDetails(details, providerName, domain)));
            if (this.providerRepository.isDefaultProvider(provider)) {
                Set<String> allDomainNames = this.eventSupport.getAllDomainNames();
                Set<String> boundDomains = this.providerRepository.getAllBoundDomains();
                allDomainNames.removeAll(boundDomains);
                allDomainNames.forEach(domain -> this.eventSupport.runClientHandlers((String)domain, event, EventDetails.fromProviderEventDetails(details, providerName, domain)));
            }
        }
    }

    private static class SingletonHolder {
        private static final OpenFeatureAPI INSTANCE = new OpenFeatureAPI();

        private SingletonHolder() {
        }
    }
}

