/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ImmutableStructure;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.internal.ExcludeFromGeneratedCoverageReport;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;

public final class ImmutableContext
implements EvaluationContext {
    public static final ImmutableContext EMPTY = new ImmutableContext(Collections.emptyMap());
    private final ImmutableStructure structure;
    private volatile Integer cachedHashCode;

    public ImmutableContext() {
        this(new HashMap<String, Value>());
    }

    public ImmutableContext(String targetingKey) {
        this(targetingKey, new HashMap<String, Value>());
    }

    public ImmutableContext(Map<String, Value> attributes) {
        this(null, attributes);
    }

    public ImmutableContext(String targetingKey, Map<String, Value> attributes) {
        this.structure = targetingKey != null ? new ImmutableStructure(targetingKey, attributes) : new ImmutableStructure(attributes);
    }

    @Override
    public String getTargetingKey() {
        Value value = this.getValue("targetingKey");
        return value == null ? null : value.asString();
    }

    @Override
    public EvaluationContext merge(EvaluationContext overridingContext) {
        if (overridingContext == null || overridingContext.isEmpty()) {
            return new ImmutableContext(this.asUnmodifiableMap());
        }
        if (this.isEmpty()) {
            return new ImmutableContext(overridingContext.asUnmodifiableMap());
        }
        Map<String, Value> attributes = this.asMap();
        EvaluationContext.mergeMaps(ImmutableStructure::new, attributes, overridingContext.asUnmodifiableMap());
        return new ImmutableContext(attributes);
    }

    public boolean equals(Object o) {
        return this.isEqualTo(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Integer result = this.cachedHashCode;
        if (result == null) {
            ImmutableContext immutableContext = this;
            synchronized (immutableContext) {
                result = this.cachedHashCode;
                if (result == null) {
                    this.cachedHashCode = result = Integer.valueOf(this.structure.hashCode());
                }
            }
        }
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ImmutableContext(structure=" + String.valueOf(this.structure) + ", cachedHashCode=" + this.cachedHashCode + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<String> keySet() {
        return this.structure.keySet();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Value getValue(String key) {
        return this.structure.getValue(key);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Value> asMap() {
        return this.structure.asMap();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEmpty() {
        return this.structure.isEmpty();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Value> asUnmodifiableMap() {
        return this.structure.asUnmodifiableMap();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> asObjectMap() {
        return this.structure.asObjectMap();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Object convertValue(Value value) {
        return this.structure.convertValue(value);
    }

    private static class DelegateExclusions {
        private DelegateExclusions() {
        }

        @ExcludeFromGeneratedCoverageReport
        public <T extends Structure> Map<String, Value> merge(Function<Map<String, Value>, Structure> newStructure, Map<String, Value> base, Map<String, Value> overriding) {
            return null;
        }
    }
}

