/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.ErrorCode;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.EventProviderListener;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeatureProviderStateManager
implements EventProviderListener {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeatureProviderStateManager.class);
    private final FeatureProvider delegate;
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private final AtomicReference<ProviderState> state = new AtomicReference<ProviderState>(ProviderState.NOT_READY);

    public FeatureProviderStateManager(FeatureProvider delegate) {
        this.delegate = delegate;
        if (delegate instanceof EventProvider) {
            ((EventProvider)delegate).setEventProviderListener(this);
        }
    }

    public void initialize(EvaluationContext evaluationContext) throws Exception {
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        try {
            this.delegate.initialize(evaluationContext);
            this.setState(ProviderState.READY);
        }
        catch (OpenFeatureError openFeatureError) {
            if (ErrorCode.PROVIDER_FATAL.equals((Object)openFeatureError.getErrorCode())) {
                this.setState(ProviderState.FATAL);
            } else {
                this.setState(ProviderState.ERROR);
            }
            this.isInitialized.set(false);
            throw openFeatureError;
        }
        catch (Exception e) {
            this.setState(ProviderState.ERROR);
            this.isInitialized.set(false);
            throw e;
        }
    }

    public void shutdown() {
        this.delegate.shutdown();
        this.setState(ProviderState.NOT_READY);
        this.isInitialized.set(false);
    }

    @Override
    public void onEmit(ProviderEvent event, ProviderEventDetails details) {
        if (ProviderEvent.PROVIDER_ERROR.equals((Object)event)) {
            if (details != null && details.getErrorCode() == ErrorCode.PROVIDER_FATAL) {
                this.setState(ProviderState.FATAL);
            } else {
                this.setState(ProviderState.ERROR);
            }
        } else if (ProviderEvent.PROVIDER_STALE.equals((Object)event)) {
            this.setState(ProviderState.STALE);
        } else if (ProviderEvent.PROVIDER_READY.equals((Object)event)) {
            this.setState(ProviderState.READY);
        }
    }

    private void setState(ProviderState state) {
        ProviderState oldState = this.state.getAndSet(state);
        if (oldState != state) {
            String providerName = this.delegate.getMetadata() == null || this.delegate.getMetadata().getName() == null ? "unknown" : this.delegate.getMetadata().getName();
            log.info("Provider {} transitioned from state {} to state {}", new Object[]{providerName, oldState, state});
        }
    }

    public ProviderState getState() {
        return this.state.get();
    }

    FeatureProvider getProvider() {
        return this.delegate;
    }

    public boolean hasSameProvider(FeatureProvider featureProvider) {
        return this.delegate.equals(featureProvider);
    }
}

