/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.Awaitable;
import dev.openfeature.sdk.EventProviderListener;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.OpenFeatureAPI;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.internal.AutoCloseableLock;
import dev.openfeature.sdk.internal.ConfigurableThreadFactory;
import dev.openfeature.sdk.internal.TriConsumer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventProvider
implements FeatureProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventProvider.class);
    private EventProviderListener eventProviderListener;
    private final ExecutorService emitterExecutor = Executors.newCachedThreadPool(new ConfigurableThreadFactory("openfeature-event-emitter-thread", true));
    private TriConsumer<EventProvider, ProviderEvent, ProviderEventDetails> onEmit = null;

    void setEventProviderListener(EventProviderListener eventProviderListener) {
        this.eventProviderListener = eventProviderListener;
    }

    void attach(TriConsumer<EventProvider, ProviderEvent, ProviderEventDetails> onEmit) {
        if (this.onEmit != null && this.onEmit != onEmit) {
            throw new IllegalStateException("Provider " + this.getMetadata().getName() + " is already attached.");
        }
        this.onEmit = onEmit;
    }

    void detach() {
        this.onEmit = null;
    }

    @Override
    public void shutdown() {
        this.emitterExecutor.shutdown();
        try {
            if (!this.emitterExecutor.awaitTermination(3L, TimeUnit.SECONDS)) {
                log.warn("Emitter executor did not terminate before the timeout period had elapsed");
                this.emitterExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.emitterExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public Awaitable emit(ProviderEvent event, ProviderEventDetails details) {
        EventProviderListener localEventProviderListener = this.eventProviderListener;
        TriConsumer<EventProvider, ProviderEvent, ProviderEventDetails> localOnEmit = this.onEmit;
        if (localEventProviderListener == null && localOnEmit == null) {
            return Awaitable.FINISHED;
        }
        Awaitable awaitable = new Awaitable();
        this.emitterExecutor.submit(() -> {
            try (AutoCloseableLock ignored = OpenFeatureAPI.lock.readLockAutoCloseable();){
                if (localEventProviderListener != null) {
                    localEventProviderListener.onEmit(event, details);
                }
                if (localOnEmit != null) {
                    localOnEmit.accept(this, event, details);
                }
            }
            finally {
                awaitable.wakeup();
            }
        });
        return awaitable;
    }

    public Awaitable emitProviderReady(ProviderEventDetails details) {
        return this.emit(ProviderEvent.PROVIDER_READY, details);
    }

    public Awaitable emitProviderConfigurationChanged(ProviderEventDetails details) {
        return this.emit(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, details);
    }

    public Awaitable emitProviderStale(ProviderEventDetails details) {
        return this.emit(ProviderEvent.PROVIDER_STALE, details);
    }

    public Awaitable emitProviderError(ProviderEventDetails details) {
        return this.emit(ProviderEvent.PROVIDER_ERROR, details);
    }
}

