/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ImmutableStructure;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;

public final class ImmutableContext
implements EvaluationContext {
    private final String targetingKey;
    private final Structure structure;

    public ImmutableContext() {
        this("", new HashMap<String, Value>());
    }

    public ImmutableContext(String targetingKey) {
        this(targetingKey, new HashMap<String, Value>());
    }

    public ImmutableContext(Map<String, Value> attributes) {
        this("", attributes);
    }

    public ImmutableContext(String targetingKey, Map<String, Value> attributes) {
        this.structure = new ImmutableStructure(attributes);
        this.targetingKey = targetingKey;
    }

    @Override
    @Deprecated
    public void setTargetingKey(String targetingKey) {
        throw new UnsupportedOperationException("changing of targeting key is not allowed");
    }

    @Override
    public EvaluationContext merge(EvaluationContext overridingContext) {
        if (overridingContext == null) {
            return new ImmutableContext(this.targetingKey, this.asMap());
        }
        String newTargetingKey = "";
        if (this.getTargetingKey() != null && !this.getTargetingKey().trim().equals("")) {
            newTargetingKey = this.getTargetingKey();
        }
        if (overridingContext.getTargetingKey() != null && !overridingContext.getTargetingKey().trim().equals("")) {
            newTargetingKey = overridingContext.getTargetingKey();
        }
        Map<String, Value> merged = this.merge(m -> new ImmutableStructure((Map<String, Value>)m), this.asMap(), overridingContext.asMap());
        return new ImmutableContext(newTargetingKey, merged);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ImmutableContext(targetingKey=" + this.getTargetingKey() + ", structure=" + this.structure + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTargetingKey() {
        return this.targetingKey;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<String> keySet() {
        return this.structure.keySet();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Value getValue(String key) {
        return this.structure.getValue(key);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Value> asMap() {
        return this.structure.asMap();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> asObjectMap() {
        return this.structure.asObjectMap();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Object convertValue(Value value) {
        return this.structure.convertValue(value);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public <T extends Structure> Map<String, Value> merge(Function<Map<String, Value>, Structure> newStructure, Map<String, Value> base, Map<String, Value> overriding) {
        return this.structure.merge(newStructure, base, overriding);
    }
}

