/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.MutableStructure;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.ValueNotConvertableError;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface Structure {
    public boolean isEmpty();

    public Set<String> keySet();

    public Value getValue(String var1);

    public Map<String, Value> asMap();

    public Map<String, Value> asUnmodifiableMap();

    public Map<String, Object> asObjectMap();

    default public Object convertValue(Value value) {
        if (value == null || value.isNull()) {
            return null;
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isNumber() && !value.isNull()) {
            Number numberValue = (Number)value.asObject();
            if (numberValue instanceof Double) {
                return numberValue.doubleValue();
            }
            if (numberValue instanceof Integer) {
                return numberValue.intValue();
            }
        }
        if (value.isString()) {
            return value.asString();
        }
        if (value.isInstant()) {
            return value.asInstant();
        }
        if (value.isList()) {
            return value.asList().stream().map(this::convertValue).collect(Collectors.toList());
        }
        if (value.isStructure()) {
            Structure s = value.asStructure();
            return s.asUnmodifiableMap().entrySet().stream().collect(HashMap::new, (accumulated, entry) -> accumulated.put(entry.getKey(), this.convertValue((Value)entry.getValue())), HashMap::putAll);
        }
        throw new ValueNotConvertableError();
    }

    public static Structure mapToStructure(Map<String, Object> map) {
        return new MutableStructure(map.entrySet().stream().collect(HashMap::new, (accumulated, entry) -> accumulated.put(entry.getKey(), Value.objectToValue(entry.getValue())), HashMap::putAll));
    }
}

