/*
 * Decompiled with CFR 0.152.
 */
package masecla.modrinth4j.model.team;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public class ModrinthPermissionMask {
    private Set<PermissionType> permissions = new HashSet<PermissionType>();

    public boolean hasPermission(PermissionType permission) {
        return this.permissions.contains((Object)permission);
    }

    public void addPermission(PermissionType permission) {
        this.permissions.add(permission);
    }

    public void removePermission(PermissionType permission) {
        this.permissions.remove((Object)permission);
    }

    public void setPermission(PermissionType permission, boolean value) {
        if (value) {
            this.addPermission(permission);
        } else {
            this.removePermission(permission);
        }
    }

    public int getMask() {
        int mask = 0;
        for (PermissionType permission : this.permissions) {
            mask |= 1 << permission.bitSignificance;
        }
        return mask;
    }

    public void setMask(int mask) {
        this.permissions.clear();
        for (PermissionType permission : PermissionType.values()) {
            if ((mask & 1 << permission.bitSignificance) == 0) continue;
            this.permissions.add(permission);
        }
    }

    public static ModrinthPermissionMask fromMask(int mask) {
        ModrinthPermissionMask permissionMask = new ModrinthPermissionMask();
        permissionMask.setMask(mask);
        return permissionMask;
    }

    public static ModrinthPermissionMask all() {
        ModrinthPermissionMask permissionMask = new ModrinthPermissionMask();
        for (PermissionType permission : PermissionType.values()) {
            permissionMask.addPermission(permission);
        }
        return permissionMask;
    }

    @Generated
    public Set<PermissionType> getPermissions() {
        return this.permissions;
    }

    @Generated
    public void setPermissions(Set<PermissionType> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModrinthPermissionMask)) {
            return false;
        }
        ModrinthPermissionMask other = (ModrinthPermissionMask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<PermissionType> this$permissions = this.getPermissions();
        Set<PermissionType> other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModrinthPermissionMask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<PermissionType> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ModrinthPermissionMask(permissions=" + this.getPermissions() + ")";
    }

    @Generated
    public ModrinthPermissionMask() {
    }

    public static class ModrinthPermissionMaskAdapter
    extends TypeAdapter<ModrinthPermissionMask> {
        public void write(JsonWriter out, ModrinthPermissionMask value) throws IOException {
            if (value != null) {
                out.value((long)value.getMask());
            } else {
                out.nullValue();
            }
        }

        public ModrinthPermissionMask read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (token == JsonToken.NUMBER) {
                return ModrinthPermissionMask.fromMask(in.nextInt());
            }
            return null;
        }
    }

    public static enum PermissionType {
        UPLOAD_VERSION(0),
        DELETE_VERSION(1),
        EDIT_DETAILS(2),
        EDIT_BODY(3),
        MANAGE_INVITES(4),
        REMOVE_MEMBER(5),
        EDIT_MEMBER(6),
        DELETE_PROJECT(7),
        VIEW_ANALYTICS(8),
        VIEW_REVENUE(9);

        private int bitSignificance;

        @Generated
        public int getBitSignificance() {
            return this.bitSignificance;
        }

        @Generated
        private PermissionType(int bitSignificance) {
            this.bitSignificance = bitSignificance;
        }
    }
}

