/*
 * Decompiled with CFR 0.152.
 */
package masecla.modrinth4j.main;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import masecla.modrinth4j.client.HttpClient;
import masecla.modrinth4j.client.agent.UserAgent;
import masecla.modrinth4j.client.instances.RatelimitedHttpClient;
import masecla.modrinth4j.client.instances.UnlimitedHttpClient;
import masecla.modrinth4j.endpoints.SearchEndpoint;
import masecla.modrinth4j.endpoints.project.ProjectEndpoints;
import masecla.modrinth4j.endpoints.tags.TagsEndpoints;
import masecla.modrinth4j.endpoints.teams.TeamsEndpoints;
import masecla.modrinth4j.endpoints.user.UserEndpoints;
import masecla.modrinth4j.endpoints.version.VersionEndpoints;
import masecla.modrinth4j.model.adapters.ISOTimeAdapter;
import masecla.modrinth4j.model.search.FacetCollection;
import masecla.modrinth4j.model.team.ModrinthPermissionMask;

public class ModrinthAPI {
    @NonNull
    private HttpClient client;
    @NonNull
    private String apiKey;
    private Gson gson;

    @Deprecated
    public static ModrinthAPI unlimited(UserAgent agent, String apiKey) {
        UnlimitedHttpClient client = new UnlimitedHttpClient(agent, apiKey);
        ModrinthAPI result = new ModrinthAPI(client, apiKey);
        result.initializeGson();
        return result;
    }

    @Deprecated
    public static ModrinthAPI unlimited(UserAgent agent, String url, String apiKey) {
        UnlimitedHttpClient client = new UnlimitedHttpClient(agent, url, apiKey);
        ModrinthAPI result = new ModrinthAPI(client, apiKey);
        result.initializeGson();
        return result;
    }

    public static ModrinthAPI rateLimited(UserAgent agent, String apiKey) {
        RatelimitedHttpClient client = new RatelimitedHttpClient(agent, apiKey);
        ModrinthAPI result = new ModrinthAPI(client, apiKey);
        result.initializeGson();
        return result;
    }

    public static ModrinthAPI rateLimited(UserAgent agent, String url, String apiKey) {
        RatelimitedHttpClient client = new RatelimitedHttpClient(agent, url, apiKey);
        ModrinthAPI result = new ModrinthAPI(client, apiKey);
        result.initializeGson();
        return result;
    }

    private void initializeGson() {
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(FacetCollection.class, (Object)new FacetCollection.FacetAdapter()).registerTypeAdapter(ModrinthPermissionMask.class, (Object)new ModrinthPermissionMask.ModrinthPermissionMaskAdapter()).registerTypeAdapter(Instant.class, (Object)new ISOTimeAdapter()).create();
    }

    public CompletableFuture<SearchEndpoint.SearchResponse> search(SearchEndpoint.SearchRequest request) {
        SearchEndpoint endpoint = new SearchEndpoint(this.client, this.gson);
        return endpoint.sendRequest(request);
    }

    public ProjectEndpoints projects() {
        return new ProjectEndpoints(this.gson, this.client);
    }

    public VersionEndpoints versions() {
        return new VersionEndpoints(this.gson, this.client);
    }

    public UserEndpoints users() {
        return new UserEndpoints(this.gson, this.client);
    }

    public TeamsEndpoints teams() {
        return new TeamsEndpoints(this.gson, this.client);
    }

    public TagsEndpoints tags() {
        return new TagsEndpoints(this.gson, this.client);
    }

    @Generated
    private ModrinthAPI(@NonNull HttpClient client, @NonNull String apiKey) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        this.client = client;
        this.apiKey = apiKey;
    }
}

