/*
 * Decompiled with CFR 0.152.
 */
package masecla.modrinth4j.endpoints.version;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import masecla.modrinth4j.client.HttpClient;
import masecla.modrinth4j.endpoints.generic.Endpoint;
import masecla.modrinth4j.model.version.ProjectVersion;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CreateVersion
extends Endpoint<ProjectVersion, CreateVersionRequest> {
    public CreateVersion(HttpClient client, Gson gson) {
        super(client, gson);
    }

    @Override
    public String getEndpoint() {
        return "/version";
    }

    @Override
    public CompletableFuture<ProjectVersion> sendRequest(CreateVersionRequest request, Map<String, String> urlParams) {
        String url = this.getReplacedUrl(request, urlParams);
        return this.getClient().connect(url).thenApply(c -> {
            JsonObject jsonObject = this.getGson().toJsonTree((Object)request).getAsJsonObject();
            if (request.getFileNames().size() > 1) {
                String primaryFile = request.getPrimaryFile();
                if (primaryFile == null || primaryFile.isEmpty()) {
                    primaryFile = request.getFileNames().get(0);
                }
                jsonObject.addProperty("primary_file", primaryFile);
            }
            JsonArray array = new JsonArray();
            for (String filename : request.getFileNames()) {
                array.add(filename);
            }
            jsonObject.add("file_parts", (JsonElement)array);
            MultipartBody.Builder body = new MultipartBody.Builder().addFormDataPart("data", this.getGson().toJson((JsonElement)jsonObject));
            for (int i = 0; i < request.getFileNames().size(); ++i) {
                body.addFormDataPart(request.getFileNames().get(i), request.getFileNames().get(i), RequestBody.create((byte[])this.readStream(request.getFileStreams().get(i))));
            }
            c.post((RequestBody)body.build());
            Response response = this.executeRequest((Request.Builder)c);
            ProjectVersion version = (ProjectVersion)this.checkBodyForErrors(response.body());
            return version;
        });
    }

    @Override
    public TypeToken<CreateVersionRequest> getRequestClass() {
        return TypeToken.get(CreateVersionRequest.class);
    }

    @Override
    public TypeToken<ProjectVersion> getResponseClass() {
        return TypeToken.get(ProjectVersion.class);
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    public static class CreateVersionRequest {
        @NonNull
        private String name;
        @NonNull
        private String versionNumber;
        @NonNull
        private String changelog;
        private List<ProjectVersion.ProjectDependency> dependencies;
        private List<String> gameVersions;
        private ProjectVersion.VersionType versionType;
        @NonNull
        private List<String> loaders;
        private boolean featured;
        @NonNull
        private String projectId;
        private String primaryFile;
        @NonNull
        private transient List<String> fileNames;
        @NonNull
        private transient List<InputStream> fileStreams;

        @Generated
        private static List<ProjectVersion.ProjectDependency> $default$dependencies() {
            return new ArrayList<ProjectVersion.ProjectDependency>();
        }

        @Generated
        public static CreateVersionRequestBuilder builder() {
            return new CreateVersionRequestBuilder();
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public String getVersionNumber() {
            return this.versionNumber;
        }

        @NonNull
        @Generated
        public String getChangelog() {
            return this.changelog;
        }

        @Generated
        public List<ProjectVersion.ProjectDependency> getDependencies() {
            return this.dependencies;
        }

        @Generated
        public List<String> getGameVersions() {
            return this.gameVersions;
        }

        @Generated
        public ProjectVersion.VersionType getVersionType() {
            return this.versionType;
        }

        @NonNull
        @Generated
        public List<String> getLoaders() {
            return this.loaders;
        }

        @Generated
        public boolean isFeatured() {
            return this.featured;
        }

        @NonNull
        @Generated
        public String getProjectId() {
            return this.projectId;
        }

        @Generated
        public String getPrimaryFile() {
            return this.primaryFile;
        }

        @NonNull
        @Generated
        public List<String> getFileNames() {
            return this.fileNames;
        }

        @NonNull
        @Generated
        public List<InputStream> getFileStreams() {
            return this.fileStreams;
        }

        @Generated
        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @Generated
        public void setVersionNumber(@NonNull String versionNumber) {
            if (versionNumber == null) {
                throw new NullPointerException("versionNumber is marked non-null but is null");
            }
            this.versionNumber = versionNumber;
        }

        @Generated
        public void setChangelog(@NonNull String changelog) {
            if (changelog == null) {
                throw new NullPointerException("changelog is marked non-null but is null");
            }
            this.changelog = changelog;
        }

        @Generated
        public void setDependencies(List<ProjectVersion.ProjectDependency> dependencies) {
            this.dependencies = dependencies;
        }

        @Generated
        public void setGameVersions(List<String> gameVersions) {
            this.gameVersions = gameVersions;
        }

        @Generated
        public void setVersionType(ProjectVersion.VersionType versionType) {
            this.versionType = versionType;
        }

        @Generated
        public void setLoaders(@NonNull List<String> loaders) {
            if (loaders == null) {
                throw new NullPointerException("loaders is marked non-null but is null");
            }
            this.loaders = loaders;
        }

        @Generated
        public void setFeatured(boolean featured) {
            this.featured = featured;
        }

        @Generated
        public void setProjectId(@NonNull String projectId) {
            if (projectId == null) {
                throw new NullPointerException("projectId is marked non-null but is null");
            }
            this.projectId = projectId;
        }

        @Generated
        public void setPrimaryFile(String primaryFile) {
            this.primaryFile = primaryFile;
        }

        @Generated
        public void setFileNames(@NonNull List<String> fileNames) {
            if (fileNames == null) {
                throw new NullPointerException("fileNames is marked non-null but is null");
            }
            this.fileNames = fileNames;
        }

        @Generated
        public void setFileStreams(@NonNull List<InputStream> fileStreams) {
            if (fileStreams == null) {
                throw new NullPointerException("fileStreams is marked non-null but is null");
            }
            this.fileStreams = fileStreams;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateVersionRequest)) {
                return false;
            }
            CreateVersionRequest other = (CreateVersionRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isFeatured() != other.isFeatured()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$versionNumber = this.getVersionNumber();
            String other$versionNumber = other.getVersionNumber();
            if (this$versionNumber == null ? other$versionNumber != null : !this$versionNumber.equals(other$versionNumber)) {
                return false;
            }
            String this$changelog = this.getChangelog();
            String other$changelog = other.getChangelog();
            if (this$changelog == null ? other$changelog != null : !this$changelog.equals(other$changelog)) {
                return false;
            }
            List<ProjectVersion.ProjectDependency> this$dependencies = this.getDependencies();
            List<ProjectVersion.ProjectDependency> other$dependencies = other.getDependencies();
            if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
                return false;
            }
            List<String> this$gameVersions = this.getGameVersions();
            List<String> other$gameVersions = other.getGameVersions();
            if (this$gameVersions == null ? other$gameVersions != null : !((Object)this$gameVersions).equals(other$gameVersions)) {
                return false;
            }
            ProjectVersion.VersionType this$versionType = this.getVersionType();
            ProjectVersion.VersionType other$versionType = other.getVersionType();
            if (this$versionType == null ? other$versionType != null : !((Object)((Object)this$versionType)).equals((Object)other$versionType)) {
                return false;
            }
            List<String> this$loaders = this.getLoaders();
            List<String> other$loaders = other.getLoaders();
            if (this$loaders == null ? other$loaders != null : !((Object)this$loaders).equals(other$loaders)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            String this$primaryFile = this.getPrimaryFile();
            String other$primaryFile = other.getPrimaryFile();
            return !(this$primaryFile == null ? other$primaryFile != null : !this$primaryFile.equals(other$primaryFile));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateVersionRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFeatured() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $versionNumber = this.getVersionNumber();
            result = result * 59 + ($versionNumber == null ? 43 : $versionNumber.hashCode());
            String $changelog = this.getChangelog();
            result = result * 59 + ($changelog == null ? 43 : $changelog.hashCode());
            List<ProjectVersion.ProjectDependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            List<String> $gameVersions = this.getGameVersions();
            result = result * 59 + ($gameVersions == null ? 43 : ((Object)$gameVersions).hashCode());
            ProjectVersion.VersionType $versionType = this.getVersionType();
            result = result * 59 + ($versionType == null ? 43 : ((Object)((Object)$versionType)).hashCode());
            List<String> $loaders = this.getLoaders();
            result = result * 59 + ($loaders == null ? 43 : ((Object)$loaders).hashCode());
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            String $primaryFile = this.getPrimaryFile();
            result = result * 59 + ($primaryFile == null ? 43 : $primaryFile.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CreateVersion.CreateVersionRequest(name=" + this.getName() + ", versionNumber=" + this.getVersionNumber() + ", changelog=" + this.getChangelog() + ", dependencies=" + this.getDependencies() + ", gameVersions=" + this.getGameVersions() + ", versionType=" + (Object)((Object)this.getVersionType()) + ", loaders=" + this.getLoaders() + ", featured=" + this.isFeatured() + ", projectId=" + this.getProjectId() + ", primaryFile=" + this.getPrimaryFile() + ", fileNames=" + this.getFileNames() + ", fileStreams=" + this.getFileStreams() + ")";
        }

        @Generated
        public CreateVersionRequest(@NonNull String name, @NonNull String versionNumber, @NonNull String changelog, List<ProjectVersion.ProjectDependency> dependencies, List<String> gameVersions, ProjectVersion.VersionType versionType, @NonNull List<String> loaders, boolean featured, @NonNull String projectId, String primaryFile, @NonNull List<String> fileNames, @NonNull List<InputStream> fileStreams) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (versionNumber == null) {
                throw new NullPointerException("versionNumber is marked non-null but is null");
            }
            if (changelog == null) {
                throw new NullPointerException("changelog is marked non-null but is null");
            }
            if (loaders == null) {
                throw new NullPointerException("loaders is marked non-null but is null");
            }
            if (projectId == null) {
                throw new NullPointerException("projectId is marked non-null but is null");
            }
            if (fileNames == null) {
                throw new NullPointerException("fileNames is marked non-null but is null");
            }
            if (fileStreams == null) {
                throw new NullPointerException("fileStreams is marked non-null but is null");
            }
            this.name = name;
            this.versionNumber = versionNumber;
            this.changelog = changelog;
            this.dependencies = dependencies;
            this.gameVersions = gameVersions;
            this.versionType = versionType;
            this.loaders = loaders;
            this.featured = featured;
            this.projectId = projectId;
            this.primaryFile = primaryFile;
            this.fileNames = fileNames;
            this.fileStreams = fileStreams;
        }

        @Generated
        public CreateVersionRequest() {
            this.dependencies = CreateVersionRequest.$default$dependencies();
        }

        public static class CreateVersionRequestBuilder {
            @Generated
            private String name;
            @Generated
            private String versionNumber;
            @Generated
            private String changelog;
            @Generated
            private boolean dependencies$set;
            @Generated
            private List<ProjectVersion.ProjectDependency> dependencies$value;
            @Generated
            private List<String> gameVersions;
            @Generated
            private ProjectVersion.VersionType versionType;
            @Generated
            private List<String> loaders;
            @Generated
            private boolean featured;
            @Generated
            private String projectId;
            @Generated
            private String primaryFile;
            @Generated
            private List<String> fileNames;
            @Generated
            private List<InputStream> fileStreams;

            public CreateVersionRequestBuilder files(File ... files) {
                this.fileNames = new ArrayList<String>();
                this.fileStreams = new ArrayList<InputStream>();
                for (int i = 0; i < files.length; ++i) {
                    this.fileNames.add(files[i].getName());
                    this.fileStreams.add(new FileInputStream(files[i]));
                }
                return this;
            }

            public CreateVersionRequestBuilder files(List<File> files) {
                return this.files(files.toArray(new File[files.size()]));
            }

            @Generated
            CreateVersionRequestBuilder() {
            }

            @Generated
            public CreateVersionRequestBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder versionNumber(@NonNull String versionNumber) {
                if (versionNumber == null) {
                    throw new NullPointerException("versionNumber is marked non-null but is null");
                }
                this.versionNumber = versionNumber;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder changelog(@NonNull String changelog) {
                if (changelog == null) {
                    throw new NullPointerException("changelog is marked non-null but is null");
                }
                this.changelog = changelog;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder dependencies(List<ProjectVersion.ProjectDependency> dependencies) {
                this.dependencies$value = dependencies;
                this.dependencies$set = true;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder gameVersions(List<String> gameVersions) {
                this.gameVersions = gameVersions;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder versionType(ProjectVersion.VersionType versionType) {
                this.versionType = versionType;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder loaders(@NonNull List<String> loaders) {
                if (loaders == null) {
                    throw new NullPointerException("loaders is marked non-null but is null");
                }
                this.loaders = loaders;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder featured(boolean featured) {
                this.featured = featured;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder projectId(@NonNull String projectId) {
                if (projectId == null) {
                    throw new NullPointerException("projectId is marked non-null but is null");
                }
                this.projectId = projectId;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder primaryFile(String primaryFile) {
                this.primaryFile = primaryFile;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder fileNames(@NonNull List<String> fileNames) {
                if (fileNames == null) {
                    throw new NullPointerException("fileNames is marked non-null but is null");
                }
                this.fileNames = fileNames;
                return this;
            }

            @Generated
            public CreateVersionRequestBuilder fileStreams(@NonNull List<InputStream> fileStreams) {
                if (fileStreams == null) {
                    throw new NullPointerException("fileStreams is marked non-null but is null");
                }
                this.fileStreams = fileStreams;
                return this;
            }

            @Generated
            public CreateVersionRequest build() {
                List dependencies$value = this.dependencies$value;
                if (!this.dependencies$set) {
                    dependencies$value = CreateVersionRequest.$default$dependencies();
                }
                return new CreateVersionRequest(this.name, this.versionNumber, this.changelog, dependencies$value, this.gameVersions, this.versionType, this.loaders, this.featured, this.projectId, this.primaryFile, this.fileNames, this.fileStreams);
            }

            @Generated
            public String toString() {
                return "CreateVersion.CreateVersionRequest.CreateVersionRequestBuilder(name=" + this.name + ", versionNumber=" + this.versionNumber + ", changelog=" + this.changelog + ", dependencies$value=" + this.dependencies$value + ", gameVersions=" + this.gameVersions + ", versionType=" + (Object)((Object)this.versionType) + ", loaders=" + this.loaders + ", featured=" + this.featured + ", projectId=" + this.projectId + ", primaryFile=" + this.primaryFile + ", fileNames=" + this.fileNames + ", fileStreams=" + this.fileStreams + ")";
            }
        }
    }
}

