/*
 * Decompiled with CFR 0.152.
 */
package masecla.modrinth4j.endpoints.teams;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import masecla.modrinth4j.client.HttpClient;
import masecla.modrinth4j.endpoints.generic.empty.EmptyRequest;
import masecla.modrinth4j.endpoints.generic.empty.EmptyResponse;
import masecla.modrinth4j.endpoints.teams.AddMemberToTeam;
import masecla.modrinth4j.endpoints.teams.GetProjectTeamMembers;
import masecla.modrinth4j.endpoints.teams.GetTeamMembers;
import masecla.modrinth4j.endpoints.teams.GetTeamsMembers;
import masecla.modrinth4j.endpoints.teams.JoinTeam;
import masecla.modrinth4j.endpoints.teams.ModifyTeamMemberInfo;
import masecla.modrinth4j.endpoints.teams.RemoveMemberFromTeam;
import masecla.modrinth4j.endpoints.teams.TransferOwnership;
import masecla.modrinth4j.model.team.ModrinthTeamMember;

public class TeamsEndpoints {
    private Gson gson;
    private HttpClient client;

    public CompletableFuture<List<ModrinthTeamMember>> getProjectTeamMembers(String projectId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", projectId);
        return new GetProjectTeamMembers(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<List<ModrinthTeamMember>> getTeamMembers(String teamId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", teamId);
        return new GetTeamMembers(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<List<List<ModrinthTeamMember>>> getTeamMembers(List<String> teamIds) {
        return new GetTeamsMembers(this.client, this.gson).sendRequest(new GetTeamsMembers.GetTeamsMembersRequest(teamIds));
    }

    public CompletableFuture<List<List<ModrinthTeamMember>>> getTeamMembers(String ... teamIds) {
        return this.getTeamMembers(Arrays.asList(teamIds));
    }

    public CompletableFuture<EmptyResponse> addMemberToTeam(String teamId, String userId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", teamId);
        return new AddMemberToTeam(this.client, this.gson).sendRequest(new AddMemberToTeam.AddMemberToTeamRequest(userId), parameters);
    }

    public CompletableFuture<EmptyResponse> joinTeam(String teamId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", teamId);
        return new JoinTeam(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<EmptyResponse> modifyTeamMemberInfo(String teamId, String memberId, ModifyTeamMemberInfo.ModifyTeamMemberInfoRequest request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", teamId);
        parameters.put("user", memberId);
        return new ModifyTeamMemberInfo(this.client, this.gson).sendRequest(request, parameters);
    }

    public CompletableFuture<EmptyResponse> removeMemberFromTeam(String teamId, String memberId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", teamId);
        parameters.put("user", memberId);
        return new RemoveMemberFromTeam(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<EmptyResponse> transferOwnership(String teamId, String newOwnerId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", teamId);
        return new TransferOwnership(this.client, this.gson).sendRequest(new TransferOwnership.TransferOwnershipRequest(newOwnerId), parameters);
    }

    @Generated
    public TeamsEndpoints(Gson gson, HttpClient client) {
        this.gson = gson;
        this.client = client;
    }
}

