/*
 * Decompiled with CFR 0.152.
 */
package masecla.modrinth4j.endpoints.project;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import masecla.modrinth4j.client.HttpClient;
import masecla.modrinth4j.endpoints.generic.empty.EmptyRequest;
import masecla.modrinth4j.endpoints.generic.empty.EmptyResponse;
import masecla.modrinth4j.endpoints.project.ChangeProjectIcon;
import masecla.modrinth4j.endpoints.project.CheckSlugAvailability;
import masecla.modrinth4j.endpoints.project.CreateProject;
import masecla.modrinth4j.endpoints.project.DeleteProject;
import masecla.modrinth4j.endpoints.project.GetMultipleProjects;
import masecla.modrinth4j.endpoints.project.GetProject;
import masecla.modrinth4j.endpoints.project.GetProjectDependencies;
import masecla.modrinth4j.endpoints.project.GetProjectIdBySlug;
import masecla.modrinth4j.endpoints.project.ModifyProject;
import masecla.modrinth4j.endpoints.project.follow.FollowProject;
import masecla.modrinth4j.endpoints.project.follow.UnfollowProject;
import masecla.modrinth4j.endpoints.project.gallery.CreateGalleryImage;
import masecla.modrinth4j.endpoints.project.gallery.DeleteGalleryImage;
import masecla.modrinth4j.endpoints.project.gallery.ModifyGalleryImage;
import masecla.modrinth4j.model.project.Project;

public class ProjectEndpoints {
    private Gson gson;
    private HttpClient client;

    public CompletableFuture<Project> get(String project) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", project);
        return new GetProject(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<List<Project>> get(List<String> projects) {
        return new GetMultipleProjects(this.client, this.gson).sendRequest(new GetMultipleProjects.GetMultipleProjectsRequest(projects));
    }

    public CompletableFuture<List<Project>> get(String ... projects) {
        return this.get(Arrays.asList(projects));
    }

    public CompletableFuture<ModifyProject.ProjectModifications> modify(String project, ModifyProject.ProjectModifications request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", project);
        return new ModifyProject(this.client, this.gson).sendRequest(request, parameters);
    }

    public CompletableFuture<EmptyResponse> delete(String project) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", project);
        return new DeleteProject(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<Project> create(CreateProject.CreateProjectRequest request) {
        return new CreateProject(this.client, this.gson).sendRequest(request);
    }

    public CompletableFuture<Boolean> checkSlugAvailability(String slug) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", slug);
        return new CheckSlugAvailability(this.client, this.gson).sendRequest(new EmptyRequest(), parameters).thenApply(response -> {
            if (response == null) {
                return true;
            }
            return false;
        });
    }

    public CompletableFuture<String> getProjectIdBySlug(String slug) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", slug);
        return new GetProjectIdBySlug(this.client, this.gson).sendRequest(new EmptyRequest(), parameters).thenApply(c -> {
            if (c == null) {
                return null;
            }
            return c.getId();
        });
    }

    public CompletableFuture<EmptyResponse> createGalleryImage(String slug, CreateGalleryImage.CreateGalleryImageRequest request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", slug);
        return new CreateGalleryImage(this.client, this.gson).sendRequest(request, (Map<String, String>)parameters);
    }

    public CompletableFuture<EmptyResponse> modifyGalleryImage(String slug, ModifyGalleryImage.ModifyGalleryImageRequest request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", slug);
        return new ModifyGalleryImage(this.client, this.gson).sendRequest(request, parameters);
    }

    public CompletableFuture<EmptyResponse> deleteGalleryImage(String slug, String imageUrl) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", slug);
        return new DeleteGalleryImage(this.client, this.gson).sendRequest(new DeleteGalleryImage.DeleteGalleryImageRequest(imageUrl), parameters);
    }

    public CompletableFuture<GetProjectDependencies.GetProjectDependenciesResponse> getProjectDependencies(String slug) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", slug);
        return new GetProjectDependencies(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<EmptyResponse> followProject(String slug) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", slug);
        return new FollowProject(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<EmptyResponse> unfollowProject(String slug) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", slug);
        return new UnfollowProject(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<EmptyResponse> changeProjectIcon(String projectId, File file) throws FileNotFoundException {
        return this.changeProjectIcon(projectId, new FileInputStream(file), file.getName());
    }

    public CompletableFuture<EmptyResponse> changeProjectIcon(String projectId, InputStream stream, String fileName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", projectId);
        return new ChangeProjectIcon(this.client, this.gson).sendRequest(new ChangeProjectIcon.ChangeProjectIconRequest(stream, fileName), (Map<String, String>)parameters);
    }

    @Generated
    public ProjectEndpoints(Gson gson, HttpClient client) {
        this.gson = gson;
        this.client = client;
    }
}

