/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.blas.l3;

import dev.ludovic.netlib.benchmarks.blas.l3.L3Benchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class SgemmBenchmark
extends L3Benchmark {
    @Param(value={"N", "T"})
    public String transa;
    @Param(value={"N", "T"})
    public String transb;
    @Param(value={"10", "1000"})
    public int m;
    @Param(value={"10", "1000"})
    public int n;
    @Param(value={"10", "1000"})
    public int k;
    public float alpha;
    public float[] a;
    public int lda;
    public float[] b;
    public int ldb;
    public float beta;
    public float[] c;
    public float[] cclone;
    public int ldc;

    @Setup(value=Level.Trial)
    public void setup() {
        this.alpha = this.randomFloat();
        this.a = this.randomFloatArray(this.k * this.m);
        this.b = this.randomFloatArray(this.k * this.n);
        this.beta = this.randomFloat();
        this.c = this.randomFloatArray(this.m * this.n);
    }

    @Benchmark
    public void blas(Blackhole bh) {
        this.cclone = (float[])this.c.clone();
        this.blas.sgemm(this.transa, this.transb, this.m, this.n, this.k, this.alpha, this.a, this.transa.equals("N") ? this.m : this.k, this.b, this.transb.equals("N") ? this.k : this.n, this.beta, this.cclone, this.m);
        bh.consume((Object)this.cclone);
    }
}

