/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.blas.l2;

import dev.ludovic.netlib.benchmarks.blas.l2.L2Benchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class DgemvBenchmark
extends L2Benchmark {
    @Param(value={"N", "T"})
    public String trans;
    @Param(value={"10", "1000"})
    public int m;
    @Param(value={"10", "1000"})
    public int n;
    public double alpha;
    public double[] a;
    public double[] x;
    public double beta;
    public double[] y;
    public double[] yclone;

    @Setup(value=Level.Trial)
    public void setup() {
        this.alpha = this.randomDouble();
        this.a = this.randomDoubleArray(this.m * this.n);
        this.x = this.randomDoubleArray(this.trans.equals("T") ? this.m : this.n);
        this.beta = this.randomDouble();
        this.y = this.randomDoubleArray(this.trans.equals("T") ? this.n : this.m);
    }

    @Setup(value=Level.Invocation)
    public void setupIteration() {
        this.yclone = (double[])this.y.clone();
    }

    @Benchmark
    public void blas(Blackhole bh) {
        this.blas.dgemv(this.trans, this.m, this.n, this.alpha, this.a, this.m, this.x, 1, this.beta, this.yclone, 1);
        bh.consume((Object)this.yclone);
    }
}

