/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.arpack;

import dev.ludovic.netlib.arpack.ARPACK;
import dev.ludovic.netlib.arpack.F2jARPACK;
import dev.ludovic.netlib.arpack.JNIARPACK;
import dev.ludovic.netlib.arpack.JavaARPACK;
import dev.ludovic.netlib.arpack.NativeARPACK;
import java.util.logging.Logger;

final class InstanceBuilder {
    private static final Logger log = Logger.getLogger(InstanceBuilder.class.getName());
    private static final ARPACK arpack = InstanceBuilder.getInstanceImpl();
    private static final NativeARPACK nativeArpack = InstanceBuilder.getNativeInstanceImpl();
    private static final JavaARPACK javaArpack = InstanceBuilder.getJavaInstanceImpl();

    InstanceBuilder() {
    }

    public static ARPACK getInstance() {
        return arpack;
    }

    private static ARPACK getInstanceImpl() {
        try {
            return NativeARPACK.getInstance();
        }
        catch (Throwable t) {
            log.warning("Failed to load implementation from:" + NativeARPACK.class.getName());
            return JavaARPACK.getInstance();
        }
    }

    public static NativeARPACK getNativeInstance() {
        return nativeArpack;
    }

    private static NativeARPACK getNativeInstanceImpl() {
        try {
            return JNIARPACK.getInstance();
        }
        catch (Throwable t) {
            log.warning("Failed to load implementation from:" + JNIARPACK.class.getName());
            throw new RuntimeException("Unable to load native implementation");
        }
    }

    public static JavaARPACK getJavaInstance() {
        return javaArpack;
    }

    private static JavaARPACK getJavaInstanceImpl() {
        return F2jARPACK.getInstance();
    }
}

