/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.workersai.client;

import dev.langchain4j.model.workersai.client.ApiResponse;
import dev.langchain4j.model.workersai.client.WorkersAiApi;
import dev.langchain4j.model.workersai.client.WorkersAiClient;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkersAIModel {
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkersAIModel.class);
    protected String accountId;
    protected String modelName;
    protected WorkersAiApi workerAiClient;

    public AbstractWorkersAIModel(String accountId, String modelName, String apiToken) {
        if (accountId == null || accountId.isEmpty()) {
            throw new IllegalArgumentException("Account identifier should not be null or empty");
        }
        this.accountId = accountId;
        if (modelName == null || modelName.isEmpty()) {
            throw new IllegalArgumentException("Model name should not be null or empty");
        }
        this.modelName = modelName;
        if (apiToken == null || apiToken.isEmpty()) {
            throw new IllegalArgumentException("Token should not be null or empty");
        }
        this.workerAiClient = WorkersAiClient.createService(apiToken);
    }

    protected void processErrors(ApiResponse<?> res, ResponseBody errors) throws IOException {
        if (res == null || !res.isSuccess()) {
            StringBuilder errorMessage = new StringBuilder("Failed to generate chat message:");
            if (res == null) {
                errorMessage.append(errors.string());
            } else if (res.getErrors() != null) {
                errorMessage.append(res.getErrors().stream().map(ApiResponse.Error::getMessage).reduce((a, b) -> a + "\n" + b).orElse(""));
            }
            log.error(errorMessage.toString());
            throw new RuntimeException(errorMessage.toString());
        }
    }
}

