/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.watsonx;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import java.time.Duration;
import java.util.Map;

public class WatsonxChatRequestParameters
extends DefaultChatRequestParameters {
    public static final WatsonxChatRequestParameters EMPTY = WatsonxChatRequestParameters.builder().build();
    private final String projectId;
    private final String spaceId;
    private final Map<String, Integer> logitBias;
    private final Boolean logprobs;
    private final Integer topLogprobs;
    private final Integer seed;
    private final String toolChoiceName;
    private final Duration timeLimit;

    private WatsonxChatRequestParameters(Builder builder) {
        super((DefaultChatRequestParameters.Builder)builder);
        this.projectId = builder.projectId;
        this.spaceId = builder.spaceId;
        this.logitBias = builder.logitBias;
        this.logprobs = builder.logprobs;
        this.topLogprobs = builder.topLogprobs;
        this.seed = builder.seed;
        this.toolChoiceName = builder.toolChoiceName;
        this.timeLimit = builder.timeLimit;
    }

    public String projectId() {
        return this.projectId;
    }

    public String spaceId() {
        return this.spaceId;
    }

    public Map<String, Integer> logitBias() {
        return this.logitBias;
    }

    public Boolean logprobs() {
        return this.logprobs;
    }

    public Integer topLogprobs() {
        return this.topLogprobs;
    }

    public Integer seed() {
        return this.seed;
    }

    public String toolChoiceName() {
        return this.toolChoiceName;
    }

    public Duration timeLimit() {
        return this.timeLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ChatRequestParameters overrideWith(ChatRequestParameters that) {
        return WatsonxChatRequestParameters.builder().overrideWith((ChatRequestParameters)this).overrideWith(that).build();
    }

    public static class Builder
    extends DefaultChatRequestParameters.Builder<Builder> {
        private String projectId;
        private String spaceId;
        private Map<String, Integer> logitBias;
        private Boolean logprobs;
        private Integer topLogprobs;
        private Integer seed;
        private String toolChoiceName;
        private Duration timeLimit;

        public Builder overrideWith(ChatRequestParameters parameters) {
            super.overrideWith(parameters);
            if (parameters instanceof WatsonxChatRequestParameters) {
                WatsonxChatRequestParameters watsonxParameters = (WatsonxChatRequestParameters)parameters;
                this.projectId((String)Utils.getOrDefault((Object)watsonxParameters.projectId(), (Object)this.projectId));
                this.spaceId((String)Utils.getOrDefault((Object)watsonxParameters.spaceId(), (Object)this.spaceId));
                this.logitBias(Utils.getOrDefault(watsonxParameters.logitBias(), this.logitBias));
                this.logprobs((Boolean)Utils.getOrDefault((Object)watsonxParameters.logprobs(), (Object)this.logprobs));
                this.topLogprobs((Integer)Utils.getOrDefault((Object)watsonxParameters.topLogprobs(), (Object)this.topLogprobs));
                this.seed((Integer)Utils.getOrDefault((Object)watsonxParameters.seed(), (Object)this.seed));
                this.toolChoiceName((String)Utils.getOrDefault((Object)watsonxParameters.toolChoiceName(), (Object)this.toolChoiceName));
                this.timeLimit((Duration)Utils.getOrDefault((Object)watsonxParameters.timeLimit(), (Object)this.timeLimit));
            }
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder toolChoiceName(String toolChoiceName) {
            this.toolChoiceName = toolChoiceName;
            return this;
        }

        public Builder timeLimit(Duration timeLimit) {
            this.timeLimit = timeLimit;
            return this;
        }

        public WatsonxChatRequestParameters build() {
            return new WatsonxChatRequestParameters(this);
        }
    }
}

