/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.vespa;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.vespa.VespaQueryApi;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class VespaQueryClient {
    static final BouncyCastleProvider bcProvider = new BouncyCastleProvider();

    VespaQueryClient() {
    }

    public static VespaQueryApi createInstance(String baseUrl, Path certificate, Path privateKey) {
        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(null);
            keystore.setKeyEntry("cert", VespaQueryClient.privateKey(privateKey), new char[0], VespaQueryClient.certificates(certificate));
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            sslContext.init(VespaQueryClient.createKeyManagers(keystore), null, null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keystore);
            OkHttpClient client = new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagerFactory.getTrustManagers()[0]).addInterceptor(chain -> {
                Request request = chain.request();
                HttpUrl url = request.url().newBuilder().removePathSegment(1).addPathSegment("").encodedQuery((String)request.url().encodedPathSegments().get(1)).build();
                request = request.newBuilder().url(url).build();
                return chain.proceed(request);
            }).build();
            Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)baseUrl)).client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new GsonBuilder().create())).build();
            return (VespaQueryApi)retrofit.create(VespaQueryApi.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyManager[] createKeyManagers(KeyStore keystore) throws GeneralSecurityException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keystore, new char[0]);
        return kmf.getKeyManagers();
    }

    private static Certificate[] certificates(Path file) throws IOException, GeneralSecurityException {
        try (PEMParser parser = new PEMParser((Reader)Files.newBufferedReader(file));){
            Object pemObject;
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            while ((pemObject = parser.readObject()) != null) {
                result.add(VespaQueryClient.toX509Certificate(pemObject));
            }
            if (result.isEmpty()) {
                throw new IOException("File contains no PEM encoded certificates: " + String.valueOf(file));
            }
            Certificate[] certificateArray = result.toArray(new Certificate[0]);
            return certificateArray;
        }
    }

    private static PrivateKey privateKey(Path file) throws IOException, GeneralSecurityException {
        try (PEMParser parser = new PEMParser((Reader)Files.newBufferedReader(file));){
            Object pemObject;
            while ((pemObject = parser.readObject()) != null) {
                if (pemObject instanceof PrivateKeyInfo) {
                    PrivateKeyInfo keyInfo = (PrivateKeyInfo)pemObject;
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyInfo.getEncoded());
                    PrivateKey privateKey = VespaQueryClient.createKeyFactory(keyInfo).generatePrivate(keySpec);
                    return privateKey;
                }
                if (!(pemObject instanceof PEMKeyPair)) continue;
                PEMKeyPair pemKeypair = (PEMKeyPair)pemObject;
                PrivateKeyInfo keyInfo = pemKeypair.getPrivateKeyInfo();
                PrivateKey privateKey = VespaQueryClient.createKeyFactory(keyInfo).generatePrivate(new PKCS8EncodedKeySpec(keyInfo.getEncoded()));
                return privateKey;
            }
            throw new IOException("Could not find private key in PEM file");
        }
    }

    private static X509Certificate toX509Certificate(Object pemObject) throws IOException, GeneralSecurityException {
        if (pemObject instanceof X509Certificate) {
            return (X509Certificate)pemObject;
        }
        if (pemObject instanceof X509CertificateHolder) {
            return new JcaX509CertificateConverter().setProvider((Provider)bcProvider).getCertificate((X509CertificateHolder)pemObject);
        }
        throw new IOException("Invalid type of PEM object: " + String.valueOf(pemObject));
    }

    private static KeyFactory createKeyFactory(PrivateKeyInfo info) throws IOException, GeneralSecurityException {
        ASN1ObjectIdentifier algorithm = info.getPrivateKeyAlgorithm().getAlgorithm();
        if (X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)algorithm)) {
            return KeyFactory.getInstance("EC", (Provider)bcProvider);
        }
        if (PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)algorithm)) {
            return KeyFactory.getInstance("RSA", (Provider)bcProvider);
        }
        throw new IOException("Unknown key algorithm: " + String.valueOf(algorithm));
    }
}

