/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.spring;

import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.service.spring.AiService;
import dev.langchain4j.service.spring.AiServiceFactory;
import dev.langchain4j.service.spring.AiServiceWiringMode;
import dev.langchain4j.service.spring.event.AiServiceRegisteredEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Bean;

public class AiServicesAutoConfig
implements ApplicationEventPublisherAware {
    private static final Logger log = LoggerFactory.getLogger(AiServicesAutoConfig.class);
    private ApplicationEventPublisher eventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Bean
    BeanFactoryPostProcessor aiServicesRegisteringBeanFactoryPostProcessor() {
        return beanFactory -> {
            String[] aiServices;
            String[] chatLanguageModels = beanFactory.getBeanNamesForType(ChatLanguageModel.class);
            String[] streamingChatLanguageModels = beanFactory.getBeanNamesForType(StreamingChatLanguageModel.class);
            String[] chatMemories = beanFactory.getBeanNamesForType(ChatMemory.class);
            String[] chatMemoryProviders = beanFactory.getBeanNamesForType(ChatMemoryProvider.class);
            String[] contentRetrievers = beanFactory.getBeanNamesForType(ContentRetriever.class);
            String[] retrievalAugmentors = beanFactory.getBeanNamesForType(RetrievalAugmentor.class);
            String[] moderationModels = beanFactory.getBeanNamesForType(ModerationModel.class);
            HashSet<String> toolBeanNames = new HashSet<String>();
            ArrayList<ToolSpecification> toolSpecifications = new ArrayList<ToolSpecification>();
            for (String beanName : beanFactory.getBeanDefinitionNames()) {
                try {
                    String beanClassName = beanFactory.getBeanDefinition(beanName).getBeanClassName();
                    if (beanClassName == null) continue;
                    Class<?> beanClass = Class.forName(beanClassName);
                    for (Method beanMethod : beanClass.getDeclaredMethods()) {
                        if (!beanMethod.isAnnotationPresent(Tool.class)) continue;
                        toolBeanNames.add(beanName);
                        try {
                            toolSpecifications.add(ToolSpecifications.toolSpecificationFrom((Method)beanMethod));
                        }
                        catch (Exception e) {
                            log.warn("Cannot convert %s.%s method annotated with @Tool into ToolSpecification".formatted(beanClass.getName(), beanMethod.getName()), (Throwable)e);
                        }
                    }
                }
                catch (Exception beanClassName) {
                    // empty catch block
                }
            }
            for (String aiService : aiServices = beanFactory.getBeanNamesForAnnotation(AiService.class)) {
                Class aiServiceClass = beanFactory.getType(aiService);
                GenericBeanDefinition aiServiceBeanDefinition = new GenericBeanDefinition();
                aiServiceBeanDefinition.setBeanClass(AiServiceFactory.class);
                aiServiceBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)aiServiceClass);
                MutablePropertyValues propertyValues = aiServiceBeanDefinition.getPropertyValues();
                AiService aiServiceAnnotation = aiServiceClass.getAnnotation(AiService.class);
                AiServicesAutoConfig.addBeanReference(ChatLanguageModel.class, aiServiceAnnotation, aiServiceAnnotation.chatModel(), chatLanguageModels, "chatModel", "chatLanguageModel", propertyValues);
                AiServicesAutoConfig.addBeanReference(StreamingChatLanguageModel.class, aiServiceAnnotation, aiServiceAnnotation.streamingChatModel(), streamingChatLanguageModels, "streamingChatModel", "streamingChatLanguageModel", propertyValues);
                AiServicesAutoConfig.addBeanReference(ChatMemory.class, aiServiceAnnotation, aiServiceAnnotation.chatMemory(), chatMemories, "chatMemory", "chatMemory", propertyValues);
                AiServicesAutoConfig.addBeanReference(ChatMemoryProvider.class, aiServiceAnnotation, aiServiceAnnotation.chatMemoryProvider(), chatMemoryProviders, "chatMemoryProvider", "chatMemoryProvider", propertyValues);
                AiServicesAutoConfig.addBeanReference(ContentRetriever.class, aiServiceAnnotation, aiServiceAnnotation.contentRetriever(), contentRetrievers, "contentRetriever", "contentRetriever", propertyValues);
                AiServicesAutoConfig.addBeanReference(RetrievalAugmentor.class, aiServiceAnnotation, aiServiceAnnotation.retrievalAugmentor(), retrievalAugmentors, "retrievalAugmentor", "retrievalAugmentor", propertyValues);
                AiServicesAutoConfig.addBeanReference(ModerationModel.class, aiServiceAnnotation, aiServiceAnnotation.moderationModel(), moderationModels, "moderationModel", "moderationModel", propertyValues);
                if (aiServiceAnnotation.wiringMode() == AiServiceWiringMode.EXPLICIT) {
                    propertyValues.add("tools", AiServicesAutoConfig.toManagedList(Arrays.asList(aiServiceAnnotation.tools())));
                } else if (aiServiceAnnotation.wiringMode() == AiServiceWiringMode.AUTOMATIC) {
                    propertyValues.add("tools", AiServicesAutoConfig.toManagedList(toolBeanNames));
                } else {
                    throw Exceptions.illegalArgument((String)("Unknown wiring mode: " + aiServiceAnnotation.wiringMode()), (Object[])new Object[0]);
                }
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                registry.removeBeanDefinition(aiService);
                registry.registerBeanDefinition(AiServicesAutoConfig.lowercaseFirstLetter(aiService), (BeanDefinition)aiServiceBeanDefinition);
                if (this.eventPublisher == null) continue;
                this.eventPublisher.publishEvent((ApplicationEvent)new AiServiceRegisteredEvent(this, aiServiceClass, toolSpecifications));
            }
        };
    }

    private static void addBeanReference(Class<?> beanType, AiService aiServiceAnnotation, String customBeanName, String[] beanNames, String annotationAttributeName, String factoryPropertyName, MutablePropertyValues propertyValues) {
        if (aiServiceAnnotation.wiringMode() == AiServiceWiringMode.EXPLICIT) {
            if (Utils.isNotNullOrBlank((String)customBeanName)) {
                propertyValues.add(factoryPropertyName, (Object)new RuntimeBeanReference(customBeanName));
            }
        } else if (aiServiceAnnotation.wiringMode() == AiServiceWiringMode.AUTOMATIC) {
            if (beanNames.length == 1) {
                propertyValues.add(factoryPropertyName, (Object)new RuntimeBeanReference(beanNames[0]));
            } else if (beanNames.length > 1) {
                throw AiServicesAutoConfig.conflict(beanType, beanNames, annotationAttributeName);
            }
        } else {
            throw Exceptions.illegalArgument((String)("Unknown wiring mode: " + aiServiceAnnotation.wiringMode()), (Object[])new Object[0]);
        }
    }

    private static IllegalConfigurationException conflict(Class<?> beanType, Object[] beanNames, String attributeName) {
        return IllegalConfigurationException.illegalConfiguration((String)"Conflict: multiple beans of type %s are found: %s. Please specify which one you wish to wire in the @AiService annotation like this: @AiService(wiringMode = EXPLICIT, %s = \"<beanName>\").", (Object[])new Object[]{beanType.getName(), Arrays.toString(beanNames), attributeName});
    }

    private static String lowercaseFirstLetter(String text) {
        if (Utils.isNullOrBlank((String)text)) {
            return text;
        }
        return text.substring(0, 1).toLowerCase() + text.substring(1);
    }

    private static ManagedList<RuntimeBeanReference> toManagedList(Collection<String> beanNames) {
        ManagedList managedList = new ManagedList();
        for (String beanName : beanNames) {
            managedList.add((Object)new RuntimeBeanReference(beanName));
        }
        return managedList;
    }
}

