/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai.internal;

import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.model.openai.internal.ErrorHandling;
import dev.langchain4j.model.openai.internal.Json;
import dev.langchain4j.model.openai.internal.ParsedAndRawResponse;
import dev.langchain4j.model.openai.internal.ResponseHandle;
import dev.langchain4j.model.openai.internal.StreamingCompletionHandling;
import dev.langchain4j.model.openai.internal.StreamingResponseHandling;
import java.util.function.Consumer;

class StreamingRequestExecutor<Response> {
    private final HttpClient httpClient;
    private final HttpRequest streamingHttpRequest;
    private final Class<Response> responseClass;

    StreamingRequestExecutor(HttpClient httpClient, HttpRequest streamingHttpRequest, Class<Response> responseClass) {
        this.httpClient = httpClient;
        this.streamingHttpRequest = streamingHttpRequest;
        this.responseClass = responseClass;
    }

    StreamingResponseHandling onPartialResponse(final Consumer<ParsedAndRawResponse<Response>> partialResponseHandler) {
        return new StreamingResponseHandling(){
            final /* synthetic */ StreamingRequestExecutor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public StreamingCompletionHandling onComplete(final Runnable streamingCompletionCallback) {
                return new StreamingCompletionHandling(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public ErrorHandling onError(final Consumer<Throwable> errorHandler) {
                        return new ErrorHandling(){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public ResponseHandle execute() {
                                return this.this$2.this$1.this$0.stream(partialResponseHandler, streamingCompletionCallback, errorHandler);
                            }
                        };
                    }

                    @Override
                    public ErrorHandling ignoreErrors() {
                        return new ErrorHandling(){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public ResponseHandle execute() {
                                return this.this$2.this$1.this$0.stream(partialResponseHandler, streamingCompletionCallback, e -> {});
                            }
                        };
                    }
                };
            }

            @Override
            public ErrorHandling onError(final Consumer<Throwable> errorHandler) {
                return new ErrorHandling(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public ResponseHandle execute() {
                        return this.this$1.this$0.stream(partialResponseHandler, () -> {}, errorHandler);
                    }
                };
            }

            @Override
            public ErrorHandling ignoreErrors() {
                return new ErrorHandling(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public ResponseHandle execute() {
                        return this.this$1.this$0.stream(partialResponseHandler, () -> {}, e -> {});
                    }
                };
            }
        };
    }

    private ResponseHandle stream(final Consumer<ParsedAndRawResponse<Response>> partialResponseHandler, final Runnable streamingCompletionCallback, final Consumer<Throwable> errorHandler) {
        ServerSentEventListener listener = new ServerSentEventListener(){
            SuccessfulHttpResponse response;
            final /* synthetic */ StreamingRequestExecutor this$0;
            {
                this.this$0 = this$0;
            }

            public void onOpen(SuccessfulHttpResponse response) {
                this.response = response;
            }

            public void onEvent(ServerSentEvent event) {
                if ("[DONE]".equals(event.data())) {
                    return;
                }
                try {
                    if ("error".equals(event.event())) {
                        errorHandler.accept(new RuntimeException(event.data()));
                        return;
                    }
                    Object parsedResponse = Json.fromJson(event.data(), this.this$0.responseClass);
                    if (parsedResponse != null) {
                        partialResponseHandler.accept(new ParsedAndRawResponse(parsedResponse, this.response, event));
                    }
                }
                catch (Exception e) {
                    errorHandler.accept(e);
                }
            }

            public void onClose() {
                streamingCompletionCallback.run();
            }

            public void onError(Throwable t) {
                errorHandler.accept(t);
            }
        };
        this.httpClient.execute(this.streamingHttpRequest, listener);
        return new ResponseHandle();
    }
}

