/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openaiofficial;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.AuthenticationUtil;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.openai.azure.AzureOpenAIServiceVersion;
import com.openai.azure.credential.AzureApiKeyCredential;
import com.openai.client.OpenAIClient;
import com.openai.client.OpenAIClientAsync;
import com.openai.client.okhttp.OpenAIOkHttpClient;
import com.openai.client.okhttp.OpenAIOkHttpClientAsync;
import com.openai.core.JsonValue;
import com.openai.credential.BearerTokenCredential;
import com.openai.credential.Credential;
import com.openai.models.FunctionDefinition;
import com.openai.models.FunctionParameters;
import com.openai.models.ReasoningEffort;
import com.openai.models.ResponseFormatJsonObject;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionAssistantMessageParam;
import com.openai.models.chat.completions.ChatCompletionChunk;
import com.openai.models.chat.completions.ChatCompletionContentPart;
import com.openai.models.chat.completions.ChatCompletionContentPartImage;
import com.openai.models.chat.completions.ChatCompletionContentPartInputAudio;
import com.openai.models.chat.completions.ChatCompletionContentPartText;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.models.chat.completions.ChatCompletionMessage;
import com.openai.models.chat.completions.ChatCompletionMessageParam;
import com.openai.models.chat.completions.ChatCompletionMessageToolCall;
import com.openai.models.chat.completions.ChatCompletionSystemMessageParam;
import com.openai.models.chat.completions.ChatCompletionTool;
import com.openai.models.chat.completions.ChatCompletionToolChoiceOption;
import com.openai.models.chat.completions.ChatCompletionToolMessageParam;
import com.openai.models.chat.completions.ChatCompletionUserMessageParam;
import com.openai.models.completions.CompletionUsage;
import com.openai.models.embeddings.CreateEmbeddingResponse;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonSchemaElementHelper;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.openaiofficial.OpenAiOfficialChatRequestParameters;
import dev.langchain4j.model.openaiofficial.OpenAiOfficialTokenUsage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class InternalOpenAiOfficialHelper {
    static final String OPENAI_URL = "https://api.openai.com/v1";
    static final String GITHUB_MODELS_URL = "https://models.inference.ai.azure.com";
    static final String GITHUB_TOKEN = "GITHUB_TOKEN";
    static final String DEFAULT_USER_AGENT = "langchain4j-openai-official";

    InternalOpenAiOfficialHelper() {
    }

    static ModelHost detectModelHost(boolean isAzure, boolean isGitHubModels, String baseUrl, String azureDeploymentName, AzureOpenAIServiceVersion azureOpenAIServiceVersion) {
        if (isAzure) {
            return ModelHost.AZURE_OPENAI;
        }
        if (isGitHubModels) {
            return ModelHost.GITHUB_MODELS;
        }
        if (baseUrl != null) {
            if (baseUrl.endsWith("openai.azure.com") || baseUrl.endsWith("openai.azure.com/")) {
                return ModelHost.AZURE_OPENAI;
            }
            if (baseUrl.startsWith(GITHUB_MODELS_URL)) {
                return ModelHost.GITHUB_MODELS;
            }
        }
        if (azureDeploymentName != null || azureOpenAIServiceVersion != null) {
            return ModelHost.AZURE_OPENAI;
        }
        return ModelHost.OPENAI;
    }

    static OpenAIClient setupSyncClient(String baseUrl, String apiKey, Credential credential, String azureDeploymentName, AzureOpenAIServiceVersion azureOpenAiServiceVersion, String organizationId, ModelHost modelHost, OpenAIClient openAIClient, String modelName, Duration timeout, Integer maxRetries, Proxy proxy, Map<String, String> customHeaders) {
        if (openAIClient != null) {
            return openAIClient;
        }
        OpenAIOkHttpClient.Builder builder = OpenAIOkHttpClient.builder();
        builder.baseUrl(InternalOpenAiOfficialHelper.calculateBaseUrl(baseUrl, modelHost, modelName, azureDeploymentName, azureOpenAiServiceVersion));
        Credential calculatedCredential = InternalOpenAiOfficialHelper.calculateCredential(modelHost, apiKey, credential);
        String calculatedApiKey = InternalOpenAiOfficialHelper.calculateApiKey(modelHost, apiKey);
        if (calculatedCredential == null && calculatedApiKey == null) {
            throw new IllegalArgumentException("Either apiKey or credential must be set to authenticate");
        }
        if (calculatedCredential != null) {
            builder.credential(calculatedCredential);
        } else {
            builder.apiKey(calculatedApiKey);
        }
        builder.organization(organizationId);
        if (azureOpenAiServiceVersion != null) {
            builder.azureServiceVersion(azureOpenAiServiceVersion);
        }
        if (proxy != null) {
            builder.proxy(proxy);
        }
        builder.putHeader("User-Agent", DEFAULT_USER_AGENT);
        if (customHeaders != null) {
            builder.putAllHeaders(customHeaders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList((String)entry.getValue()))));
        }
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        builder.timeout(timeout);
        builder.maxRetries(((Integer)Utils.getOrDefault((Object)maxRetries, (Object)3)).intValue());
        return builder.build();
    }

    static OpenAIClientAsync setupASyncClient(String baseUrl, String apiKey, Credential credential, String azureDeploymentName, AzureOpenAIServiceVersion azureOpenAiServiceVersion, ModelHost modelHost, OpenAIClientAsync openAIClientAsync, String organizationId, String modelName, Duration timeout, Integer maxRetries, Proxy proxy, Map<String, String> customHeaders) {
        if (openAIClientAsync != null) {
            return openAIClientAsync;
        }
        OpenAIOkHttpClientAsync.Builder builder = OpenAIOkHttpClientAsync.builder();
        builder.baseUrl(InternalOpenAiOfficialHelper.calculateBaseUrl(baseUrl, modelHost, modelName, azureDeploymentName, azureOpenAiServiceVersion));
        Credential calculatedCredential = InternalOpenAiOfficialHelper.calculateCredential(modelHost, apiKey, credential);
        String calculatedApiKey = InternalOpenAiOfficialHelper.calculateApiKey(modelHost, apiKey);
        if (calculatedCredential == null && calculatedApiKey == null) {
            throw new IllegalArgumentException("Either apiKey or credential must be set to authenticate");
        }
        if (calculatedCredential != null) {
            builder.credential(calculatedCredential);
        } else {
            builder.apiKey(calculatedApiKey);
        }
        builder.organization(organizationId);
        if (azureOpenAiServiceVersion != null) {
            builder.azureServiceVersion(azureOpenAiServiceVersion);
        }
        if (proxy != null) {
            builder.proxy(proxy);
        }
        builder.putHeader("User-Agent", DEFAULT_USER_AGENT);
        if (customHeaders != null) {
            builder.putAllHeaders(customHeaders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList((String)entry.getValue()))));
        }
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        builder.timeout(timeout);
        builder.maxRetries(((Integer)Utils.getOrDefault((Object)maxRetries, (Object)3)).intValue());
        return builder.build();
    }

    private static String calculateBaseUrl(String baseUrl, ModelHost modelHost, String modelName, String azureDeploymentName, AzureOpenAIServiceVersion azureOpenAiServiceVersion) {
        if (modelHost == ModelHost.OPENAI) {
            return (String)Utils.getOrDefault((Object)baseUrl, (Object)OPENAI_URL);
        }
        if (modelHost == ModelHost.GITHUB_MODELS) {
            return GITHUB_MODELS_URL;
        }
        if (modelHost == ModelHost.AZURE_OPENAI) {
            String tmpUrl;
            if (azureDeploymentName == null) {
                azureDeploymentName = modelName;
            }
            ValidationUtils.ensureNotBlank((String)azureDeploymentName, (String)"azureDeploymentName");
            String string = tmpUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
            if (azureOpenAiServiceVersion == null) {
                azureOpenAiServiceVersion = AzureOpenAIServiceVersion.latestStableVersion();
            }
            return tmpUrl + "/openai/deployments/" + azureDeploymentName + "?api-version=" + azureOpenAiServiceVersion.value();
        }
        throw new IllegalArgumentException("Unknown model host: " + String.valueOf((Object)modelHost));
    }

    private static Credential calculateCredential(ModelHost modelHost, String apiKey, Credential credential) {
        if (apiKey != null) {
            if (modelHost == ModelHost.AZURE_OPENAI) {
                return AzureApiKeyCredential.create((String)apiKey);
            }
        } else {
            if (credential != null) {
                return credential;
            }
            if (modelHost == ModelHost.AZURE_OPENAI) {
                try {
                    return BearerTokenCredential.create((Supplier)AuthenticationUtil.getBearerTokenSupplier((TokenCredential)new DefaultAzureCredentialBuilder().build(), (String[])new String[]{"https://cognitiveservices.azure.com/.default"}));
                }
                catch (NoClassDefFoundError e) {
                    throw new IllegalArgumentException("Azure OpenAI was detected, but no credential was provided. If you want to use passwordless authentication, you need to add the Azure Identity library (groupId=`com.azure`, artifactId=`azure-identity`) to your classpath.");
                }
            }
        }
        return null;
    }

    private static String calculateApiKey(ModelHost modelHost, String apiKey) {
        if (modelHost != ModelHost.AZURE_OPENAI && apiKey != null) {
            return apiKey;
        }
        if (modelHost == ModelHost.GITHUB_MODELS && System.getenv(GITHUB_TOKEN) != null) {
            return System.getenv(GITHUB_TOKEN);
        }
        return null;
    }

    static List<ChatCompletionMessageParam> toOpenAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(InternalOpenAiOfficialHelper::toOpenAiMessage).collect(Collectors.toList());
    }

    static ChatCompletionMessageParam toOpenAiMessage(ChatMessage message) {
        if (message instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)message;
            return ChatCompletionMessageParam.ofSystem((ChatCompletionSystemMessageParam)ChatCompletionSystemMessageParam.builder().content(systemMessage.text()).build());
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            ChatCompletionUserMessageParam.Builder builder = ChatCompletionUserMessageParam.builder();
            if (userMessage.hasSingleText()) {
                builder.content(userMessage.singleText());
            } else {
                builder.contentOfArrayOfContentParts(InternalOpenAiOfficialHelper.toOpenAiContent(userMessage.contents()));
            }
            if (userMessage.name() != null) {
                builder.name(userMessage.name());
            }
            return ChatCompletionMessageParam.ofUser((ChatCompletionUserMessageParam)builder.build());
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return ChatCompletionMessageParam.ofAssistant((ChatCompletionAssistantMessageParam)ChatCompletionAssistantMessageParam.builder().content(aiMessage.text()).build());
            }
            List toolCalls = aiMessage.toolExecutionRequests().stream().map(it -> ChatCompletionMessageToolCall.builder().id(it.id()).function(ChatCompletionMessageToolCall.Function.builder().name(it.name()).arguments(it.arguments()).build()).build()).collect(Collectors.toList());
            return ChatCompletionMessageParam.ofAssistant((ChatCompletionAssistantMessageParam)ChatCompletionAssistantMessageParam.builder().content(aiMessage.text() != null ? aiMessage.text() : "").toolCalls(toolCalls).build());
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)message;
            return ChatCompletionMessageParam.ofTool((ChatCompletionToolMessageParam)ChatCompletionToolMessageParam.builder().toolCallId(toolExecutionResultMessage.id()).content(toolExecutionResultMessage.text()).build());
        }
        throw Exceptions.illegalArgument((String)("Unknown message type: " + String.valueOf(message.type())), (Object[])new Object[0]);
    }

    private static List<ChatCompletionContentPart> toOpenAiContent(List<Content> contents) {
        ArrayList<ChatCompletionContentPart> parts = new ArrayList<ChatCompletionContentPart>();
        for (Content content : contents) {
            if (content instanceof TextContent) {
                TextContent textContent = (TextContent)content;
                parts.add(ChatCompletionContentPart.ofText((ChatCompletionContentPartText)ChatCompletionContentPartText.builder().text(textContent.text()).build()));
                continue;
            }
            if (content instanceof ImageContent) {
                ImageContent imageContent = (ImageContent)content;
                ChatCompletionContentPartImage.ImageUrl.Builder imageUrlBuilder = ChatCompletionContentPartImage.ImageUrl.builder();
                if (imageContent.image().url() != null) {
                    imageUrlBuilder.url(imageContent.image().url().toString());
                    parts.add(ChatCompletionContentPart.ofImageUrl((ChatCompletionContentPartImage)ChatCompletionContentPartImage.builder().imageUrl(imageUrlBuilder.build()).build()));
                    continue;
                }
                if (imageContent.image().base64Data() != null) {
                    imageUrlBuilder.url("data:" + imageContent.image().mimeType() + ";base64," + imageContent.image().base64Data());
                    parts.add(ChatCompletionContentPart.ofImageUrl((ChatCompletionContentPartImage)ChatCompletionContentPartImage.builder().imageUrl(imageUrlBuilder.build()).build()));
                    continue;
                }
                throw new UnsupportedFeatureException("Image URL is not present.");
            }
            if (content instanceof AudioContent) {
                AudioContent audioContent = (AudioContent)content;
                parts.add(ChatCompletionContentPart.ofInputAudio((ChatCompletionContentPartInputAudio)ChatCompletionContentPartInputAudio.builder().inputAudio(ChatCompletionContentPartInputAudio.builder().inputAudio(ChatCompletionContentPartInputAudio.InputAudio.builder().data(ValidationUtils.ensureNotBlank((String)audioContent.audio().base64Data(), (String)"audio.base64Data")).build()).build().inputAudio()).build()));
                continue;
            }
            throw Exceptions.illegalArgument((String)("Unknown content type: " + String.valueOf(content)), (Object[])new Object[0]);
        }
        return parts;
    }

    static List<ChatCompletionTool> toTools(Collection<ToolSpecification> toolSpecifications, boolean strict) {
        if (toolSpecifications == null) {
            return null;
        }
        return toolSpecifications.stream().map(toolSpecification -> InternalOpenAiOfficialHelper.toTool(toolSpecification, strict)).collect(Collectors.toList());
    }

    private static ChatCompletionTool toTool(ToolSpecification toolSpecification, boolean strict) {
        FunctionDefinition.Builder functionDefinitionBuilder = FunctionDefinition.builder().name(toolSpecification.name()).description(toolSpecification.description() != null ? toolSpecification.description() : "").parameters(InternalOpenAiOfficialHelper.toOpenAiParameters(toolSpecification, strict));
        if (strict) {
            functionDefinitionBuilder.strict(true);
        }
        return ChatCompletionTool.builder().function(functionDefinitionBuilder.build()).build();
    }

    private static FunctionParameters toOpenAiParameters(ToolSpecification toolSpecification, boolean strict) {
        FunctionParameters.Builder parametersBuilder = FunctionParameters.builder();
        JsonObjectSchema parameters = toolSpecification.parameters();
        parametersBuilder.putAdditionalProperty("type", JsonValue.from((Object)"object"));
        if (parameters != null) {
            parametersBuilder.putAdditionalProperty("properties", JsonValue.from((Object)JsonSchemaElementHelper.toMap((Map)parameters.properties(), (boolean)strict)));
            if (strict) {
                parametersBuilder.putAdditionalProperty("required", JsonValue.from(new ArrayList(parameters.properties().keySet())));
                parametersBuilder.putAdditionalProperty("additionalProperties", JsonValue.from((Object)false));
            } else {
                parametersBuilder.putAdditionalProperty("required", JsonValue.from((Object)parameters.required()));
            }
            if (parameters.definitions() != null) {
                parametersBuilder.putAdditionalProperty("$defs", JsonValue.from((Object)JsonSchemaElementHelper.toMap((Map)parameters.definitions(), (boolean)strict)));
            }
            return parametersBuilder.build();
        }
        parametersBuilder.putAdditionalProperty("properties", JsonValue.from((Object)JsonSchemaElementHelper.toMap(new HashMap(), (boolean)strict)));
        if (strict) {
            parametersBuilder.putAdditionalProperty("additionalProperties", JsonValue.from((Object)false));
        }
        return parametersBuilder.build();
    }

    static AiMessage aiMessageFrom(ChatCompletion chatCompletion) {
        ChatCompletionMessage assistantMessage = ((ChatCompletion.Choice)chatCompletion.choices().get(0)).message();
        Optional text = assistantMessage.content();
        Optional toolCalls = assistantMessage.toolCalls();
        if (toolCalls.isPresent()) {
            List toolExecutionRequests = ((List)toolCalls.get()).stream().map(InternalOpenAiOfficialHelper::toToolExecutionRequest).collect(Collectors.toList());
            if (text.isEmpty()) {
                return AiMessage.from(toolExecutionRequests);
            }
            if (toolExecutionRequests.isEmpty()) {
                return AiMessage.from((String)((String)text.get()));
            }
            return AiMessage.from((String)((String)text.get()), toolExecutionRequests);
        }
        return AiMessage.from((String)text.orElse(""));
    }

    private static ToolExecutionRequest toToolExecutionRequest(ChatCompletionMessageToolCall toolCall) {
        ChatCompletionMessageToolCall.Function function = toolCall.function();
        return ToolExecutionRequest.builder().id(toolCall.id()).name(function.name()).arguments(function.arguments()).build();
    }

    static OpenAiOfficialTokenUsage tokenUsageFrom(CreateEmbeddingResponse.Usage openAiUsage) {
        return OpenAiOfficialTokenUsage.builder().inputTokenCount(openAiUsage.promptTokens()).totalTokenCount(openAiUsage.totalTokens()).build();
    }

    static OpenAiOfficialTokenUsage tokenUsageFrom(CompletionUsage openAiUsage) {
        Optional promptTokensDetails = openAiUsage.promptTokensDetails();
        OpenAiOfficialTokenUsage.InputTokensDetails inputTokensDetails = null;
        if (promptTokensDetails.isPresent() && ((CompletionUsage.PromptTokensDetails)promptTokensDetails.get()).cachedTokens().isPresent()) {
            inputTokensDetails = new OpenAiOfficialTokenUsage.InputTokensDetails((Long)((CompletionUsage.PromptTokensDetails)promptTokensDetails.get()).cachedTokens().get());
        }
        Optional completionTokensDetails = openAiUsage.completionTokensDetails();
        OpenAiOfficialTokenUsage.OutputTokensDetails outputTokensDetails = null;
        if (completionTokensDetails.isPresent() && ((CompletionUsage.CompletionTokensDetails)completionTokensDetails.get()).reasoningTokens().isPresent()) {
            outputTokensDetails = new OpenAiOfficialTokenUsage.OutputTokensDetails((Long)((CompletionUsage.CompletionTokensDetails)completionTokensDetails.get()).reasoningTokens().get());
        }
        return OpenAiOfficialTokenUsage.builder().inputTokenCount(openAiUsage.promptTokens()).inputTokensDetails(inputTokensDetails).outputTokenCount(openAiUsage.completionTokens()).outputTokensDetails(outputTokensDetails).totalTokenCount(openAiUsage.totalTokens()).build();
    }

    static FinishReason finishReasonFrom(ChatCompletion.Choice.FinishReason openAiFinishReason) {
        if (openAiFinishReason == null) {
            return null;
        }
        if (openAiFinishReason.equals((Object)ChatCompletion.Choice.FinishReason.STOP)) {
            return FinishReason.STOP;
        }
        if (openAiFinishReason.equals((Object)ChatCompletion.Choice.FinishReason.LENGTH)) {
            return FinishReason.LENGTH;
        }
        if (openAiFinishReason.equals((Object)ChatCompletion.Choice.FinishReason.TOOL_CALLS)) {
            return FinishReason.TOOL_EXECUTION;
        }
        if (openAiFinishReason.equals((Object)ChatCompletion.Choice.FinishReason.FUNCTION_CALL)) {
            return FinishReason.TOOL_EXECUTION;
        }
        if (openAiFinishReason.equals((Object)ChatCompletion.Choice.FinishReason.CONTENT_FILTER)) {
            return FinishReason.CONTENT_FILTER;
        }
        return null;
    }

    static FinishReason finishReasonFrom(ChatCompletionChunk.Choice.FinishReason openAiFinishReason) {
        if (openAiFinishReason == null) {
            return null;
        }
        if (openAiFinishReason.equals((Object)ChatCompletionChunk.Choice.FinishReason.STOP)) {
            return FinishReason.STOP;
        }
        if (openAiFinishReason.equals((Object)ChatCompletionChunk.Choice.FinishReason.LENGTH)) {
            return FinishReason.LENGTH;
        }
        if (openAiFinishReason.equals((Object)ChatCompletionChunk.Choice.FinishReason.TOOL_CALLS)) {
            return FinishReason.TOOL_EXECUTION;
        }
        if (openAiFinishReason.equals((Object)ChatCompletionChunk.Choice.FinishReason.FUNCTION_CALL)) {
            return FinishReason.TOOL_EXECUTION;
        }
        if (openAiFinishReason.equals((Object)ChatCompletionChunk.Choice.FinishReason.CONTENT_FILTER)) {
            return FinishReason.CONTENT_FILTER;
        }
        return null;
    }

    static ResponseFormatJsonObject toOpenAiResponseFormat(ResponseFormat responseFormat, Boolean strict) {
        if (responseFormat == null || responseFormat.type() == ResponseFormatType.TEXT) {
            return null;
        }
        JsonSchema jsonSchema = responseFormat.jsonSchema();
        if (jsonSchema == null) {
            return ResponseFormatJsonObject.builder().type(JsonValue.from((Object)"json_object")).build();
        }
        if (!(jsonSchema.rootElement() instanceof JsonObjectSchema)) {
            throw new IllegalArgumentException("For OpenAI, the root element of the JSON Schema must be a JsonObjectSchema, but it was: " + String.valueOf(jsonSchema.rootElement().getClass()));
        }
        HashMap<String, JsonValue> properties = new HashMap<String, JsonValue>();
        properties.put("name", JsonValue.from((Object)jsonSchema.name()));
        properties.put("strict", strict != false ? JsonValue.from((Object)true) : JsonValue.from((Object)false));
        properties.put("schema", JsonValue.from((Object)JsonSchemaElementHelper.toMap((JsonSchemaElement)jsonSchema.rootElement(), (boolean)strict)));
        return ResponseFormatJsonObject.builder().type(JsonValue.from((Object)"json_schema")).putAllAdditionalProperties(Map.of("json_schema", JsonValue.from(properties))).build();
    }

    static ChatCompletionToolChoiceOption toOpenAiToolChoice(ToolChoice toolChoice) {
        if (toolChoice == null) {
            return null;
        }
        return switch (toolChoice) {
            default -> throw new IncompatibleClassChangeError();
            case ToolChoice.AUTO -> ChatCompletionToolChoiceOption.ofAuto((ChatCompletionToolChoiceOption.Auto)ChatCompletionToolChoiceOption.Auto.AUTO);
            case ToolChoice.REQUIRED -> ChatCompletionToolChoiceOption.ofAuto((ChatCompletionToolChoiceOption.Auto)ChatCompletionToolChoiceOption.Auto.REQUIRED);
        };
    }

    static Response<AiMessage> convertResponse(ChatResponse chatResponse) {
        return Response.from((Object)chatResponse.aiMessage(), (TokenUsage)chatResponse.metadata().tokenUsage(), (FinishReason)chatResponse.metadata().finishReason());
    }

    static StreamingChatResponseHandler convertHandler(final StreamingResponseHandler<AiMessage> handler) {
        return new StreamingChatResponseHandler(){

            public void onPartialResponse(String partialResponse) {
                handler.onNext(partialResponse);
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                handler.onComplete(InternalOpenAiOfficialHelper.convertResponse(completeResponse));
            }

            public void onError(Throwable error) {
                handler.onError(error);
            }
        };
    }

    static void validate(ChatRequestParameters parameters) {
        if (parameters.topK() != null) {
            throw new UnsupportedFeatureException("'topK' parameter is not supported by OpenAI");
        }
    }

    static ResponseFormat fromOpenAiResponseFormat(String responseFormat) {
        if ("json_object".equals(responseFormat)) {
            return ResponseFormat.JSON;
        }
        return null;
    }

    static ChatCompletionCreateParams.Builder toOpenAiChatCompletionCreateParams(ChatRequest chatRequest, OpenAiOfficialChatRequestParameters parameters, Boolean strictTools, Boolean strictJsonSchema) {
        ChatCompletionCreateParams.Builder builder = ChatCompletionCreateParams.builder().model(parameters.modelName());
        if (parameters.maxOutputTokens() != null && parameters.maxCompletionTokens() == null) {
            builder.maxTokens((long)parameters.maxOutputTokens().intValue());
        }
        if (parameters.maxCompletionTokens() != null) {
            builder.maxCompletionTokens((long)parameters.maxCompletionTokens().intValue());
        }
        if (parameters.logitBias() != null) {
            builder.logitBias(ChatCompletionCreateParams.LogitBias.builder().putAllAdditionalProperties(parameters.logitBias().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonValue.from(entry.getValue())))).build());
        }
        if (parameters.parallelToolCalls() != null) {
            builder.parallelToolCalls(parameters.parallelToolCalls().booleanValue());
        }
        if (parameters.seed() != null) {
            builder.seed((long)parameters.seed().intValue());
        }
        if (parameters.user() != null) {
            builder.user(parameters.user());
        }
        if (parameters.store() != null) {
            builder.store(parameters.store());
        }
        if (parameters.metadata() != null) {
            builder.metadata(ChatCompletionCreateParams.Metadata.builder().putAllAdditionalProperties(parameters.metadata().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonValue.from(entry.getValue())))).build());
        }
        if (parameters.serviceTier() != null) {
            builder.serviceTier(ChatCompletionCreateParams.ServiceTier.of((String)parameters.serviceTier()));
        }
        if (parameters.reasoningEffort() != null) {
            builder.reasoningEffort(ReasoningEffort.of((String)parameters.reasoningEffort()));
        }
        builder.messages(InternalOpenAiOfficialHelper.toOpenAiMessages(chatRequest.messages()));
        if (parameters.temperature() != null) {
            builder.temperature(parameters.temperature());
        }
        if (parameters.topP() != null) {
            builder.topP(parameters.topP());
        }
        if (parameters.frequencyPenalty() != null) {
            builder.frequencyPenalty(parameters.frequencyPenalty());
        }
        if (parameters.presencePenalty() != null) {
            builder.presencePenalty(parameters.presencePenalty());
        }
        if (parameters.stopSequences() != null) {
            builder.stop(ChatCompletionCreateParams.Stop.ofStrings((List)parameters.stopSequences()));
        }
        if (parameters.toolSpecifications() != null) {
            builder.tools(InternalOpenAiOfficialHelper.toTools(parameters.toolSpecifications(), strictTools));
        }
        if (parameters.toolChoice() != null) {
            builder.toolChoice(InternalOpenAiOfficialHelper.toOpenAiToolChoice(parameters.toolChoice()));
        }
        if (parameters.responseFormat() != null) {
            builder.responseFormat(InternalOpenAiOfficialHelper.toOpenAiResponseFormat(parameters.responseFormat(), strictJsonSchema));
        }
        return builder;
    }

    static enum ModelHost {
        OPENAI,
        AZURE_OPENAI,
        GITHUB_MODELS;

    }
}

